<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<script type="text/javascript" src="images/calendar.js"></SCRIPT>


<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>MailMerge Campaigns</h1>
<br>


<div class="row">
	<div class="col-md-6">
		MailMerge is used to send personalized outbound emails using a plugin. Prior to sending emails, you need to either upload a data file.
		The uploaded file is in Comma Separated Values (CSV) format, which can be created using a program like MS Excel or 
		<a href="http://web.synametrics.com/WinSQL.htm" target="_blank">WinSQL</a>.
		
		<h2>How it works</h2>
		Assume you need to send emails to your clients who did missed paying their invoices last month. You can save a list of these clients along with the 
		amount they owe and their due date into a CSV file. Upload this file to Xeams and then send one email that will be distributed to every recipient
		found in the CSV file.
		
		
		<%
		String infoMsg = (String) request.getAttribute("infoMsg");
		if(infoMsg != null){
			%>
			<br><br><div class="alert alert-success"><%=infoMsg %></div>
			<%
		}
		
		String errorMsg = (String) request.getAttribute("errorMsg");
		if(errorMsg != null){
			%>
			<br><br><div class="alert alert-danger"><h4>Error</h4><%=errorMsg %></div>
			<%
		}
		
		MailMergeDataValidationBean valBean = (MailMergeDataValidationBean) request.getSession().getAttribute("mmValidationBean");
		if(valBean != null){
			
			if(valBean.isViewedOnce()){
				%>
				<div class="alert alert-success">
				<a href="<%=response.encodeURL("FrontController?operation=250&st=vel") %>" title="Click to view invalid records that failed to upload">Click here</a> to view records that failed to upload.
				</div>
				<%
			}else{
				valBean.setViewedOnce(true);
				String alertType = valBean.getPercentFailure() == 100D ? "alert alert-danger" : "alert alert-success";
				%>
				<div class="<%= alertType %>">
					Data file uploaded successfully.
					<ul>
						<li>Total records: <%= valBean.getTotalRecords() %></li>
						<li>Total fields: <%= valBean.getTotalColumns() %></li>
						<li>Total errors: <%= valBean.getTotalInvalidRecords() %> <span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=250&st=vel") %>" title="Click to view invalid records that failed to upload"><span class="label label-default">Invalid Records</span></a></span></li>
					</ul>
					<%
					if(valBean.getTotalInvalidRecords() > 0){
						%>
						<br><br>The first column of every row MUST represent an email address. Data will be skipped if invalid data is found in the first column.
						<%
					}
					%>
				</div>
				<%
			}
		}
		
		%>
	</div>
	
	<div class="col-md-6">
		<!-- ******* Create Window Panel ******* -->
		<div class="well-info-wrap">
			<div class="well-info-header">New MailMerge</div>
			<div class="well-info-body">
			
				<form action="<%= request.getAttribute("appPath") %>" method="post">
					<!-- Friendly Name -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('fName')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Friendly Name:</span>
					<input class="form-control form-right pull-left wth-5" type="text" name="friendlyName" required >
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="fName">
						A friendly name for this MailMerge.
					</div>
					
					<!-- Subject -->
					<!-- 
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblSubject')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Subject Contains:</span>
					<input class="form-control form-right pull-left wth-5" type="text" name="subject" required>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblSubject">
						Subject of the outbound emails. Xeams will search for this string in every outbound email.
					</div>
					 -->
					<!-- Sender -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblSender')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Template Recipient Address:</span>
					<input class="form-control form-right pull-left wth-5" type="email" name="sender" required>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblSender">
						Email address where the template email is received. 
					</div>
					
					<!-- Start Date -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblStartDate')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Start Date:</span>
					<script type="text/javascript">DateInput('startDate', true, 'YYYYMMDD', '<%= request.getAttribute("startDate")%>')</script>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblStartDate">
						Start date for this MailMerge. Emails sent prior to this date will be ignored
					</div>
					
					<!-- End Date -->
					
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblEndDate')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">End Date:</span>
					<script type="text/javascript">DateInput('endDate', true, 'YYYYMMDD', '<%= request.getAttribute("endDate")%>')</script>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblEndDate">
						End date for the campaign. Emails sent after to this date will be ignored.
					</div>
					
					
					
					<!-- ******* Create Checkbox Input Field ******* -->
					<!-- 
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('subjectIsRegexX')"><b>?</b></div>
					<span class="form-control form-text form-middle pull-left wth-8">Subject is a regular expression</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="subjectIsRegex" type="checkbox" name="subjectIsRegex">
						<label for="subjectIsRegex"></label>
					</span>
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="subjectIsRegexX">
						Description Here
					</div>
					-->
				
					<br style="clear:both;">
					<br style="clear:both;">
					<!-- ******* Save Button | default is pulled right ******* -->
					<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
					
					<br style="clear:both;">
				
					<input type="hidden" name="addNew" value="1">
					<input type="hidden" name="operation" value="250">
				</form>
			</div>
		</div>
		
	</div>
</div>


<%

List<MailMergeBean> campaigns = (List<MailMergeBean>) request.getAttribute("mmRecords");
if(campaigns.size() > 0){
	%>
	<h1>Existing campaigns</h1>
	
	<table class="table table-hover table-condensed table-bordered">
		<thead>
			<tr>
				<th>Campaign Name</th>
				<th>Template Recipient</th>
				<th>Activation Date</th>
				<th>Total Recipients</th>
				<th>Action</th>
			</tr>
		</thead>
		
		<%
		for(int i = campaigns.size() - 1; i >= 0; i--){
			MailMergeBean oneCampaign = campaigns.get(i);
			int totalRecipients = oneCampaign.getRecordCount();
			%>
			<tr>
				
				<%if(oneCampaign.isActive()){ 
					%>
					<td><%= oneCampaign.getFriendlyName() %></td>
					<%
				}else{
					%>
					<td><del><%= oneCampaign.getFriendlyName() %></del> <span class="label label-danger pull-right">Expired</span></td>
					<%
				} %>
				
			
				<td><%= oneCampaign.getSender() %></td>
				<td><%= oneCampaign.getStartDateStr() %> - <%=oneCampaign.getEndDateStr() %></td>
				<td><% if(totalRecipients <= 0){
					%>
					<div id="<%= oneCampaign.getId() %>_anchor"><a onclick="javascript:showDiv('<%= oneCampaign.getId() %>')">Upload CSV file</a></div>
					
					<div style="display:none" id="<%= oneCampaign.getId() %>_form">
					<form action="<%= request.getAttribute("appPath") %>?operation=250&upload=1&mmid=<%= oneCampaign.getId()%>" method="post" enctype="multipart/form-data">
						<input type="file" value="Select CSV File" name="actualFile"> <input type="submit" value="Upload">
					</form>
					</div>
					<%
					}else{
						out.print(totalRecipients);
					}%>
				</td>
				
				<td>
				<a href="<%=response.encodeURL("FrontController?operation=250&st=details&id=" + oneCampaign.getId()) %>" title="Click to view the actual data"><i class="glyphicon glyphicon-search"></i> View Data</a>
				<span class="pull-right">
					<a href="<%=response.encodeURL("FrontController?operation=250&st=del&id=" + oneCampaign.getId()) %>" 
						title="Permanently delete this campaign"><i class="glyphicon glyphicon-trash"
						onclick="javascript:return confirm('This will permanently delete this campaign. Are you sure?')"
						></i> Delete</a></span>
				
				</td>
				
				
			</tr>
			<%
		}
		%>
		
	</table>
	<%
	
}

%>

<script>
function showDiv(id) {
    div = document.getElementById(id + "_form");
    div.style.display = "block";
    
    div2 = document.getElementById(id + "_anchor");
    div2.style.display = "none";
}
</script>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
