<%@ page import="java.util.*, com.synametrics.xeams.mailinglist.*" %>

<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<a href="<%=response.encodeURL("FrontController?operation=60") %>">Home</a> &raquo;
<a href="<%=response.encodeURL("FrontController?operation=152") %>">Manage Mailing List</a> &raquo;
Mailing/Discussion List Editor

<h1>Mailing/Discussion List Editor</h1>

<%

String errorMessage = (String)request.getAttribute("errorMessage");
String infoMessage = (String)request.getAttribute("infoMessage");


MailingListBean mailingList = (MailingListBean)request.getAttribute("mailingList");
String idx = (String)request.getAttribute("idx");

boolean subscribersExist = mailingList.getEmails().size() > 0;


if(mailingList == null){
	out.println("mailing list is null");
	return;
}

if(idx == null){
	out.println("idx is null");
	return;
}


if(errorMessage != null){
	out.println("<div class=\"alert alert-danger\"><h4>Error:</h4> " + errorMessage+ "</div>");
}

if(infoMessage != null){
	out.println("<div class=\"alert alert-info text-center\">" + infoMessage + "</div>");
}
%>

<div class="row">
	<br style="clear:both;"><br>
	<div class="col-md-6">
		<form action="<%= request.getAttribute("appPath") %>" method="post" class="inputFormTable">

			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('mailingListName')"><b>?</b></div>
			<span class="form-control form-text form-middle pull-left wth-4">Mailing List Name</span>
			<input class="form-control form-right pull-left wth-5" type="text" name="listName" value="<%=mailingList.getName() %>">
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="mailingListName">
				A name that is used to refer this mailing list. For example:
					
					<ul>
						<li>Sales Team, OR</li>
						<li>Engineering Team</li>
					</ul>
			</div>
			
			<br style="clear:both;"><br>
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('mailingListEmail')"><b>?</b></div>
			<span class="form-control form-text form-middle pull-left wth-4">Email Address</span>
			<input class="form-control form-right pull-left wth-5" type="text" name="listAddress" value="<%=mailingList.getListAddress() %>">
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="mailingListEmail">
				Email address for this mailing list. Any message sent to sent address will get forwarded to all
					recipients specified for this list. For example:
					<ul>
						<li>engineering@yourcompany.com, OR</li>
						<li>sales@yourcompany.com</li>
					</ul>
			</div>
			
			<br style="clear:both;"><br>
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('anonPosting')"><b>?</b></div>
			<span class="form-control form-text form-middle pull-left wth-8">Allow Anonymous Posting</span>
			<span class="chkbox-cust form-control form-right pull-left wth-1">
				<input id="chk-allowAnon" type="checkbox" name="allowAnonymous" <%=mailingList.isAcceptAnonymously() ? "checked='checked'" : "" %>>
				<label for="chk-allowAnon"></label>
			</span>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="anonPosting">
				Check this if you wish to allow non-members to send email to this group. For example, it is good idea to allow 
					any user to send message to your <b>Sales Team</b> group but not to <b>Engineering Team</b>.
			</div>
			
			<br style="clear:both;"><br>
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('allowSub')"><b>?</b></div>
			<span class="form-control form-text form-middle pull-left wth-8">Allow User to Subscribe</span>
			<span class="chkbox-cust form-control form-right pull-left wth-1">
				<input id="chk-allowSub" type="checkbox" name="chkAllowAutoSubscription" <%=mailingList.isAllowAutoSubscription() ? "checked='checked'" : "" %>>
				<label for="chk-allowSub"></label>
			</span>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="allowSub">
				The system will handle two additional emails if this box is checked.
					<ol>
						<li><b>subscribe-ListName@YourDomain.com</b> - Users can send a message to this email to subscribe for this mailing list</li>
						<li><b>unsubscribe-ListName@YourDomain.com</b> - Users can send a message to this email to un-subscribe for this mailing list</li>
					</ol>
					
					When this box is NOT checked, only administrator can add/modify subscribers.
					
					<br><br>For Example, if the email address of this mailing list is <b>engineering@yourCompany.com</b>,
					users can send a message to:
					<br>
					<b>subscribe-engineering@YourCompany.com</b> to add themselves in the list and<br>
					<b>unsubscribe-engineering@YourCompany.com</b> to remove themselves from the list
					<br><br>
					
					In either case <%=productName %> will send confirmation emails to verify the user.
			</div>

			<%if(!subscribersExist){ 
				
				if(!idx.equals("-1")){
				%>
				
				<br style="clear:both;"><br>
				<div class="titleSubTipOne btn btn-warning form-control form-left pull-left wth-1"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-4">Add A Subscriber</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="subscriberAddress" value="">
				
				<br style="clear:both;">
				<div id="titleSubTipOne_info" class="alert alert-warning">
					Subscriber's email address. Enter <b>one</b> subscriber at a time.
				</div>
				<%
				}
			} %>

		<br style="clear:both;">
		<button class="btn btn-sm btn-submit pull-right" type="submit">Save</button>
		<input type="hidden" name="operation" value="155" />
		<input type="hidden" name="idx" value="<%=idx %>" />
		<input type="hidden" name="modifyReplyTo" value="1" />
			
		<br style="clear:both;">
	</div>	 
	
	<% if(subscribersExist){ %>
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">List of Existing Subscribers</div>
			<div class="well-info-body no-padding">
				<table class="table table-striped table-bordered table-hover">
					<%
						for(int i = 0; i < mailingList.getEmails().size(); i++){
							String rowClass = (i % 2 == 0) ? "oddRow" : "evenRow";
						%>
						<tr class="<%=rowClass %>"><td><%=mailingList.getEmails().get(i) %></td>
						<td class="text-center"><a href="<%=response.encodeURL("FrontController?operation=156") %>&idx=<%=idx %>&edx=<%=i %>">Remove</a></td></tr>					
						<%
						}
					%>
					<tr><td>
							<input class="form-control form-left pull-left wth-8" type="text" name="subscriberAddress" placeholder="Add New Subscriber">
							<div class="titlesubscriberTip btn btn-warning form-control pull-left form-right wth-1"><b>?</b></div>
						</td>
						<td class="text-center">
							<button class="btn btn-sm btn-submit" type="submit">Add</button>
						</td></tr>
				</table>
				<div id="titlesubscriberTip_info" class="alert alert-warning" style="margin-top:-30px;">
					Subscriber's email address. Enter <b>one</b> subscriber at a time.
				</div>
			</div>
		</div>	
		<%
		}
		%>
	</div>
	</form>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
