<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Newsletters/Mailing List Subscription</h1>


<div class="row">
	<div class="col-md-4"></div>
	<div class="col-md-4">
		<div class="well well-sm">
		<center>
		<a href="https://www.xeams.com/newsletter-management.htm#video" target="_blank" title="Watch a video on this topic"><button class="btn btn-sm btn-menu">Watch A Video</button></a>
		</center>
		</div>
	</div>
</div>


<div class="row">
<div class="col-md-6">

<!-- ******* Create Window Panel ******* -->
<div class="well-info-wrap">
	<div class="well-info-header">Whitelisted Senders</div>
	<div class="well-info-body">
	
		<div class="well">
			<form action="<%= request.getAttribute("appPath") %>" method="post">
			
				<%
				if(request.getParameter("a") != null){
					%>
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('hostName')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">New Domain</span>
					<input class="form-control form-right pull-left wth-5" type="text" value="" placeholder="Sender's Domain Name" name="dm" required>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="hostName">
						Enter a domain name of the sender that you wish to whitelist.
					</div>
	
					<%
				}
				%>
				<!-- ******* Create Checkbox Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('rejectAll')"><b>?</b></div>
				<span class="form-control pull-left form-middle form-text wth-8">Reject every newsletter unless whitelisted</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chk-rejectAll" type="checkbox" name="rejectAll" <%=request.getAttribute("rejectAll")%> value="1">
					<label for="chk-rejectAll"></label>
				</span>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="rejectAll">
					If checked, newsletters from every sender will be blocked unless the sender appears 
					in the list below.		
				</div>
				
				
				
				
			
				<br style="clear:both;">
				<!-- ******* Save Button | default is pulled right ******* -->
				<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
				<input type="hidden" name="operation" value="mlnss">
				<input type="hidden" name="st" value="sr">
				<br style="clear:both;">
			
			</form>
		</div>
		
		
		
		
		<%
		List<String> acceptedNL = (List<String>) request.getAttribute("acceptedNL");
		if(acceptedNL == null || acceptedNL.size() == 0){
			%>
			<p>No domain have been whitelisted so far.</p>
			<%
		}else{
		%>
			<h2>Available Senders</h2>
			<p>Following domains have been whitelisted to receive newsletters.
			
			</p>
			
			<table class="table table-bordered table-hover">
				<thead>
				<tr>
					<th>Domain Name</th><th>Action</th>
				</tr>
				</thead>
				
				<%
				for(String oneDomain : acceptedNL){
					%>
				<tr>
					<td><%=oneDomain %></td>
					<td><a href="<%=response.encodeURL("FrontController?operation=mlnss&st=rm&dm=" + oneDomain) %>">Remove</a></td>
				</tr>
					<%
				}
				%>
			</table>
		<%} %>
	</div>
</div>


</div>
<div class="col-md-6">

<!-- ******* Create Window Panel ******* -->
<div class="well-info-wrap">
	<div class="well-info-header">Recent Senders</div>
	<div class="well-info-body">
		<p>You have received newsletters from the following senders in the past <b><%= request.getAttribute("staleDays") %></b> days.</p>
		<p><b>IMPORTANT: </b> When whitelisting domains, do NOT rely on <b>Sender's Name</b>, which can be forged. Look at the <b>Domain Name</b> instead.</p>
			
			
		<%
		List<NameValuePair> receivedNL = (List<NameValuePair>) request.getAttribute("receivedNL");
		if(receivedNL == null || receivedNL.size() == 0){
			%>
			You have not received any emails for newsletters. Try loading this screen after a couple of days to see 
			if you have received any messages
			<%
		}else{
		%>
			<h2>Whitelisted Domains for Newsletters</h2>
			<table class="table table-bordered table-hover">
				<thead>
				<tr>
					<th>Domain Name</th><th>Sender's Name</th><th>Action</th>
				</tr>
				</thead>
				
				<%
				for(NameValuePair oneDomain : receivedNL){
					%>
				<tr>
					<td><%=oneDomain.getName() %></td>
					<td><%=oneDomain.getValue() %></td>
					<td><a href="<%=response.encodeURL("FrontController?operation=mlnss&st=add&dm=" + oneDomain.getName()) %>">Whitelist Sender</a></td>
				</tr>
					<%
				}
				%>
			</table>
		<%} %>
		
		
	</div>
</div>


</div>
</div>









<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
