<!--NEWSKIN2015JP-->
<%@ page import="com.synametrics.xeams.config.*, com.synametrics.xeams.bean.*, com.synametrics.xeams.defaults.*" %>
<%@ page import="java.util.*" %>
<%

	List sideButtons = new ArrayList(5);
	sideButtons.add(new UrlAnchorHolder("Admin Home", "current", true));

	
//Variables for FAQ
boolean showFAQ = true;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "MainMenu");

boolean showCanvasGraphs = System.getProperty("use.canvas.for.graphs", "true").equals("true");


%>


<%@ include file="CommonButtons.jsp" %>
<%
if(request.getSession().getAttribute("authorizationLevel") != null &&
		((Integer)request.getSession().getAttribute("authorizationLevel")) >=  
				ResourceBean.AL_SUPER_USER ){
	    
	sideButtons.add(new UrlAnchorHolder("Restart Server", "FrontController?operation=70", false));
}
%>
<%@ include file="NewPageHeader.jsp" %>

<%
	if(authorizationLevel >= ResourceBean.AL_SUPER_USER ){
%>
<button id="server_clk" class="btn btn-xs btn-default pull-right">Server Options <span id="srvOpt_icon" class="glyphicon glyphicon-menu-down"></span></button>
<script>
	$("#server_clk").click( function(){
		$("#srvOpt_icon").toggleClass("glyphicon-menu-up");
	});
</script>
<% 
	} 
%>

<%@ include file="CurrentProfileName.jsp" %>

<div id="server_opt" style="display:none; position:absolute; right:30px; margin-top:25px; border:solid 1px #aaa; padding:15px; background-color:#eee; border-radius:0px 0px 5px 5px; opacity:0.95; z-index:5;">
	<ul class="list-unstyled text-right">
		<li><a href="FrontController?operation=166">Contact Support</a></li><br>
		<li><a href="FrontController?operation=263">Audit Logs</a></li><br>
		<li><a href="FrontController?operation=245">Access Control</a></li><br>
		<li><a href="FrontController?operation=68">Check for Updates</a></li><br>
		<li><a href="FrontController?operation=27">CSRF Config</a></li><br>
		<li><a href="FrontController?operation=70">Restart Server</a></li>
	</ul>
</div>

<script>
	$("#server_clk").click( function(){
		$("#server_opt").slideToggle();
	});
</script>

<%@ include file="LicenseWarning.jsp" %>

<br class="hide_lg">
<h1>Administrator's Control Panel</h1>



<%@ include file="ExpNote.jsp" %>


<%
if(!ResourceBean.isSpeedOk()){
	%>
	<div class="infoMessage" width="100%"><b>WARNING:</b> One or more tasks are not running at full speed. <a href="<%=response.encodeURL("FrontController?operation=169") %>">Click here</a> for details.</div>
	<%
}



if(ResourceBean.getRestartNotificationFile().exists() && authorizationLevel >= ResourceBean.AL_SUPER_USER){
	%>
	<div class="alert alert-success">
		<h4>Restart Required</h4>
		<%= ResourceBean.getRestartText() %>
		<br><br>
		<div class="text-center">
			<a href="<%=response.encodeURL("FrontController?operation=70") %>"><button class="btn btn-sm btn-submit">Restart Now</button></a>
		</div>
	</div>
	<%
}
%>

<div class="text-center">
	<span class="well" style="display:inline-table; padding:3px 5px; color:#555;"><span class="glyphicon glyphicon-time"></span> Running Since: <%=GlobalFuncs.formatDate(AppConfig.SERVER_START_TIME)%></span>
</div>



<%
boolean showProxy = com.synametrics.xeams.config.AppConfig.getInstance().isSmtpProxyServerEnabled();

if(showProxy){
%>
<div class="row">
	<div class="col-md-3 col-sm-6">
		<div class="well-info-wrap">
			<%@ include file="PanelSmtpStatus.jsp" %>
		</div>
	</div>
	
	<br class="hide_lg hide_md">
	<div class="col-md-3 col-sm-6">
		<div class="well-info-wrap">
			<%@ include file="PanelSmtpProxyStatus.jsp" %>
		</div>
	</div>
	
	<br style="clear:both;" class="hide_lg"><br class="hide_lg menu_hide_sm">
	<div class="col-md-3 col-sm-6">
		<div class="well-info-wrap">
			<%@ include file="PanelPop3Status.jsp" %>
		</div>
	</div>
	
	<br class="hide_lg hide_md">
	<div class="col-md-3 col-sm-6">
		<div class="well-info-wrap">
			<%@ include file="PanelImapProxyStatus.jsp" %>
		</div>
	</div>
	
</div> <!-- Added -->

<%
}else{
	%>
	<div class="row">
	<div class="col-md-4">
		<div class="well-info-wrap">
			<%@ include file="PanelSmtpStatus.jsp" %>
		</div>
	</div>
	<br class="hide_lg hide_md">
	<div class="col-md-4">
		<div class="well-info-wrap">
			<%@ include file="PanelPop3Status.jsp" %>
		</div>
	</div>
	<br class="hide_lg hide_md">
	<div class="col-md-4">
		<div class="well-info-wrap">
			<%@ include file="PanelImapProxyStatus.jsp" %>
		</div>
	</div>
	
	</div> <!-- Added -->
	
	<%
}
%>



<br style="clear:both;"><br class="menu_hide_sm">

<div class="row">

	
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Emails Received Since Midnight</div>
			<div class="well-info-body text-center">
				<!--  -->
				<%if(showCanvasGraphs){ %>
					<%@ include file="Chart24HourSummary.jsp" %>
				<%}else{%>
					<img src="ImageController?operation=8" alt="24_Hour_Report" style="max-width:100%;">
				<%}%>
			</div>
		</div>
	</div>
	
	<br class="hide_lg">
	<div class="col-md-6 text-center">
		<div class="sr-only"><%@ include file="PanelServerStatus.jsp" %></div>
		<div class="well-info-wrap">
			<div class="well-info-header">Emails Received for the Current Month</div>
			<%
			String sortOrder = request.getParameter("sortOrder");
			String year = request.getParameter("year");
			String month = request.getParameter("month");
			%>			
			<div class="well-info-body text-center">
		
				<%if(showCanvasGraphs){ %>
					<%@ include file="ChartMonthlySummary.jsp" %>	 
				<%}else{%>
					<img src="ImageController?operation=6
					<% if(year != null) out.write("&year=" +  year);%>
					<% if(month != null) out.write("&month=" +  month);%>
					<% if(sortOrder != null) out.write("&sortOrder=" +  sortOrder);%>
					" alt="24_Hour_Report" style="max-width:100%;">
				<%}%>
			</div>
		</div>		
	</div>

</div> <!-- Added -->
<br style="clear:both;"><br>
<div class="row">

	<div class="col-md-4 col-sm-4">
		<div class="well-info-wrap">
			<div class="text-center well-info-header">Server Status</div>
			<div class="well-info-body no-padding">
			
				<div>
					
					
					<%if(showCanvasGraphs){
						
						request.setAttribute("mdcGoodValue", "" + s_good);
						request.setAttribute("mdcPossibleValue", "" + s_possible);
						request.setAttribute("mdcSpamValue", "" + s_junk);
						%>
						
						<%@ include file="MsgDistributionChart.jsp" %>	
					
					<%}else{%>
						<img src="ImageController?w=350&operation=1&totalGood=<%=s_good %>&totalSpam=<%=s_junk %>&totalPossible=<%=s_possible %>" style="display:block; width:100%;">
					<%}%>
				</div>
				
				
				<table class="table table-condensed">
				
				
				<tr>
				<th>Total Good Messages:</th><td><%=s_good%></td>
				</tr>
				
				<tr>
				<th>Total Possible Junk:</th><td><%=s_possible%></td>
				</tr>
				
				<tr>
				<th>Total Junk Messages:</th><td><%=s_junk%></td>
				</tr>
				
				</table>
			</div>
			
			
		</div>
	</div>
	
	<br class="hide_lg hide_md">
	<div class="col-md-4 col-sm-4">
		<%@ include file="PanelTopDomains.jsp" %>
	</div>
	
	<br class="hide_lg hide_md">
	<div class="col-md-4 col-sm-4">
		<div class="well-info-wrap">
			<%@ include file="PanelDiskStatus.jsp" %>
		</div>
	</div>
	
	
</div> <!-- Added -->
<br style="clear:both;"><br>
<div class="row">
	
	
	
	
	<div class="col-md-6">
		<%@ include file="PanelMemoryStatus.jsp" %>
	</div>
	<div class="col-md-6">
		<%@ include file="PanelSmtpConnectionStatus.jsp" %>
	</div>

</div>
<br style="clear:both;"><br>
<%@ include file="NewPageFooter.jsp" %>

<%@ include file="PopupNews.jsp" %>

