<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Manage Administrators</h1>
<a href="<%=response.encodeURL("FrontController?operation=60") %>">Home</a> &raquo; Access Control
<br><br>
<%
String msgInfo = (String) request.getAttribute("msgInfo");
if(msgInfo != null){
	%>
	<div class="alert alert-info">
	<%=msgInfo %>
	</div>
	<%
}

String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger">
	<h4>Error</h4><%=errorMsg %>
	</div>
	<%
}
%>
<div class="row">
	<div class="col-md-6">
		<div class="well">
		
		<h4>Add/Modify Administrator Account</h4>
		<form action="<%= request.getAttribute("appPath") %>" method="post">
			<!-- ******* Create Text Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('UID')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">User ID</span>
			<input class="form-control form-right pull-left wth-5" type="text" name="uid" autocomplete="off" required>
		
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="UID">
				User ID for the account
			</div>
		
			
			<!-- ******* Create Text Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('PWD')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Password</span>
			<input class="form-control form-right pull-left wth-5" type="password" name="pwd" autocomplete="off">
		
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="PWD">
				Password for the account
			</div>
			
			<!-- ******* Create Text Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('PWD2')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Password Again</span>
			<input class="form-control form-right pull-left wth-5" type="password" name="pwd2" autocomplete="off">
		
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="PWD2">
				Password for the account
			</div>
			
			
			
			<!-- ******* Create Text Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('AllowedIP')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Allowed IP</span>
			<input class="form-control form-right pull-left wth-5" type="text" name="allowedIP">
		
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="AllowedIP">
				List of IP addresses separated by a "|" character. Use CIDR notation to specify a range.
			</div>
		
			<!-- ******* Save Button | default is pulled right ******* -->
			<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
			<br><br>
			
			<input type="hidden" name="operation" value="262">
			<input type="hidden" name="st" value="a">

			
		</form>
		
		</div>
		
	</div>
	<div class="col-md-2">
		
	</div>
	<div class="col-md-4">
		<div class="alert alert-success">
			<h4>TIP</h4>
			To modify an existing account, simply add a new entry using the same Login ID.
		</div>
	</div>
</div>






<!-- ******* Create Window Panel ******* -->
<h2>Existing Accounts</h2>
	<%
	Map<String, String> ipMap = (Map<String, String>) request.getAttribute("ipMap");
	Map<String, Integer> tfaStates = (Map<String, Integer>) request.getAttribute("tfaStates");
	List<String> theList = new ArrayList<String>();
	
	theList.addAll(ipMap.keySet());
	Collections.sort(theList);
	%>
	
	<table class="table table-bordered table-hover table-condensed">
		<tr>
			<th>Login ID</th>
			<th>2FA</th>
			<th>IP Restrictions</th>
			<th>Action</th>
		</tr>
		
		<%
		
		for(int i = 0; i < theList.size(); i++){
			String theLogin = theList.get(i);
			String ipRestrictions = ipMap.get(theLogin);
			Integer tfaState = tfaStates.get(theLogin);
			
			if(ipRestrictions == null || ipRestrictions.isEmpty()){
				ipRestrictions = "None";
			}
			%>
			<tr>
				<td><%= theLogin %></td>
				<td><% 
					if(tfaState == null || tfaState.intValue() <= 1 || tfaState.intValue() > 3){
						%><span style="color:#DDDDDD;"><i class="glyphicon glyphicon-subscript" title="2FA is disabled"> </i> Disabled</span><%
					}else if(tfaState == 2){
						%><a href="<%= response.encodeURL("FrontController?operation=2fa&lt=a&st=td&l=" + theLogin)%>"><span style="color:#8ab68c;"><i class="glyphicon glyphicon-subscript" title="2FA is enabled, click to disable it temporarily">  </i> Enabled</span></a><%
					}else{
						%><span style="color:#f09732;"><i class="glyphicon glyphicon-subscript" title="2FA is temporarily disabled" >  </i> Temporarily disabled</span><%
					}
				%></td>
				<td><%= ipRestrictions %></td>
				<td>
					<a href="<%=response.encodeURL("FrontController?operation=262&st=r&uid=" + theLogin) %>" title="Remove Admin"  onclick="javascript:return confirm('This will permanently delete the administrator. Are you sure?')">Remove</a> |
					<a href="<%=response.encodeURL("FrontController?operation=263&u=" + theLogin) %>" title="View Audit Logs">Audit Logs</a> 
				
				</td>
				
			</tr>
			<%
		}
		%>
	</table>
	








<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
