<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<style>
	input[type=checkbox]{
		visibility:visible;
	}
</style>

<h1>Forwarders Management</h1>
<div class="well text-center">
	Forwarders can be used to forward selective messages or all messages to another SMTP server. Consider the following example.
</div>

<div class="row">
	<div class="col-md-6">
		<img alt="Forwarder Example" src="images/ForwarderExample.gif" style="width:100%;">
	</div>
	
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Usage Tips</div>
			<div class="well-info-body">
			
			<p>Forwarders are used to forward emails to a secondary SMTP server. You can either forward message
				for a domain or a particular email address.</p>

			<b>Recipient's Address - </b>Forwarding is done based on recipients address. This value expects
			regular expressions.

			<p>
				<b>Sending ALL messages to a secondary server - </b>In order to send every messages to a secondary
			server, you need to add all domains that you want to forward. Although, it is possible to write a
			regular expression in the "Recipient's Address" field that will match with every recipient, we
			strongly discouraged doing it. Since <%=productName%> can handle outbound messages as well, it will
			end up sending even those messages to your secondary server.
			</p>

			<b>What happens if the secondary server is down - </b> <%=productName%> will put messages in the Outbound queue
			and will deliver them when the server comes up.
			</div>
		</div>
	</div>
</div>

<br style="clear:both;">
<div class="alert alert-info">
	Assume you have a backup email server that you want to use as a stand-by in case your
	primary email server goes down. Instead of manually backing up your emails and moving them to the backup machine you
	can use this forwarding mechanism to move your messages to the backup server.
</div>

<br style="clear:both;">
<h3>Existing Forwarders</h3>

<div class="well-info-wrap">
	<div class="table-responsive">
		<table class="table table-striped table-bordered table-hover">
			<tr class="well-info-header">
				<th>Recipient's address</th>
				<th>Forward to</th>
				<th>Message type</th>
				<th>Action</th>
			</tr>
<%
List<ForwarderHolderBean> forwarders = (List<ForwarderHolderBean>)request.getAttribute("Forwarders");

if(forwarders != null && forwarders.size() > 0){

%>

    <%
    String white = "#FFFFFF";
    String grey = "#EEEEEE";
    int counter = 0;

    %>

    <%
    	for(int i = 0; i < forwarders.size(); i++){
    		ForwarderHolderBean oneHolder = forwarders.get(i);
    %>
			<tr bgcolor="<%= ((counter++ % 2) == 0) ? white : grey%>">
				<td><%=oneHolder.getRecipientString()%></td>
				<td><%=oneHolder.getForwardTo()%></td>
				<td><%=oneHolder.getMsgType() == 1 ? "Good Messages" : "All Messages"%></td>
				<td class="text-center"><a href="<%=response.encodeURL("FrontController?operation=131") %>&i=<%=i%>">Remove</a></td>
			</tr>
    <%
    	}
    %>

<%
}
%>		
			<form action="<%= request.getAttribute("appPath") %>" method="post">
			<tr>
				<td><input class="form-control form-left pull-left wth-9" type="text" value="" name="txtRecipient" placeholder="New Recipient Address">
					<div class="btn btn-info form-control pull-left form-right wth-1" onclick="more_info('recipient')"><b>?</b></div></td>
					
				<td><input class="form-control form-left pull-left wth-9" type="text" value="" name="txtIPAddress" placeholder="Forward To Address">
					<div class="btn btn-info form-control pull-left form-right wth-1" onclick="more_info('fwdAddress')"><b>?</b></div></td>
					
				<td><span class="form-control form-left pull-left wth-1"><input  type="checkbox" checked="checked" name="chkGoodOnly"></span>
					<span class="form-control form-middle form-text pull-left wth-8">Only Good Messages</span>
					<div class="btn btn-info form-control pull-left form-right wth-1" onclick="more_info('onlyGood')"><b>?</b></div></td>
					
				<td class="text-center"><button class="btn btn-sm btn-submit" type="submit">Add</button></td>
			</tr>
			<input type="hidden"  name="operation" value="130"/>
			</form>
		</table>
		<div class="alert alert-info more_info" id="recipient" style="margin-top:-30px;">
		   This value is used to match the recipients name. You can use regular expressions. For example:
			<ul>
				<li><b>jackson@yourcompany.com</b> - Messages sent to jackson@yourcompany.com will get forwarded</li>

				<li><b>@yourcompany.com</b> - All messages sent to Yourcompany.com will get forwarded.</li>
			</ul>
		</div>
		
		<div class="alert alert-info more_info" id="fwdAddress" style="margin-top:-30px;">
		   IP Address of the machine where messages should be forwarded to.
		</div>
		
		<div class="alert alert-info more_info" id="onlyGood" style="margin-top:-30px;">
		   If checked, spam and possible spam messages will NOT get forwarded.
		</div>
	</div>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
