<%@ page import="com.synametrics.xeams.bean.*" %>
<%@ page import="java.util.*" %>
<%

List sideButtons = new ArrayList(5);
sideButtons.add(new UrlAnchorHolder("Managing Host File", "current", true));


//Variables for FAQ
boolean showFAQ = true;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "MainMenu");
%>

<%@ include file="CommonButtons.jsp" %>
<%@ include file="NewPageHeader.jsp" %>

<h1>Local Hosts File</h1>

<div class="row">
	<div class="col-md-2"></div>
	<div class="col-md-8">
		<div class="well">
			The local hosts file is used to resolve MX records for domains. If a domain name is found in this
			file <%= productName %> will not query a DNS server to lookup for an MX entry and will use the values
			specified in this file.
		</div>

		<div class="well-info-wrap">
			<div class="well-info-body no-padding table-responsive">
				<table class="table table-striped table-bordered table-hover">
					<tr class="well-info-header">
						<td><b>Domain Name</b></td>
						<td><b>IP Address</b></td>
						<td><b>Action</b></td>
					</tr>


					<%
					Enumeration<String> allEntries = (Enumeration<String>) request.getAttribute("allEntries");
					String rowColor;
					String whiteColor = "#FFFFFF";
					String greyColor = "#DDDDDD";

					int rowCount = 0;
					while(allEntries.hasMoreElements()){
						rowCount++;
						String name = (String)allEntries.nextElement();
						String value = ResourceBean.resolveNameFromLocalDNS(name, true);

						if((rowCount % 2) == 0){
							rowColor = whiteColor;
						}else{
							rowColor = greyColor;
						}

						%>
						<tr>
						<td><%=name%></td>
						<td><%=value%></td>
						<td class="text-center"><a href="<%=response.encodeURL("FrontController?operation=85&type=d") %>&name=<%=name%>">Remove</a></td>
						</tr>

						<%
					}
					%>
					
					<%
					if(rowCount == 0){
						out.print("<td colspan=\"3\" class=\"text-center\"><b>No entries are found in Local Hosts file</b></td>");
					}
					%>
					<form action="<%= request.getAttribute("appPath") %>" method="post">
					<tr>
						<td><input class="form-control" type="text" name="name" placeholder="Domain Name &nbsp; &nbsp; (Eg. yourCompany.com)"></td>
						<td><input class="form-control" type="text" name="value" placeholder="IP Address &nbsp; &nbsp; (Eg. 192.168.1.150)"></td>
						<td class="text-center"><button class="btn btn-sm btn-submit" type="submit">Add</button></td>
					</tr>
					<input type="hidden" name="operation" value="85" />
					<input type="hidden" name="type" value="i" />
					</form>
				</table>
			</div>
		</div>
	</div>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
