<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>API Key Manager</h1>



<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}

%>



<%
ApiKeyBean aNewBean = (ApiKeyBean) request.getAttribute("newBean");
if(aNewBean != null){
	%>
	<h2>API Key Added Successfully</h2>
	<p>Following API key has been added.
	<b>VERY IMPORTANT: </b> Save the value displayed for <b>Secret</b> in a safe place. This value will never be displayed again.
	<div class="well-info-wrap">
		<div class="well-info-header">Newly Created API Key</div>
		<div class="well-info-body">
			
		
			<table class="table table-condensed">
				<tr>
					<th>API Key</th><td>
						<div class="row">
							<div class="col-md-6">
								<div class="row">
									<div class="input-group">
										<input class="form-control" type="text" value="<%= aNewBean.getApiKey() %>" id="newApikey" readonly>
										<span class="input-group-addon"><button title="Copy to clipboard" onclick="c2clipboard('newApikey')" class="btn-link"><i class="fa fa-copy"></i></button></span>
									</div>
								</div>
							</div>
						</div>
					</td>
				</tr>
				<tr>
					<th>Secret</th><td>
						<div class="row">
							<div class="col-md-6">
								<div class="row">
									<div class="input-group">
										<input class="form-control" type="text" value="<%= aNewBean.getSecretValue() %>" id="newSecret" readonly>
										<span class="input-group-addon"><button title="Copy to clipboard" onclick="c2clipboard('newSecret')" class="btn-link"><i class="fa fa-copy"></i></button></span>
									</div>
								</div>
							</div>
							
							<div class="col-md-6">
								<b>Note: </b> Save this value. The system will not display this again.
							</div>
						</div>
					
						
						</td>
				</tr>
				
				<tr>
					<th>Testing URL</th>
					<td>
						<%
						String testUrl = ResourceBean.getConnectingUrl(request, false) + "/api/info?auth-key=" + aNewBean.getApiKey() + "&secret=" + aNewBean.getSecretValue();
						%>
						<a href="<%= testUrl%>" target="_blank"><%= testUrl%></a>
					
						
						</td>
				</tr>
				
				
			</table>
	
		</div>
	</div>
	
	<br><br>
	<%
	
}
%>







<script>
function c2clipboard(me) {
	  // Get the text field
	  var copyText = document.getElementById(me);

	  
	  // Select the text field
	  copyText.select();
	  copyText.setSelectionRange(0, 99999); // For mobile devices

	   // Copy the text inside the text field
	  navigator.clipboard.writeText(copyText.value);

	  // Alert the copied text
	  //alert("Copied the text: " + copyText.value);
	}
</script>




<style>
	input[type=checkbox]{
		visibility:visible;
	}
</style>


<%

List<ApiKeyBean> keys = (List<ApiKeyBean>) request.getAttribute("keys");

if(keys.size() == 0){
%>
	<div class="row">
		<div class="col-md-4">
			<div class="well-info-wrap">
				<div class="well-info-header">Add API Key</div>
				<div class="well-info-body">
				<%@ include file="MapiAddKey.jsp" %>
					
				</div>
			</div>
		</div>
		
		<div class="col-md-6 col-md-offset-2">
			<h2>What is an API Key</h2>
			<p>You will need a combination of <b>API Key</b> and <b>Secret</b> before making API calls. When creating an API Key, the 
			value for <b>Secret</b> will only displayed once on the screen. It is recommended you save these values in a safe place to
			prevent unauthorized use.</p>
		</div>
	</div>
	
<%
}else{
	%>
	<!-- Button trigger modal -->
		<button type="button" class="btn btn-submit" data-toggle="modal" data-target="#myModal" title="Add a new API key">
		  Add API Key
		</button>
		
		
		
		<h2>Existing Keys</h2>
		<table class="table table-bordered table-striped">
			<thead>
			<tr>
				<th>Friendly Name</th><th>API Key</th><th>Permissions</th><th>Created On</th><th>Action</th>
			</tr>
			</thead>
		
			<%
			
			String colorEnabled = "#008000";
			String colorDisabled = "#DDDDDD";
			for(int i = 0; i < keys.size(); i++){
				ApiKeyBean oneKey = keys.get(i);
				
				%>
				<tr>
					<td><%= oneKey.getFriendlyName()%></td>
					<td><%= oneKey.getApiKey()%></td>
					<td>
						<%
						String seColor = oneKey.isPermitted(ApiKeyBean.PERM_SEND_EMAILS) ? colorEnabled : colorDisabled;
						String seTitle = oneKey.isPermitted(ApiKeyBean.PERM_SEND_EMAILS) ? "Permitted to send emails." : "Not permitted to send emails.";
						
						String muColor = oneKey.isPermitted(ApiKeyBean.PERM_USER_MODIFICATION) ? colorEnabled : colorDisabled;
						String muTitle = oneKey.isPermitted(ApiKeyBean.PERM_USER_MODIFICATION) ? "Permitted to modify users and distribution list." : "Not permitted to modify users and distribution lists.";
						
						String mdColor = oneKey.isPermitted(ApiKeyBean.PERM_DOMAIN_MODIFICATION) ? colorEnabled : colorDisabled;
						String mdTitle = oneKey.isPermitted(ApiKeyBean.PERM_DOMAIN_MODIFICATION) ? "Permitted to modify domains." : "Not permitted to modify domains.";
						
						String raColor = oneKey.isPermitted(ApiKeyBean.PERM_ALLOW_RESTART) ? colorEnabled : colorDisabled;
						String raTitle = oneKey.isPermitted(ApiKeyBean.PERM_ALLOW_RESTART) ? "Permitted to restart." : "Not permitted to restart.";
						
						%>
						
						<a href="<%=response.encodeURL("FrontController?operation=mapip&st=cp&bt=" + ApiKeyBean.PERM_SEND_EMAILS + "&idx=" + i) %>" title="<%= seTitle%>">
							<span style="color:<%= seColor%>"><i class="glyphicon glyphicon-envelope"></i></span>	
						</a>
						
						
						
						<a href="<%=response.encodeURL("FrontController?operation=mapip&st=cp&bt=" + ApiKeyBean.PERM_USER_MODIFICATION + "&idx=" + i) %>" title="<%= muTitle%>">
							<span style="color:<%= muColor%>"><i class="glyphicon glyphicon-user"></i></span>	
						</a>
						
						
						
						<a href="<%=response.encodeURL("FrontController?operation=mapip&st=cp&bt=" + ApiKeyBean.PERM_DOMAIN_MODIFICATION + "&idx=" + i) %>" title="<%= mdTitle%>">
							<span style="color:<%= mdColor%>"><i class="glyphicon glyphicon-th-list"></i></span>	
						</a>
						
						
						
						<a href="<%=response.encodeURL("FrontController?operation=mapip&st=cp&bt=" + ApiKeyBean.PERM_ALLOW_RESTART + "&idx=" + i) %>" title="<%= raTitle%>">
							<span style="color:<%= raColor%>"><i class="glyphicon glyphicon-repeat"></i></span>	
						</a>
						
					
			
					
					
					</td>
					<td><%= oneKey.getCreationDateStr() %></td>
					<td><a href="<%=response.encodeURL("FrontController?operation=mapip&st=rm&idx=" + i) %>"
					onclick="javascript:return confirm('This will permanently delete this API key. Are you sure?')"
					><i class="glyphicon glyphicon-trash"></i> Revoke</a></td>
					
				</tr>
				<%
			}
			%>
		</table>
	<%
}
%>
	
	
	
	




<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>

<!-- Modal This must be outside the body tag to be displayed property-->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" styleXX="z-index:10000;">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel">Add Key</h4>
      </div>
      <div class="modal-body">
       <%@ include file="MapiAddKey.jsp" %>
      </div>
 
    </div>
  </div>
</div>
