<!-- ******** NEW_SKIN_2015 ******** -->

<%@ page import="com.synametrics.xeams.bean.*" %>
<%@ page import="java.util.*" %>
<%

List sideButtons = new ArrayList(5);
sideButtons.add(new UrlAnchorHolder("Memory Management", "current", true));

//Variables for FAQ
boolean showFAQ = true;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "MainMenu");
%>

<%@ include file="CommonButtons.jsp" %>
<%@ include file="NewPageHeader.jsp" %>


<%
    long max = Runtime.getRuntime().maxMemory(); 
    long allocated = Runtime.getRuntime().totalMemory();



    String allocStr = ResourceBean.getMemoryAllocated();
    String maxStr = ResourceBean.getMemoryMax();
    String allocColor;

    allocated = (allocated * 100)/ max;

    if(allocated < 90){
     	allocColor = "Green";
    }else{
     	allocColor = "Red";
    }
    %>

<h1>Memory Management for: <%= productName %></h1>
<br>
<div class="well">
	<%= productName %> is currently configured to use a maximum of <b><%=maxStr%></b>. You can change this value to a
	higher number if you see the allocated memory close to the maximum memory size. <%= productName %> will never use more
	than what you decide to use for Maximum memory.
</div>

<div class="row">
	<div class="col-md-6">
		<h3>Current memory status</h3>
		<table class="table">
		<tr>
			<td width="<%=allocated%>%" align="right" bgcolor="<%=allocColor%>">&nbsp;</td>
			<td width="<%=100 - allocated%>%" align="right" bgcolor="#CCCCCC">&nbsp;</td>
		</tr>
		<tr>
			<td width="<%=allocated%>%" align="right"><font size="-2"><%=allocStr%> Allocated</font></td>
			<td width="<%=100 - allocated%>%" align="right"><font size="-2"><%=maxStr%> Max</font>
			</td>
		</tr>
		</table>
		<%
		if(allocated < 75){
		%>
		<div class="alert alert-success text-center">
			At present, the allocated memory used by <%= productName %> is less than 75%. We do not recommend that you increase the
			maximum memory size at this time.
		</div>
		<%
		}else{
		%>
		<div class="alert alert-danger text-center">
			Allocated memory used by <%= productName %> is more than 75%. If this numbers stays above this watermark,
			you might want to increase the maximum memory to a higher number.
		</div>
		<%
		}
		%>
	</div>
	<div class="col-md-6">
		<br><br>
		<div class="well-info-green">
			<div class="well-info-header">Modify Maximum Memory Size</div>
			<div class="well-info-body no-padding">
				<div class="well-info-additional">
					<b>* NOTE:</b> If you allocate a higher value for Maximum Memory Size, <%= productName %> will only use it if needed.
				</div>
				
				<div style="padding:10px;">
				<form action="<%= request.getAttribute("appPath") %>" method="post">
					<%
						String errorMsg = (String)request.getAttribute("ErrorMsg");

						if(errorMsg != null){
							out.println("<p><font class=\"headtext\">ERROR: </font>" + errorMsg + "</p>");
						}
					%>
					<br>
					
					<span class="form-control form-left form-text pull-left wth-6">New Size for Maximum Memory</span>
					<input class="form-control form-middle pull-left wth-3 text-center" type="text" name="txtNewSize" value="<%=(max / 1024000L)%>">
					<span class="form-control form-right form-text pull-left wth-1 text-center">MB</span>
					
					<br style="clear:both;"><br>
					<button class="btn btn-sm btn-submit pull-right" type="submit">Proceed</button>
					<input type="hidden" name="operation" value="84"/>
				</form>
				<br style="clear:both;">
				</div>
			</div>
		</div>
	</div>
</div>

<br style="clear:both;"><br>
<div class="row">
	<div class="col-md-6">
		<div class="well-info-green">
			<div class="well-info-header">How much memory can I allocate to <%= productName %>?</div>
			<div class="well-info-body" style="padding:20px;">
			<p>Theoretically, on a 32-bit machine you can allocated up to 2GB on Windows/Linux/MAC and 4GB on Solaris, 
			provided you have that much memory on the machine. This limit is much higher on a 64-bit OS.
			From a program's perspective, a machine always has <b>PHYSICAL + VIRTUAL</b> memory.</p>
			<u><b>Example</u>:</b>
			If your machine has 1 GB of Physical memory and 1 GB of Virtual memory, you can allocate 
			up to 2 GB to <%= productName %>.
			However, we only recommend up to 1.75 GB in this case.
			</div>
		</div>
	</div>
	
	<br class="hide_lg"><br class="hide_lg">
	<div class="col-md-6">
		<div class="well-info-green">
			<div class="well-info-header">What happens if <%= productName %> runs out of memory?</div>
			<div class="well-info-body" style="padding:20px;">
				<p>If the memory usage in <%= productName %> reaches close to the maximum value it will:</p>
				<ul>
					<li>Slow down <%= productName %>.
					<li>Use a lot of CPU cycles trying to find memory pages that are not is use and can be freed.
					<li>Eventually, <%= productName %> will crash. However, in an event of an abnormal crash a watch-dog process
						will try to restart <%= productName %>, which is done without any human interaction. Once <%= productName %>
						is restarted it will free up all used memory.
				</ul>
			</div>
		</div>
	</div>
</div>

<%@ include file="InnerRightGrey.jsp" %>


<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
