<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Message Analysis</h1>

<%
MessageAnalysisBean aBean = (MessageAnalysisBean) request.getAttribute("aBean");
%>

<!-- ******* Create Window Panel ******* -->

<div class="row">
<div class="col-md-8 col-md-offset-2">

	
	
	
	<div class="well-info-wrap">
		<div class="well-info-header">Message Details</div>
		<div class="well-info-body">
			<table class="table table-bordered table-hover">
			
				<tr>
					<th>Direction:</th><td><%= aBean.getDirectionStr()  %></td>
				</tr>
				<tr>
					<th>Sender'IP Address:</th><td><%= aBean.getSendersIP() %></td>
				</tr>
				
				
				<tr>
					<th>FROM Header:</th><td><%= aBean.getHeaderFrom() %></td>
				</tr>
				
				<tr>
					<th>Envelope MAIL FROM:</th><td><%= aBean.getEnvelopeFrom() %></td>
				</tr>
				
				
			</table>
		</div>
	</div>
	
	<br>

	
	<div class="well-info-wrap">
		<div class="well-info-header">Analysis</div>
		<div class="well-info-body">
			
			<%if(aBean.isOutboundOrInternal()){
				%>
				Analysis is not performed on outbound or internal emails.
				<%
			}else{
				%> 
				
				
			<table class="table table-bordered table-hover">
				
				<%
				String thumbsUp = "<span style='color:green'><i class='glyphicon glyphicon-thumbs-up'></i></span>";
				String thumbsDown = "<span style='color:red'><i class='glyphicon glyphicon-thumbs-down'></i></span>";
				String thumbsDownFail = "<span style='color:blue'><i class='glyphicon glyphicon-thumbs-down'></i></span>";
				%>
				<tr>
					<th>PTR record:</th> <td><%= aBean.isPtrFound() ? thumbsUp : thumbsDown %></td> <td><%= aBean.getPtrRecord() %></td>
				</tr>
				
				<tr>
					<th>HELO host:</th><td><%= aBean.isHeloHostCorrect() ? thumbsUp : thumbsDown %></td><td><%= aBean.getHeloHost() %></td>
				</tr>
				
				<tr>
					<th>SSL/TLS used:</th><td><%=  aBean.isTLSUsedWhenReceiving() ? thumbsUp : thumbsDown %></td><td><%= aBean.isTLSUsedWhenReceiving() ? "Yes" : "No" %></td>
				</tr>
				
				
				<tr>
					<th>Envelope SMTP FROM matches From Header:</th>
					<td><%=  aBean.isEnvelopeMatchWithHeader() ? thumbsUp : thumbsDown %></td>
					<td><%= aBean.isEnvelopeMatchWithHeader() ? "Yes" : 
					"No. Check <a href='http://www.xeams.com/difference-envelope-header.htm'>this page</a> to learn the differences"%></td>
				</tr>
				<tr>
					<th>Reply-To matches:</th>
					<td><%= aBean.isReplyToMatches() ? thumbsUp : thumbsDown %></td>
					<td><%= aBean.isReplyToMatches() ? "Yes" : ("No. Reply-To value is set to " + aBean.getReplyTo()) %></td>
				</tr>
				
				<tr>
					<th>SPF results:</th>
					<td><% 
					if(aBean.getSpfResultStr().equalsIgnoreCase("none")){
						out.print("<acronym title='SPF record does not exist for this domain'>" + thumbsDown + "</acronym>");
					}else if(aBean.getSpfResultStr().equalsIgnoreCase("pass") || aBean.getSpfResultStr().equalsIgnoreCase("trustedpass")){
						out.print("<acronym title='SPF record exist and message came from designated source'>" + thumbsUp + "</acronym>");
					}else{
						out.print("<acronym title='SPF record exist but message did not came from designated source'>" + thumbsDownFail  + "</acronym>");
					}
					%></td>
					<td><%= aBean.getSpfResultStr() %></td>
				</tr>
				
				<tr>
					<th>DKIM signature:</th>
					<td><%= aBean.isDkimGood() ? thumbsUp : thumbsDown %></td>
					<td><%= aBean.getDkimResults() %></td>
				</tr>
				
				<tr>
					<th>DMARC published:</th>
					<td><%= aBean.isDmarcGood() ? thumbsUp : thumbsDown%></td>
					<td><%= aBean.getDmarcResults() %></td>
				</tr>
			</table>
			
			<%
			}
			%>
		</div>
	</div>
	
	<br>
	
	<div class="well-info-wrap">
		<div class="well-info-header">Intermediate Hops</div>
		<div class="well-info-body">
			<table class="table table-bordered table-hover">
				<thead>
				<tr><th>Hostname</th><th>IP Address</th><th>Date/Time</th><th>Delay</th></tr>
				</thead>
				<%
				List<TraceRecord> traceList = aBean.getTraceResults();
				TraceRecord previousRecord = null;
				String delayedData = " - ";
				for(int i = 0; i < traceList.size(); i++){
					
					if(i < traceList.size() - 1){
						previousRecord = traceList.get(i + 1);
					}else{
						previousRecord = null;
					}
					TraceRecord oneRect = traceList.get(i);
					%>
					<tr>
						<td><%= oneRect.getDomainName() %></td>
						<td><%= oneRect.getIP()%></td>
						<td><%= oneRect.getReceivedOnStr()%></td>
						<td><%= delayedData%></td>
					</tr>
					<%
					delayedData = oneRect.getDelayAsStr(previousRecord);
				}
				%>
			</table>
		</div>
	</div>
	
	
	

</div>
</div>



<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
