<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>


<script type="text/javascript" src="<%= imagePath %>calendar.js"></SCRIPT>

<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Message Catalog</h1>

<%
String todayMinusThree = (String)request.getAttribute("TodayMinusThree");
String todaysDate = (String)request.getAttribute("TodaysDate");

if(todayMinusThree == null) todayMinusThree = "20180505";
if(todaysDate == null) todaysDate = "20180508";

%>
<div class="row">
	<div class="col-md-6">
		<div class="alert alert-success">
		Display a summary of messages sent and received by individuals within a specific date range. This report display
		actual addresses where messages were received and does not combine associated addresses together. 
		</div>
	
	</div>
	<div class="col-md-6">
		<!-- ******* Create Window Panel ******* -->
		<div class="well-info-wrap">
			<div class="well-info-header">Search Criteria</div>
			<div class="well-info-body">
				<form action="<%= request.getAttribute("appPath") %>" method="post">
					<div class="row">
						<div class="col-md-6 col-xs-12">
							<b>Message type:</b>
							<select class="form-control" name="msgType">
								<option value="-1">All Types
								<option value="0">Junk Messages
								<option value="2">Possible Junk Messages
								<option value="1">Good Messages
							</select>
						</div>
						
						<br class="hide_lg" style="clear:both;"><br class="hide_lg">
						<div class="col-md-6 col-xs-12">
							
							<b>Filter:</b>
							<input class="form-control" type="text" name="txtSearchFor" value="<%= request.getParameter("txtSearchFor") == null ? "" : request.getParameter("txtSearchFor") %>">
						</div>
					</div>
					
					
					<br style="clear:both;">
					<div class="row">
						<div class="col-md-6 col-xs-12">
							<b>Start date:</b>
							<script type="text/javascript">DateInput('startDate', true, 'YYYYMMDD', '<%=todayMinusThree%>')</script>
						</div>
						
						<br class="hide_lg" style="clear:both;"><br class="hide_lg">
						<div class="col-md-6 col-xs-12">
							<b>End date:</b>
							<script type="text/javascript">DateInput('endDate', true, 'YYYYMMDD', '<%=todaysDate%>')</script>
						</div>
					</div>
					
					<br style="clear:both;">
					<button class="btn btn-sm btn-submit pull-right" type="submit">Search</button>
					<input type="hidden" name="operation" value="247">
					<br style="clear:both;">	
				</form>
			</div>
		</div>
	</div>
</div>


<%
List<MessageCatalogBean> resultList = (List<MessageCatalogBean>) request.getAttribute("resultList");
if(resultList != null){
	
	%>
	<br><br>
	<div class="row">
		<div class="col-md-6"><h1>Search Results</h1></div>
		<div class="col-md-6">
			<div class="pull-right">
				<a href="http://www.xeams.com/catalog-summary.htm" target="_blank" title="Click here for help"><i class="glyphicon glyphicon-question-sign"></i> Help</a> -
				Download raw data in CSV format 
				<a href="<%=response.encodeURL("FrontController?operation=247&dn=1&startDate=" + request.getParameter("startDate") +
				"&endDate=" + request.getParameter("endDate") + "&txtSearchFor=" + request.getParameter("txtSearchFor") + 
				"&msgType=" + request.getParameter("msgType")) %>">
				<button class="btn btn-submit" title="Click here to download file in CSV format.">Download</button>
				</a>
			</div>
		</div>
	</div>
	
	<div class="table-responsive">
	<table class="table table-condensed table-bordered table-hover">
	<thead>
		<tr>
			<th>Email Address</th>
			<th>Good</th>
			<th>Spam</th>
			<th>Possible Spam</th>
			<th>Inbound Count/Size</th>
			<th>Outbound Count/Size</th>
			<th>Total Size</th>
		</tr>
	</thead>
	<%
	
	for(MessageCatalogBean oneRecord : resultList){
	%>
		<tr>
			<td><%=oneRecord.getRecipient() %></td>
			<td><%=oneRecord.getGoodCount() %></td>
			<td><%=oneRecord.getSpamCount() %></td>
			<td><%=oneRecord.getPossibleSpamCount() %></td>
			<td><%=oneRecord.getInboundCount() %> - <%=oneRecord.getSizeInboundStr() %></td>
			<td><%=oneRecord.getOutboundCount() %> - <%=oneRecord.getSizeOutboundStr() %></td>
			<td><%=oneRecord.getTotalSizeStr() %></td>
			
		</tr>
	<%
	}
	%>
	</table>
	</div>
	<%
}
%>





<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
