<%@ page import="com.synametrics.xeams.bean.*" %>
<%@ page import="java.util.*" %>


<%

	List sideButtons = new ArrayList(5);
	sideButtons.add(new UrlAnchorHolder("Message Retention", "current", true));

	
//Variables for FAQ
boolean showFAQ = true;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "MessageRetention");
%>


<%@ include file="CommonButtons.jsp" %>
<%@ include file="NewPageHeader.jsp" %>

<h1>Message Retention Policy</h1>

<div class="row">
	<div class="col-md-3"></div>
	<div class="col-md-6">
		<div class="well">Every message that comes into the server is saved for a configurable number of days. 
			This screen is used to configure how long you want to retain messages.</div>
			
		<div class="well-info-wrap">
			<form action="<%= request.getAttribute("appPath") %>" method="post">
			<div class="well-info-header">Configuration</div>
			<div class="well-info-body no-padding">
				<div class="well-info-additional">
					<ul class="text-left">
					<b><u>IMPORTANT</u></b>
					<li>Specifying a value of <b style="font-family:courier;">-1</b> means messages are never deleted.</li>
					<li>Specifying a value of <b style="font-family:courier;">&nbsp;0</b> means messages are never retained. There are several side-effects when this value is set to zero:
						<ol>
							<li>You will never see messages in the <a href="<%=response.encodeURL("FrontController?operation=22") %>">Message Repository</a> for the category that is set to 0</li>
							<li>You won't see messages through either IMAP or POP3 server.</li>
							<li>You won't be able to mark a message as either good or junk</li>
						</ol>
					</li>
					</ul>
				</div>
				
				<div style="padding:10px;">
					<br style="clear:both;">
						<span class="form-control pull-left form-left form-text wth-5">Good Messages</span>
						<input class="form-control pull-left form-middle text-center wth-3" type="text" name="goodDays" value="<%= request.getAttribute("goodDays") %>">
						<span class="form-control pull-left form-right form-text text-center wth-2">day(s)</span>
						
					<br style="clear:both;"><br>
						<span class="form-control pull-left form-left form-text wth-5">Junk Messages</span>
						<input class="form-control pull-left form-middle text-center wth-3" type="text" name="junkDays" value="<%= request.getAttribute("junkDays") %>">
						<span class="form-control pull-left form-right form-text text-center wth-2">day(s)</span>
						
					<br style="clear:both;"><br>
						<span class="form-control pull-left form-left form-text wth-5">Possible Junk</span>
						<input class="form-control pull-left form-middle text-center wth-3" type="text" name="possibleJunkDays" value="<%= request.getAttribute("possibleJunkDays") %>">
						<span class="form-control pull-left form-right form-text text-center wth-2">day(s)</span>
					
					<br style="clear:both;">
				</div>

				<h3 class="text-center">Message Cache Days</h3>
				<div class="well-info-additional" style="border-top:solid 1px #aaa;">
					This represents the number of days to go back when displaying emails in <a href="<%=response.encodeURL("FrontController?operation=22") %>">Message Repository</a> without searching. 
					A higher number will require more memory. Recommended number for this parameter is 3 days.
					<br><br>
					<b>Note:</b> If you change this to a higher value, older message will not appear right away. For example, if you change this from 3 to 5, it will take 2 days before you see messages that
					are 5 days old.
				</div>
				
				<br>
				<div style="padding:10px;">
					<span class="form-control pull-left form-left form-text wth-5">Message Cache Days</span>
					<input class="form-control pull-left form-middle text-center wth-3" type="text" name="numDaysToDisplayMessagesWithoutSearch" value="<%= request.getAttribute("numDaysToDisplayMessagesWithoutSearch") %>">
					<span class="form-control pull-left form-right form-text text-center wth-2">day(s)</span>
				
					<br style="clear:both;"><br>
					<button class="btn btn-sm btn-submit pull-right" type="submit">Save</button>
					<input type="hidden" name="operation" value="171" />
					<br style="clear:both;">
				</div>
			</form>
			</div>
		</div>
	</div>
</div>
	
<%@ include file="NewPageFooter.jsp" %>