<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Migration Wizard <small>Select folders</small></h1>


<div class="row">
	<div class="col-md-6 col-md-offset-3">

<!-- ******* Create Window Panel ******* -->
<div class="well-info-wrap">
	<div class="well-info-header">Connection Parameters</div>
	<div class="well-info-body">
		Select folders you would like to import
		
		
		
		
		
		<form action="<%= request.getAttribute("appPath") %>" method="post">
			
			<% 
			List<NameIntegerPair> folders = (List<NameIntegerPair>) request.getSession().getAttribute("importFoldersList");
			if(folders.size() <= 1){
			%>
		
				<!-- ******* Create Text Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('folder')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Folder Name:</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="folder" required='required' value="Inbox">
			
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="folder">
					Folder name. This is applicable when using IMAP. This must be INBOX when using POP3.
				</div>
				
			<%
			}else{
				
				%>
				<table class="table table-condensed table-bordered">
				<thead>
					<tr><th>Folder Name</th><th>Message Count</th><th>Import</th></tr>
				</thead>
				
				<%
				int fIndex = 0;
				for(NameIntegerPair onePair : folders){
					
					int mCount = Integer.parseInt(onePair.getValue());
					%>
					<tr>
						<td><%= onePair.getName() %></td>
						<td><%= onePair.getValue() %></td>
						<td>
						<span class="chkbox-cust form-control form-right pull-left wth-6">
							<input type="checkbox" id="fi_<%=fIndex %>" name="fi_<%=fIndex %>" <%= (mCount > 0) ? "checked='checked'" : "" %>>
							<label for="fi_<%=fIndex %>"></label>
						</span>
						
						</td>
					</tr>
					<%
					fIndex++;
				}
				
				%>
				</table>
				<%
			}
			%>
			
		
		
		
		
			<!-- ******* Create Text Input Field ******* -->
			
			<% 
			List<String> userList = (List<String>) request.getAttribute("userList");
						
			if(userList.size() == 1){
				%>
				<input type="hidden" name="localUid" value="<%= userList.get(0)%>">
				<%
			}else{
			%>
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('localUid')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Local User ID:</span>
				<select class="form-control form-right pull-left wth-5" name="localUid">
					<% 
					for(String oneUser : userList){
						%>
						<option value="<%=oneUser %>"><%=oneUser %></option>
						<%
					}
					%>
				</select>
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="localUid">
					User ID of the local user in  <%= productName %>
				</div>
			<%
			}
			%>
		
			
			
			
			
			
			<!-- ******* Create Checkbox Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('deleteAfterImport')"><b>?</b></div>
			<span class="form-control form-text form-middle pull-left wth-8">Delete emails after import</span>
			<span class="chkbox-cust form-control form-right pull-left wth-1">
				<input id="delAfterImport" type="checkbox" name="deleteAfterImport" checked='checked'>
				<label for="delAfterImport"></label>
			</span>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="deleteAfterImport">
				Once emails are imported, they will be deleted from the remote server.
			</div>
			
			
			<%
			boolean displayLimitControls = System.getProperty("display.bounds.fields.4.import.wizard", "false").equals("true");
			
			if(displayLimitControls){
			%>
		
		    <!-- ******* Create Text Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('llimit')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Starting index:</span>
			<input class="form-control form-right pull-left wth-5" type="number" name="startingMsgNum" required='required' value="0">
		
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="llimit">
				Index of the first message to pull. A 0 or a less means pull every message. Consider specifying a positive value when 
				importing a large mailbox.
			</div>
			
			
			<!-- ******* Create Text Input Field ******* -->
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('ulimit')"><b>?</b></div>
			<span class="form-control form-middle form-text pull-left wth-4">Ending index:</span>
			<input class="form-control form-right pull-left wth-5" type="number" name="endingMsgNum" required='required'  value="0">
		
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="ulimit">
				Index of the last message to pull. A 0 or a less means pull every message. Consider specifying a positive value when 
				importing a large mailbox.
			</div>
			<%
			}else{
				%>
				<input type="hidden" name="startingMsgNum" value="0">
				<input type="hidden" name="endingMsgNum" value="0">
				
				<%
			}
			%>
			
			<br style="clear:both;">
			<br style="clear:both;">
			<!-- ******* Save Button | default is pulled right ******* -->
			<button class="btn btn-sm btn-submit pull-right" type="submit">Import</button>
			<input type="hidden" name="operation" value="240">
			<input type="hidden" name="st" value="create">
		</form>
		
		<br><br><br>
		
		
	</div>
</div>


</div>
</div>




<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
