<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>


<a href="<%=response.encodeURL("FrontController?operation=60") %>">Home</a> &raquo;
<a href="<%=response.encodeURL("FrontController?operation=6") %>">RBL Servers</a> &raquo;
RBL Server Editor

<h1>RBL Server</h1>

<%
RBLServerBean aServer = (RBLServerBean)request.getAttribute("BlackListServer");
String index = (String)request.getAttribute("Index");

if(aServer == null){
    aServer = ResourceBean.createDummyRBLServerBean();
    index = "-1";  //This means that this is a new server
}


%>
<br style="clear:both;">
<form action="<%= request.getAttribute("appPath") %>" method="post">
<div class="row">
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Configuration</div>
			<div class="well-info-body no-padding">
				<div style="padding:10px;">
					<span class="form-control form-left form-text pull-left wth-6"><b>Short Name</b></span>
					<input class="form-control form-right pull-left wth-4" name="txtShortName" value="<%= ((aServer.getShortName() == null) ? "" : aServer.getShortName()) %>" required >
					
					
					<span class="form-control form-left form-text pull-left wth-6"><b>Full Name</b></span>
					<input class="form-control form-right pull-left wth-4" name="txtFullName" value="<%= ((aServer.getFullName() == null) ? "" : aServer.getFullName()) %>" required >
					
					<span class="form-control form-left form-text pull-left wth-6"><b>Domain</b></span>
					<input class="form-control form-right pull-left wth-4" name="txtDomain" value="<%= (aServer.getDomain() == null ? "" : aServer.getDomain()) %>" required >
					
					<span class="form-control form-left form-text pull-left wth-6"><b>Lookup result</b></span>
					<input class="form-control form-right pull-left wth-4" name="txtResultIfBlackListed" value="<%= ((aServer.getResultIfBlackListed() == null) ? "" : aServer.getResultIfBlackListed())  %>" required>
					
					<span class="form-control form-left form-text pull-left wth-4">Web Site</span>
					<input class="form-control form-right pull-left wth-6" name="txtSiteUrl" value="<%= ((aServer.getSiteUrl() == null) ? "" : aServer.getSiteUrl()) %>">
					
					<span class="form-control form-left form-text pull-left wth-4">Lookup URL</span>
					<input class="form-control form-right pull-left wth-6" name="txtLookupUrl" value="<%= ((aServer.getLookupUrl() == null) ? "" : aServer.getLookupUrl()) %>">
					
					<span class="form-control form-left form-text pull-left wth-4">Log message</span>
					<input class="form-control form-right pull-left wth-6" name="txtMsgIfFound" value="<%= ((aServer.getMsgIfFound() == null) ? "" : aServer.getMsgIfFound())  %>">
					
					<span class="form-control form-left form-text pull-left wth-6"><b>Score</b></span>
					<input class="form-control form-right pull-left wth-4" name="txtScore" value="<%= aServer.getScore() %>" required>
					
					
					<br style="clear:both;"><br>
					<span class="form-control form-left form-text pull-left wth-9">Enabled</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="chk-list" type="checkbox" name="chkEnabled" <%=aServer.isEnabled()? "checked" : ""%> value="1">
						<label for="chk-list"></label>
					</span>
					
					<br style="clear:both;"><br>
					<span class="form-control form-left form-text pull-left wth-9">Check only first IP in the header</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="chk-firstIP" type="checkbox" name="chkFirstOnly" <%=aServer.isFirstIPOnly()? "checked" : ""%> value="1">
						<label for="chk-firstIP"></label>
					</span>
					
					<br style="clear:both;"><br>
					<span class="form-control form-left form-text pull-left wth-9">Reverse IP for DNS lookup</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="chk-revIP" type="checkbox" name="txtIPReversed" <%=aServer.isIpReversed()? "checked" : ""%> value="1">
						<label for="chk-revIP"></label>
					</span>
				</div>
				
				<br style="clear:both;"><br>
				
				<div class="text-center">Description:</div>
				<textarea rows=5 style="width:100%; border:none; border-top:solid 1px #aaa; background-color:#f3f3f3; padding:10px;" name="txtDescription"><%=aServer.getDescription()%></textarea>
 				
 				
 			
				<br style="clear:both;">
				<button class="btn btn-sm btn-submit pull-right" type="submit">Save</button>
			</div>
		</div>
	</div>
	<div class="col-md-6">
		<h2>Usage Tip</h2>
		
		Fields in <b>BOLD</b> are required.
		
		<dl class="dl-horizontal">
		  <dt>Short Name</dt>
		  <dd>A One-Word Name for the RBL Server</dd>
		  
		  <dt>Full Name</dt>
		  <dd>Full name is used to identify the server on the web interface</dd>
		  
		  <dt>Domain</dt>
		  <dd>This must refer to the DNS domain name for the RBL. RBL lookup will not work if this value is incorrect. Refer to publisher's website for a correct value. </dd>
		  
		  <dt>Lookup Result</dt>
		  <dd>Typically an IP address representing the result, such as 127.0.0.2. Refer to publisher's website for possible values.</dd>
		  
		  <dt>Web Site</dt>
		  <dd>URL for publisher's website. Use for reporting</dd>
		  
		  
		  <dt>Lookup URL</dt>
		  <dd>A URL for looking up the IP address on publisher's website.</dd>
		  
		  
		  <dt>Log Message</dt>
		  <dd>Message that appears in the reason if this RBL lookup succeeds</dd>
		  
		  <dt>Score</dt>
		  <dd>Spam Score</dd>
		  
		  <dt>Check only first IP</dt>
		  <dd>Xeams extracts the IP addresses from the message header. If this option is checked, lookup will be restricted to just the sender's IP</dd>
		  
		  <dt>Reverse IP</dt>
		  <dd>Most RBL publishers require reversing the IP address before performing a lookup. Check this box if IP reversing is required.</dd>
		  
		  <dt>Description</dt>
		  <dd>Use on the web interface to describe the RBL service</dd>
		</dl>
		
	</div>
</div>

<input type="hidden" name="index" value="<%=index%>">
<input type="hidden" name="operation" value="13">

</form>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>

