<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<script type="text/javascript" src="images/calendar.js"></SCRIPT>


<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Outbound Campaign Tracking</h1>
<br>


<div class="row">
	<div class="col-md-6">
		Outbound Campaign Tracking allow administrators to track outbound emails. It can tell you statistics like:
		<ul>
			<li>Number of emails sent</li>
			<li>Number of bounce-backs</li>
			<li>Number of non-deliverable</li>
			<li>Number of replies</li>
		</ul>
		<h2>How it works</h2>
		Assume you work for a school district and want to send an email to every parent about the new security measures adopted by the district.
		You can create an email campaign, specifying a subject line and a sender on the right hand side. Xeams will track every message that
		matching the subject and sender. 
		
		
		<%
		String infoMsg = (String) request.getAttribute("infoMsg");
		if(infoMsg != null){
			%>
			<br><br><div class="alert alert-success"><%=infoMsg %></div>
			<%
		}
		
		String errorMsg = (String) request.getAttribute("errorMsg");
		if(errorMsg != null){
			%>
			<br><br><div class="alert alert-danger"><h4>Error</h4><%=errorMsg %></div>
			<%
		}
		
		
		%>
	</div>
	
	<div class="col-md-6">
		<!-- ******* Create Window Panel ******* -->
		<div class="well-info-wrap">
			<div class="well-info-header">New Campaign</div>
			<div class="well-info-body">
			
				<form action="<%= request.getAttribute("appPath") %>" method="post">
					<!-- Friendly Name -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('campaignName')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Campaign Name:</span>
					<input class="form-control form-right pull-left wth-5" type="text" name="friendlyName" required >
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="campaignName">
						A friendly name for the campaign.
					</div>
					
					<!-- Subject -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblSubject')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Subject Contains:</span>
					<input class="form-control form-right pull-left wth-5" type="text" name="subject" required>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblSubject">
						Subject of the outbound emails. Xeams will search for this string in every outbound email.
					</div>
					
					<!-- Sender -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblSender')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Sender's Email:</span>
					<input class="form-control form-right pull-left wth-5" type="email" name="sender" required>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblSender">
						Sender's email address
					</div>
					
					<!-- Start Date -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblStartDate')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Start Date:</span>
					<script type="text/javascript">DateInput('startDate', true, 'YYYYMMDD', '<%= request.getAttribute("startDate")%>')</script>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblStartDate">
						Start date for the campaign. Emails sent prior to this date will be ignored
					</div>
					
					<!-- End Date -->
					
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblEndDate')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">End Date:</span>
					<script type="text/javascript">DateInput('endDate', true, 'YYYYMMDD', '<%= request.getAttribute("endDate")%>')</script>
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblEndDate">
						End date for the campaign. Emails sent after to this date will be ignored.
					</div>
					
					
					<!-- Unsubs URL -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblUnsubsUrl')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Unsubs URL:</span>
					<input class="form-control form-right pull-left wth-5" type="text" name="unsubsUrl" value="<%= request.getAttribute("unsubsUrl")%>">
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblUnsubsUrl">
						Anchor value for unsubscription URL. For example, you can have an anchor tag in your HTML that looks like:<br>
						<code>&lt;a href="<%= request.getAttribute("unsubsUrl")%>"&gt;Click here&lt;/a&gt; to unsubscribe.</code><br>
						At runtime, this tag will be replaced by a value that can be used by recipients to unsubscribe from your mailing list.
					</div>
					
					
					
					<!-- ******* Enable Tracking ******* -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('trackingEnabled')"><b>?</b></div>
					<span class="form-control form-text form-middle pull-left wth-8">Track Views and Clicks</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="tracking" type="checkbox" name="tracking">
						<label for="tracking"></label>
					</span>
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="trackingEnabled">
						If checked, tracking is enabled for views and clicks
					</div>
					
					
					
					<!-- ******* Subject is RegEx ******* -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('subjectIsRegexX')"><b>?</b></div>
					<span class="form-control form-text form-middle pull-left wth-8">Subject is a regular expression</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="subjectIsRegex" type="checkbox" name="subjectIsRegex">
						<label for="subjectIsRegex"></label>
					</span>
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="subjectIsRegexX">
						If checked, Subject field is treated as a regular expression
					</div>
		
				
					<br style="clear:both;">
					<br style="clear:both;">
					<!-- ******* Save Button | default is pulled right ******* -->
					<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
					
					<br style="clear:both;">
				
					<input type="hidden" name="addNew" value="1">
					<input type="hidden" name="operation" value="248">
				</form>
			</div>
		</div>
		
	</div>
</div>


<%

List<Campaign> campaigns = (List<Campaign>) request.getAttribute("campaigns");
if(campaigns.size() > 0){
	%>
	<h1>Existing campaigns</h1>
	
	<table class="table table-hover table-condensed table-bordered">
		<thead>
			<tr>
				<th>Campaign Name</th>
				<th>Subject</th>
				<th>Sender's Email</th>
				<th>Activation Date</th>
				<th>Message Count</th>
				<th>Action</th>
			</tr>
		</thead>
		
		<%
		
		for(int idx = campaigns.size() - 1; idx >= 0; idx--){
			
			Campaign oneCampaign = campaigns.get(idx);
			String campRowClass = "";
			
			if(oneCampaign.isMarkedAsDeleted()){
				campRowClass = " class='danger' ";
			}
			
			%>
			<tr <%= campRowClass %>>
				<%if(oneCampaign.isActive()){ 
					%>
					<td><%= oneCampaign.getFriendlyName() %></td>
					<%
				}else{
					%>
					<td><del><%= oneCampaign.getFriendlyName() %></del> <span class="label label-danger pull-right">Expired</span></td>
					<%
				} %>
				
				<td><%= oneCampaign.getSubject() %></td>
				<td><%= oneCampaign.getSender() %></td>
				<td><%= oneCampaign.getStartDateStr() %> - <%=oneCampaign.getEndDateStr() %></td>
				<td><%= oneCampaign.getTotalMessages() %></td>
				<td>
				<a href="<%=response.encodeURL("FrontController?operation=248&st=details&id=" + oneCampaign.getId()) %>" title="Show Details"><i class="glyphicon glyphicon-search"></i> Details</a>
				<span class="pull-right">
				
					<%
					if(oneCampaign.isMarkedAsDeleted()){
					%>
					<a href="<%=response.encodeURL("FrontController?operation=248&st=del&id=" + oneCampaign.getId()) %>" 
						title="Restore previously deleted campaign"
                    ><i class="glyphicon glyphicon-retweet"></i> Restore</a>
					<%	
					}else{
						%>
					<a href="<%=response.encodeURL("FrontController?operation=248&st=del&id=" + oneCampaign.getId()) %>" 
						title="Mark campaign as deleted"
                    ><i class="glyphicon glyphicon-trash"></i> Delete</a>
						<%	
					}
					%>
					
				</span>
				
				</td>
				
				
			</tr>
			<%
		}
		%>
		
	</table>
	<%
	
}

%>



<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
