<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Outbound Campaign <small>Details</small></h1>


<a href="<%=response.encodeURL("FrontController?operation=248") %>">&laquo; Campaigns</a>
<%
Campaign theCampaign = (Campaign) request.getAttribute("campaign");

%>
<!-- ******* Create Window Panel ******* -->
<div class="well-info-wrap">
	<div class="well-info-header">Details</div>
	<div class="well-info-body">
		<div class="row">
			<div class="col-md-7">
				<table class="table table-condensed table-bordered">
					<tr><th>Campaign Name:</th><td><%=theCampaign.getFriendlyName() %></td></tr>
					<tr><th>Subject:</th><td><%=theCampaign.getSubject() %></td></tr>
					<tr><th>Sender's Email:</th><td><%=theCampaign.getSender() %></td></tr>
					<tr><th>Total Messages:</th><td><%=theCampaign.getTotalMessages() %> 
						<span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=248&st=shlog&ext=.sent&id=" + theCampaign.getId()) %>"><i class="glyphicon glyphicon-menu-hamburger"></i> View Logs</a></span>
						</td></tr>
					<tr><th>Successfully Delivered:</th><td><%=theCampaign.getSuccessCount() %></td></tr>
					<tr><th>Non-Delivery Reports:</th><td><%=theCampaign.getTotalNDRs() %>
						<span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=248&st=shlog&ext=.ndr&id=" + theCampaign.getId()) %>"><i class="glyphicon glyphicon-menu-hamburger"></i> View Logs</a></span>
						</td></tr>
					<tr><th>Failures:</th><td><%=theCampaign.getTotalRejected() %>
						<span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=248&st=shlog&ext=.rejected&id=" + theCampaign.getId()) %>"><i class="glyphicon glyphicon-menu-hamburger"></i> View Logs</a></span>
						</td>
					</tr>
					<tr><th>Queued:</th><td><%=theCampaign.getTotalInQueue() %></td></tr>
					<tr><th>Replies:</th><td><%=theCampaign.getTotalReplies() %>
						<span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=248&st=shlog&ext=.replies&id=" + theCampaign.getId()) %>"><i class="glyphicon glyphicon-menu-hamburger"></i> View Logs</a></span>
						</td>
					</tr>
					
					<%
					if(theCampaign.isTrackingEnabled()){
						%>
					<tr><th>Views:</th><td><%=theCampaign.getTotalViews() %>
						<span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=248&st=shlog&ext=.viewed&id=" + theCampaign.getId()) %>"><i class="glyphicon glyphicon-menu-hamburger"></i> View Logs</a></span>
						</td>
					</tr>
					
					<tr><th>Clicks:</th><td><%=theCampaign.getTotalClicks() %>
						<span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=248&st=shlog&ext=.clicked&id=" + theCampaign.getId()) %>"><i class="glyphicon glyphicon-menu-hamburger"></i> View Logs</a></span>
						</td>
					</tr>
					
					<tr><th>Unsubscribed:</th><td><%=theCampaign.getTotalUnsubscribed() %>
						<span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=248&st=shlog&ext=.unsubs&id=" + theCampaign.getId()) %>"><i class="glyphicon glyphicon-menu-hamburger"></i> View Logs</a></span>
						</td>
					</tr>	
						<%
					}
					%>
					
				</table>
			</div>
			<div class="col-md-2"></div>
			<div class="col-md-3">
				<canvas id="myChart" width="300" height="300"></canvas>
				<script>
				var ctx = document.getElementById("myChart");
				var myChart = new Chart(ctx, {
				    type: 'pie',
				    data: {
				        labels: ["Success", "NDRs", "Failures", "Queued"],
				        datasets: [{
				            label: 'Status',
				            data: [<%=theCampaign.getSuccessCount() %>, <%=theCampaign.getTotalNDRs() %>, <%=theCampaign.getTotalRejected() %>, <%=theCampaign.getTotalInQueue() %>],
				            backgroundColor: [
				                'rgba(10, 99, 50, 0.2)',
				                'rgba(153, 0, 0, 0.2)',
				                'rgba(127, 10, 102, 0.2)',
				                'rgba(0, 60, 120, 0.2)'
				            ],
				            borderColor: [
				                'rgba(10, 99, 50,1)',
				                'rgba(153, 0, 0, 1)',
				                'rgba(127, 10, 102, 1)',
				                'rgba(0, 60, 120, 1)'
				            ],
				            borderWidth: 1
				        }]
				    }
				});
				</script>
			</div>
		</div>
	</div>
</div>


<%
List<String[]> logData = (List<String[]>) request.getAttribute("logData");
if(logData != null){
	String ext = request.getParameter("ext");
	String logTitle = "Error";
	if(ext.equals(Campaign.EXT_SENT)){
		logTitle = "Sent Messages Log";
	}else if(ext.equals(Campaign.EXT_NDR)){
		logTitle = "Non-Delivery Reports Log";
	}else if(ext.equals(Campaign.EXT_REPLIES)){
		logTitle = "Replies Received Log";
	}else if(ext.equals(Campaign.EXT_REJECTED)){
		logTitle = "Non-Delivery Reports Log";
	}else if(ext.equals(Campaign.EXT_CLICKED)){
		logTitle = "Number of users who clicked a link";
	}else if(ext.equals(Campaign.EXT_VIEWED)){
		logTitle = "List of users who viewed";
	}
	
	%>
	
	<br><br>
	<div class="row">
		<div class="col-md-6"><h2><%=logTitle %></h2></div>
		<div class="col-md-6">
		<div class="pull-right">
			<div class="alert alert-warning">
			<span class="label label-success">Note:</span> There is a 10 minutes delay when viewing logs.
			</div>
		</div>
		</div>
	</div>
	
	<%
	if(logData.size() == 0){
		%>
		No data exists for this log. Please note that there is up to 10 minutes delay before you will see data through this screen.
		<%
	}else{
	%>
	
	
		<table class="table table-bordered">
			<thead>
			<tr><th>Date</th><th>Email Address</th></tr>
			</thead>
			
			<%
			for(String[] oneLine : logData){
				%>
				<tr><td><%=oneLine[0] %></td><td><%=oneLine[1] %></td></tr>
				<%
			}
			%>
			
		</table>
		<%
	}
}
%>




<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
