<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Out-of-Office Notification</h1>
<br>

<%
String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><h3>Error</h3><%=errorMsg %></div>
	<%
}
%>

<script type="text/javascript" src="images/calendar.js"></SCRIPT>

<!-- ******* Existing notifications ******* -->

<%
String oofHeading = "Add a new notification";
if(request.getAttribute("id") != null && !request.getAttribute("id").equals("-1")){
	oofHeading = "Modify existing notification";
}
%>

<div class="row">
	<div class="col-md-6 col-xs-12">
		<div class="well-info-wrap">
			<div class="well-info-header"><%= oofHeading %></div>
			<div class="well-info-body">
				
				<div>
				<form action="<%= request.getAttribute("appPath") %>" method="post">
					<br style="clear:both;">
					<div class="col-md-6 col-xs-12">
						<b>Starting date:</b>
						<script type="text/javascript">DateInput('txtStartDate', true, 'YYYYMMDD', '<%= request.getAttribute("startDate") %>')</script>
					</div>
		
					<div class="col-md-6 col-xs-12">
						<b>Ending date:</b>
						<script type="text/javascript">DateInput('txtEndDate', true, 'YYYYMMDD', '<%= request.getAttribute("endDate") %>')</script>
					</div>
					
					<br style="clear:both;">
					<div class="col-md-12 col-xs-12">
						<b>Subject:</b>
						<br>
						<input type="text" name="txtSubject" class="form-control" value="<%= request.getAttribute("subject") %>">
						<br><br>
					</div>
					
					<br style="clear:both;">
					<div class="col-md-12 col-xs-12">
						<b>Message:</b>
						<br>
						
						<textarea name="txtMessage" class="form-control" rows="6"><%= request.getAttribute("oofBody") %></textarea>
						<br><br>
					</div>
				
				
					<!-- ******* Save Button | default is pulled right ******* -->
					<br style="clear:both;">
					<div>
					<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
					</div>
					
					<input type="hidden" name="id" value="<%= request.getAttribute("id") %>">
					<input type="hidden" name="operation" value="oof">
					<input type="hidden" name="ac" value="s">
				</form>
				<br style="clear:both;">
				</div>
				
			</div>
		</div>

	</div>
	<div class="col-md-6 col-xs-12">
	<h3>Existing Notifications</h3>
	
	<table class="table table-condensed table-bordered">
		<tr><th>Start Date</th><th>End Date</th><th>Action</th></tr>
		
		<%
		List<OofNotificationBean> existingBeans = (List<OofNotificationBean>) request.getAttribute("existingBeans");
		for(OofNotificationBean oneBean : existingBeans){
			%>
			<tr>
				<td><%= oneBean.getStartDateStr() %></td>
				<td><%= oneBean.getEndDateStr() %></td>
				<td><a href="<%=response.encodeURL("FrontController?operation=oof&ac=m&id=" + oneBean.getId()) %>">Modify</a> | 
				    <a href="<%=response.encodeURL("FrontController?operation=oof&ac=d&id=" + oneBean.getId()) %>">Delete</a></td>
			</tr>
			<%
		}
		
		%>
	</table>
	
	</div>
</div>






<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
