
<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Outbound Email Diagnostics</h1>
<br>

<div class="row">
	<div class="col-md-6" >
		<!-- ******* Create Window Panel ******* -->
		<div class="well-info-wrap">
			<div class="well-info-header">Diagnostics Parameters</div>
			<div class="well-info-body">
				<form action="<%= request.getAttribute("appPath") %>" method="post">
					<!-- ******* Create Text Input Field ******* -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('dName')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Domain Name</span>
					<%
					List<String> domains = (List<String>) request.getAttribute("domains");
					if(domains != null && domains.size() > 0){
						%>
						
						<select class="form-control form-right pull-left wth-5" name="d">
							<%
							for(String domain : domains){
								%><option value="<%=domain%>"><%=domain %></option><%
							}
							%>
						</select>
						<%
					}else{
						%>
						<input class="form-control form-right pull-left wth-5" type="text" name="d" required>
						<%
					}
					%>
					
					
					
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="dName">
						Domain name that you want to test.
					</div>
				
					<!-- ******* Create Checkbox Input Field ******* -->
					<br style="clear:both;">
					<!-- ******* Save Button | default is pulled right ******* -->
					<button class="btn btn-sm btn-submit" type="submit">Submit</button>
				
					<input type="hidden" name="operation" value="239">
				</form>
			</div>
		</div>
	</div>
	<div class="col-md-5 col-md-offset-1">
		<p>Use this page to test outbound emails from your Xeams to domains on the Internet. This test checks the following:</p>
		<ul>
			<li>Confirms your public IP address has a valid PTR record in the DNS server</li>
			<li>The SMTP HELO command is correctly specified</li>
			<li>SPF, DKIM and DMARC records exists for the selected domain</li>
			
		</ul>
		<p>It is important every test passes. Sending outbound emails can be interpreted as junk on the receiving end if one or more test fails.</p> 
	</div>

</div>


<%
OutboundDignosticsBean results = (OutboundDignosticsBean) request.getAttribute("results");
if(results != null){
	
	%>
	
	<h2>Diagnostic Results <small>Domain name: <%= request.getParameter("d") %></small></h2>
	<%
	if(results.getErrorMessage() != null){
		%>
		<div class="alert alert-danger">
			<h3>Error:</h3>
			
			<%= results.getErrorMessage() %>
			<%
			if(results.getErrorCode() == OutboundDignosticsBean.EC_CONN_TIMED_OUT){
				%>
				- This error occurs if outbound port TCP/25 is blocked by a firewall or your ISP.
				<%
			}
			%>
			
		</div>
		<%
	}else{
		
		String lblPass = "<span class='h4 text-success'><span class='glyphicon glyphicon-ok'></span> Passed</span>";
		String lblFail = "<span class='h4 text-danger'><span class='glyphicon glyphicon-remove'></span> Failed</span>";
		String lblSkipped = "<span class='h4 text-muted'><span class='glyphicon glyphicon-ban-circle'></span> Skipped</span>";
		String lblError = "<span class='h4 text-warning'><span class='glyphicon glyphicon-wrench'></span> Error</span>";
	%>
		
		<table class="table table-bordered">
			<tr>
				<th>Test&nbsp;Name&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
				<th>Results&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th><th>Description</th>
			</tr>
			
			<!-- 
			<tr>
				<td>Encryption used</td>
				<td><%= results.isStartTlsUsed() ? lblPass : lblFail %></td>
				<td><%
					if(results.isStartTlsUsed()){
						%>
						Outbound emails are encrypted using STARTTLS
						<%
					}else{
						%>Outbound emails are not encrypted using STARTTLS. Encryption is getting increasingly popular and you should consider
						using this technology when sending outbound emails, which prevents unauthorized parties to sniff messages.<br><br>
						Visit <a href="http://xeams.com/StartTLS.htm" target="_blank">http://xeams.com/StartTLS.htm</a> for details.
						<%
					}
				%></td>
				
			</tr>
			
			-->
			
			<tr>
				<td>Local Domain</td>
				<td><%= results.isLocalDomain() ? lblPass : lblFail %></td>
				<td><%
					if(results.isLocalDomain()){
						%>
						<b><%= request.getParameter("d") %></b> is a valid local domain.
						<%
					}else{
						%>
						<b><%= request.getParameter("d") %></b>  is not configured as a local domain. You must add 
						<b><%= request.getParameter("d") %></b> as a valid domain under <b>SMTP Server Configuration</b>
						<%
					}
				%></td>
				
			</tr>
			
			
			<tr>
				<td>HELO Greeting</td>
				<td><%= results.isHeloGood() ? lblPass : lblFail %></td>
				<td><%
					if(results.isHeloGood()){
						%>The HELO greeting for outbound emails is set to <%= results.getHeloString() %>, which matches with your PTR record when a reverse lookup is done on <%= results.getConnectingIP() %>
						
						<%
					}else{
						%>
						The HELO/EHLO greeting does not match with the IP address. Refer to the following values:<br><br>
						<ul>
							<li>Your public IP is: <b><%= results.getConnectingIP() %></b></li>
							<li>Value for the HELO/EHLO greeting was: <b><%= results.getHeloString() %></b> </li>
							<li>Reverse lookup on the domain specified in HELO: <b><%= results.getHeloDomainIP() %></b></li>
						</ul> 
						<br><br>
						This test failed because domain name specified in HELO (<%= results.getHeloString() %>) does not resolve to <%= results.getConnectingIP() %>. Please refer to 
						<a href="http://www.xeams.com/validhelo.htm#outbound" target="_blank">Best practices for specifying HELO/EHLO</a> on Xeam's website for details.<br><br>
						
						<div class="alert alert-danger">
						Failure to solve this issue could lead to getting your IP address blacklisted on several RBL servers on the Internet.
						</div>
						<%
					}
				%></td>
			</tr>
			
			
			<tr>
				<td>Reverse Lookup</td>
				<td><%= results.isReverseLookupResolved()? lblPass : lblFail %></td>
				<td><%
					if(results.isReverseLookupResolved()){
						%>A reverse DNS lookup on <%= results.getConnectingIP()%>, which matches with the HELO string
						is done on <%= results.getHeloString() %>
						
						<%
					}else{
						%>
						A reverse DNS lookup on <%= results.getConnectingIP()%> does not resolve to the value specified
						in the HELO string. Expected value: <code><%= results.getHeloString() %></code>, 
						actual value: <code><%= results.getReverseLookupValue()%></code>. 
						<br><br>
						
						<% if(results.isHeloGood()){ %>
							You need to contact your ISP and have them put <%= results.getHeloString() %> as a PTR record for your IP address 
							(<%= results.getConnectingIP()%>). Note that PTR records are typically entered in the DNS server of your ISP, which 
							is the entity that owns the IP address.
						<%}else{ %>
							You need to resolve the <b>HELO greeting</b> test (see above) before fixing this problem.
						<%} %>
						
						<br><br>
						<div class="alert alert-danger">
						Failure to solve this issue could lead to getting your IP address blacklisted on several RBL servers on the Internet.
						</div>
						<%
					}
				%></td>
			</tr>
			
			
			<tr>
				<td>SPF Check</td>
				<td>
					<%
					if(results.getSpfResults().equals(OutboundDignosticsBean.NA) || results.getSpfResults().equals(XeamsSpfErrorConstants.NONE_CONV)){
						out.print(lblSkipped);
					}else if(results.getSpfResults().equals(XeamsSpfErrorConstants.PASS_CONV)){
						out.print(lblPass);
					}else{
						out.print(lblFail);
					}
					%>
				
				</td>
				<td>
					<%
					if(results.getSpfResults().equals(OutboundDignosticsBean.NA) || results.getSpfResults().equals(XeamsSpfErrorConstants.NONE_CONV)){
						%>
						
						<div class="row">
							<div class="col-md-8">
							No SPF record exists for <code><%= request.getParameter("d") %></code>, which is very important to ensure proper 
							message delivery. 
							</div>
							
							<div class="col-md-4">
								<%= new DnsSubmitter().cpBtn4(request, request.getParameter("d"), "v=spf1 a mx -all", "txt", false) %>
								<a class="btn btn-default btn-sm" href="https://www.xeams.com/spf.htm" target="_blank" title="Click to learn more about DKIM">More Info</a>
							</div>
						</div>
						
						
					
		
						
						<%
					}else if(results.getSpfResults().equals(XeamsSpfErrorConstants.PASS_CONV)){
						%>
						The IP address <b><%= results.getConnectingIP() %></b> is among the designated list of IP addresses where emails can be sent for <%= request.getParameter("d") %>
						<%
					}else{
						%>
						Outbound emails are sent from <b><%= results.getConnectingIP() %></b>. However, your SPF record does not designate this IP address as a valid IP that can send outbound 
						messages. The easiest way to fix this problem is to update your SPF record to include <b><%= results.getConnectingIP() %></b>. For example:
						<pre>v=spf1 <%= results.getConnectingIP() %>/32 ...</pre>
						<%
					}
					%>
				</td>
			</tr>
			
			<tr>
				<td>DKIM Check</td>
				<td>
					<%
					//Possible DKIM values: NO_SIGNATURE, PASS, PERM_FAIL, TEMP_FAIL, ERROR
					if(results.getDkimResults().equals(OutboundDignosticsBean.NA) || results.getDkimResults().equalsIgnoreCase("NO_SIGNATURE")){
						out.print(lblSkipped);
					}else if(results.getDkimResults().equalsIgnoreCase("PASS")){
						out.print(lblPass);
					}else if(results.getDkimResults().equalsIgnoreCase("PERM_FAIL")){
						out.print(lblFail);
					}else if(results.getDkimResults().equalsIgnoreCase("TEMP_FAIL") || results.getDkimResults().equalsIgnoreCase("ERROR")){
						out.print(lblError);
					}else{
						out.print(lblSkipped);
					}
					%>
				</td>
				<td>
					<%
					
					//Possible DKIM values: NO_SIGNATURE, PASS, PERM_FAIL, TEMP_FAIL, ERROR
					if(results.getDkimResults().equals(OutboundDignosticsBean.NA) || results.getDkimResults().equalsIgnoreCase("NO_SIGNATURE")){
						%>
						
						<div class="row">
							<div class="col-md-8">
							DKIM test was not performed. This happens when you have not configured this domain for DKIM. 
							</div>
							
							<div class="col-md-4">
								<a class="btn btn-submit btn-sm" href="<%=response.encodeURL("FrontController?operation=221") %>" title="Create a DKIM record">Create</a>
								<a class="btn btn-default btn-sm" href="https://www.xeams.com/dkim.htm" target="_blank" title="Click to learn more about DKIM">More Info</a>
							</div>
						</div>
						
						
					
						<%
					}else if(results.getDkimResults().equalsIgnoreCase("PASS")){
						%>
						Outgoing emails for <%= request.getParameter("d") %> are successfully signed and verified by the receiving end.
						<%
					}else if(results.getDkimResults().equalsIgnoreCase("PERM_FAIL")){
						%>
						DKIM signature for <%= request.getParameter("d") %> cannot be verified. Ensure the public key value is entered correctly in your DNS server. 
						<a href="FrontController?operation=221&st=vd&dn=<%= request.getParameter("d") %>">Click here</a> to see the value of public key that you need to enter in your DNS server.
						<%
					}else if(results.getDkimResults().equalsIgnoreCase("TEMP_FAIL") || results.getDkimResults().equalsIgnoreCase("ERROR")){
						%>
						DKIM verification failed due to a temporary error. Please try again later.
						<%
					}else{
						%>
						This diagnostic check ran into some unexpected error. Result value is <%=results.getDkimResults() %>.
						<%
					}
					%>
				</td>
				
			</tr>
			
			
			<tr>
				<td>DMARC Check</td>
				<td>
				<%
				//Possible DMARC return strings: daNotApplicable, daAligned, daNotAligned
				if(results.getDmarcResults().equals(OutboundDignosticsBean.NA)){
					out.print(lblSkipped);
				}else if(results.getDmarcResults().equals(OutboundDignosticsBean.MISSING)){
					out.print(lblSkipped);
				}else if(results.getDmarcResults().equalsIgnoreCase("daAligned")){
					out.print(lblPass);
				}else if(results.getDmarcResults().equalsIgnoreCase("daNotAligned")){
					out.print(lblFail);
				}else{
					out.print(lblError);
				}
				%>
				</td>
				<td>
				<%
				/* 
				DKIM_ALIGNED = 1;
				SPF_ALIGNED = 2;
				DKIM_SIG_MISSING = 4;
				SPF_FAILED = 8;
				SPF_SOFTFAIL = 16;
				SPF_MISSING = 32;
				*/
				
				
				if(results.getDmarcResults().equals(OutboundDignosticsBean.NA)){
					%>
					
					<div class="row">
						<div class="col-md-8">
						Test was skipped because envelope FROM was missing from the email.
						</div>
						
						<div class="col-md-4">
							<a class="btn btn-submit btn-sm" href="<%=response.encodeURL("FrontController?operation=235") %>" title="Create a DMARC record">Create</a>
							<a class="btn btn-default btn-sm" href="https://www.xeams.com/dmarc.htm" target="_blank" title="Click to learn more about DMARC">More Info</a>
						</div>
					</div>
					
					
					<%
				}else if(results.getDmarcResults().equals(OutboundDignosticsBean.MISSING)){
					%>
					
					
					<div class="row">
						<div class="col-md-8">
						No TXT record was found for <b>_dmarc.<%= request.getParameter("d") %></b> in the DNS.
						</div>
						
						<div class="col-md-4">
							<a class="btn btn-submit btn-sm" href="<%=response.encodeURL("FrontController?operation=235&d=" + request.getParameter("d")) %>" title="Create a DMARC record">Create</a>
							<a class="btn btn-default btn-sm" href="https://www.xeams.com/dmarc.htm" target="_blank" title="Click to learn more about DMARC">More Info</a>
						</div>
					</div>
						
						
						
					<%
				}else if(results.getDmarcResults().equalsIgnoreCase("daAligned")){
					%>
					Your DMARC record is aligned with SPF and/or DKIM signature is valid. As a result, DMARC is aligned as well.
					<%
				}else if(results.getDmarcResults().equalsIgnoreCase("daNotAligned")){
					%>
					A DMARC alignment can fail due to several reasons. These are:
					<ul>
						<%
						int bitmap = results.getDmarcResultsBitmap();
						
						if((bitmap & 1) != 1){
							%><li>Domain name used in DKIM signature is not the same domain used in MAIL FROM for SMTP envelope</li><%
						}
						
						if((bitmap & 2) != 2){
							%><li>Domain name used in MAIL FROM does not match with the FROM header</li><%
						}
						if((bitmap & 4) == 4){
							%><li>No DKIM signature found. Having a DMARC record in DNS without DKIM is not recommended</li><%
						}
						if((bitmap & 8) == 8){
							%><li>SPF failed.</li><%
						}
						if((bitmap & 16) == 16){
							%><li>A soft fail occurred on SPF test.</li><%
						}
						if((bitmap & 32) == 32){
							%><li>No SPF record was found in the DNS. Having a DMARC without SPF is of little value. It is strongly recommended you add an SPF record for <%= request.getParameter("d") %></li><%
						}
						
						%>
					</ul>
					<%
				}else{
					%>
					An unexpected error occurred.
					<%
				}
				
				%>
				</td>
			</tr>
			
			
			
			<tr>
				<td>MTA-STS</td>
				<td><%= results.isMtaStsEnabled()? lblPass : lblFail %></td>
				<td><%
					if(results.isMtaStsEnabled()){
						%>MTA-STS is enabled for the domain. Servers supporting this feature will use encryption when communicating and will send TLS reports.
						<%
					}else{
						%>
						
						
						<div class="row">
						<div class="col-md-8">
						MTA-STS is not enabled for <b>_mta-sts.<%= request.getParameter("d") %></b>.
						Enabling this feature ensures encryption is used when sending or receiving emails for this domain.
						</div>
						
						<div class="col-md-4">
							<a class="btn btn-submit btn-sm" href="<%=response.encodeURL("FrontController?operation=tlsrpt&sd=" + request.getParameter("d")) %>" title="Configure MTA-STS for this domain.">Create</a>
							<a class="btn btn-default btn-sm" href="https://www.xeams.com/configuring-mta-sts.htm" target="_blank" title="Click to learn more about MTA-STS">More Info</a>
						</div>
					</div>
					
					
						 <a href="<%=response.encodeURL("FrontController?operation=tlsrpt&sd=" + request.getParameter("d")) %>">Click here</a> to configure MTA-STS for this domain. 
						  
						<%
					}
				%></td>
			</tr>
			
			
			
			<!-- 
			<tr>
				<td></td>
				<td></td>
				<td></td>
			</tr>
			-->
		</table>
	
	
	<%
	}
}
%>




<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
