<!--NEWSKIN2015JP-->
<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*, java.io.*" %>




<%
	File file = new File(request.getAttribute("repPath") == null ? "/" : request.getAttribute("repPath").toString());
	File repParent = file.getParentFile();
	if(repParent == null){
		repParent = file;
	}
	
	long _dtotalSpace = file.getTotalSpace();
	long _dtotalFree = file.getFreeSpace();
	long _dtotalUsed = _dtotalSpace - _dtotalFree;

	if(_dtotalSpace == 0) _dtotalSpace = 1;
	
	
	int _dtotalWidth = 296;
	
	int _dpercentUsed = (int)((_dtotalUsed * 100) / _dtotalSpace);
	int _dpercentFree = 100 - (_dpercentUsed);
	
	int _dredWidth = _dpercentUsed * _dtotalWidth / 100;
	int _dblueWidth = _dpercentFree * _dtotalWidth / 100;
	
	String _dtotalString = GlobalFuncs.formatFileSize(_dtotalSpace);
	String _dusedString = GlobalFuncs.formatFileSize(_dtotalUsed);
	String _dfreeString = GlobalFuncs.formatFileSize(_dtotalFree);
%>

<div class="well-info-green">
	<div class="text-center well-info-header">Disk Status
	
	<%
	if(authorizationLevel >= ResourceBean.AL_SUPER_USER ){
	%>
	<a class="pull-right" title="Click for more information" href="<%=response.encodeURL("FrontController?operation=mngdu") %>"><span class="glyphicon glyphicon-search"></span> &nbsp; </a>
	<%
	} %>	
	</div>
	<div class="well-info-body" style="padding:0px;">
	
	
		<div>
			<%if(showCanvasGraphs){ %> 
			<canvas id="disk-chart"></canvas>
			<%}else{%>
				<img src="/ImageController?w=350&operation=disk" style="display:block; width:100%;">
			<%}%>
		</div>
				
				
		<table class="table table-condensed" style="overflow-x:hidden;">
			<tr>
			<th>Total Disk Space:</th><td><%=_dtotalString%></td>
			</tr>
			
			<tr>
			<th>Total Used:</th><td><%=_dusedString%></td>
			</tr>
			
			<tr>
			<th>Free Space:</th><td><%=_dfreeString%></td>
			</tr>
		</table>
		
		
		
		<script>
			var ctxDisk = document.getElementById("disk-chart").getContext('2d');
			var myChart = new Chart(ctxDisk, {
			    type: 'pie',
			    data: {
			        labels: ["Free", "Used"],
			        datasets: [{
			            label: 'Disk Usage',
			            data: [<%=_dpercentFree%>, <%=_dpercentUsed%>],
			            backgroundColor: [
			                '#dcdcdc',
			                '#5a7d5c'
			            ],
			            borderColor: [
			                '#dcdcdc',
			                '#5a7d5c'
			            ],
			            borderWidth: 1
			        }]
			    }
			});
			</script>
			
			
	</div>
</div>