<!--NEWSKIN2015JP-->
<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%
	long allocated = Runtime.getRuntime().totalMemory();
	long totalMemory = Runtime.getRuntime().maxMemory();
	long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();

	int totalWidth = 296;
	
	int percentUsed = (int)((usedMemory * 100) / totalMemory);
	int percentAlloc = ((int)((allocated * 100) / totalMemory)) - percentUsed;
	int percentFree = 100 - (percentAlloc + percentUsed);
	
	
	int redWidth = percentUsed * totalWidth / 100;
	int greenWidth = percentAlloc * totalWidth / 100;
	int blueWidth = percentFree * totalWidth / 100;
	
	String usedString = (usedMemory / 1024000) + " MB";
	String allocString = (allocated / 1024000) + " MB";
	String totalString = (totalMemory / 1024000) + " MB";
	
%>

<div class="well-info-green">
	<div class="text-center well-info-header">
		Memory Status
		<%if(authorizationLevel > ResourceBean.AL_ADMIN_USER){ %>
		<a class="pull-right" title="Configure" href="<%= response.encodeURL("FrontController?operation=198") %>"><span class="glyphicon glyphicon-cog"></span> &nbsp; </a>
		<%}else{ out.println("&nbsp;"); } %>
	</div>
	<div class="well-info-body" style="padding:0px;">
	
		<div>
		<!--  <div style="display:table-cell; width:300px; max-width:100%;"> -->
		
			<!--  
			
			-->
			
			<%if(showCanvasGraphs){ %>
				<canvas id="memCanvas"></canvas>
			<%}else{%>
				<img src="/ImageController?w=350&operation=mem" style="display:block; width:100%;">
			<%}%>
			
		</div>
		
		<table class="table table-condensed">
			<tr>
			<td>Used Memory:</td><td><%=usedString%></td>
			</tr>
			
			<tr>
			<td>Allocated Memory:</td><td><%=allocString%></td>
			</tr>
			
			<tr>
			<td>Total Memory:</td><td><%=totalString%></td>
			</tr>
		</table>
	</div>
</div>

<%
StringBuffer memoryTime = new StringBuffer();
StringBuffer totalMemoryBuffer = new StringBuffer();
StringBuffer allocatedMemoryBuffer = new StringBuffer();
StringBuffer usedMemoryBuffer = new StringBuffer();

ResourceBean.getMemoryUsageHistory(memoryTime, totalMemoryBuffer, allocatedMemoryBuffer, usedMemoryBuffer);

%>
<script>



var memConfig = {
		type: 'line',
		data: {
			labels: [<%= memoryTime.toString() %>],
			datasets: [{
				label: 'Max Memory',
				backgroundColor: '#aa3333',
				borderColor: '#aa3333',
				data: [<%= totalMemoryBuffer %>],
				fill: false,
			}, {
				label: 'Used Memory',
				backgroundColor: '#5a7d5c',
				borderColor: '#5a7d5c',
				data: [<%= usedMemoryBuffer %>],
				fill: false,
			},{
				label: 'Allocated Memory',
				backgroundColor: '#326bac',
				borderColor: '#326bac',
				data: [<%= allocatedMemoryBuffer %>],
				fill: false,
			}],
			
		},
		options: {
			responsive: true,
			title: {
				display: true,
				text: 'Memory Usage'
			},
			tooltips:{
				mode: 'index',
				intersect: true
			},
			hover: {
				mode: 'nearest',
				intersect: true
			},
			scales: {
				xAxes: [{
					display: true,
					scaleLabel: {
						display: true,
						labelString: 'Time'
					}
				}],
				yAxes: [{
					display: true,
					scaleLabel: {
						display: true,
						labelString: 'Value (MB)'
					}
				}]
			}
		}
		
			
	};
	
var ctx = document.getElementById('memCanvas').getContext('2d');
if(ctx == null){
	window.alert('CTX is null');
}
new Chart(ctx, memConfig);
	

	
	
</script>
