<!--NEWSKIN2015JP-->
<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%
StringBuffer smtpConnectionTime = new StringBuffer();
StringBuffer totalConnectionsBuffer = new StringBuffer();
StringBuffer totalEmailsBuffer = new StringBuffer();

SmtpConnectionSummaryHolder smtpConnSummaryHolder = ResourceBean.getSmtpConnectionHistory(smtpConnectionTime, totalConnectionsBuffer, totalEmailsBuffer);

%>

<div class="well-info-green">
	<div class="text-center well-info-header">
		SMTP Connections/Emails ratio for <%= smtpConnSummaryHolder.getServerType() %>
		<a class="pull-right" title="Click for more information" href="http://xeams.com/connections-email-ratio.htm" target=_"blank"><span class="glyphicon glyphicon-question-sign"></span> &nbsp; </a>
		
	</div>
	<div class="well-info-body" style="padding:0px;">
	
		<div>
			<canvas id="smtpConnCanvas"></canvas>
		</div>
		
		<table class="table table-condensed">
			<tr>
			<td>Total Connections:</td><td><%= smtpConnSummaryHolder.getTotalConnections()%></td>
			</tr>
			
			<tr>
			<td>Total Emails:</td><td><%= smtpConnSummaryHolder.getTotalEmails()%></td>
			</tr>
			
			<tr>
			<td>Percentage:</td><td><%= smtpConnSummaryHolder.getPercentage()%></td>
			</tr>
		</table>
	</div>
</div>


<script>



var smtpConnConfig = {
		type: 'line',
		data: {
			labels: [<%= smtpConnectionTime.toString() %>],
			datasets: [{
				label: 'Total Connections',
				backgroundColor: '#aa3333',
				borderColor: '#aa3333',
				data: [<%= totalConnectionsBuffer %>],
				fill: false,
			}, {
				label: 'Total Emails',
				backgroundColor: '#5a7d5c',
				borderColor: '#5a7d5c',
				data: [<%= totalEmailsBuffer %>],
				fill: false,
			}],
			
		},
		options: {
			responsive: true,
			title: {
				display: true,
				text: 'Total Connections/Emails Ratio'
			},
			tooltips:{
				mode: 'index',
				intersect: true
			},
			hover: {
				mode: 'nearest',
				intersect: true
			},
			scales: {
				xAxes: [{
					display: true,
					scaleLabel: {
						display: true,
						labelString: 'Time'
					}
				}],
				yAxes: [{
					display: true,
					scaleLabel: {
						display: true,
						labelString: 'Num Connections'
					}
				}]
			}
		}
		
			
	};
	
var smtpConnCtx = document.getElementById('smtpConnCanvas').getContext('2d');
if(smtpConnCtx == null){
	window.alert('CTX is null');
}
new Chart(smtpConnCtx, smtpConnConfig);
	

	
	
</script>
