<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Xeams Plugins</h1>
<br>
Plugins are optional components that provide enhanced features in Xeams.


<!-- ===========================================   End-to-End Encryption  =============================================     -->
<h2>End-to-End Encryption</h2>
<div class="row">
	<div class="col-md-8">
		<div class="well">
			End-to-end email encryption ensures no one can view outbound email but the intended recipient. When enabled, Xeams will take the following steps:
			<br>
			<ul>
				<li>Encrypts the message right after receiving it</li>
				<li>Emails are converted to password protected PDF attachment using strong 256 AES encryption</li>
				<li>Message can only be opened if the recipient knows the password</li>
				<li>Even administrators will not be able to open/view the message</li>
			</ul>
			
			<div class="pull-right">
			<a href="https://www.xeams.com/video-e2e-encryption.htm" target="_blank" title="Click here to watch a video on this topic"><button class="btn btn-success"><i class="glyphicon glyphicon-facetime-video"> </i> Tutorial Video</button></a>
			</div>
			<br><br>
		</div>
	</div>
	<div class="col-md-4">
		<%
		

		if(request.getAttribute("e2eEncEnabled").equals("true")){
			%>
			<a href="<%=response.encodeURL("FrontController?operation=253") %>" title="Click here to manage End-to-end encryption"><button class="btn btn-default">Manage</button></a>
			<%
		}else{
			%>
			
			<%@ include file="PluginBuy.jsp" %>
			
			<!-- 
			A license for plugin is sold separately. Please click the button below to purchase a license. 
			<br><br>
			<a href="<%=response.encodeURL("FrontController?operation=253&pr=ob") %>" title="Click here to purchase a license"><button class="btn btn-default">Purchase</button></a>
			-->
			<%
		}
		%>
	</div>
</div>


<!-- ===========================================   Xeams API  =============================================     -->
<h2>Xeams API</h2>
<div class="row">
	<div class="col-md-8">
		<div class="well">
			<p>Using Xeams API you can:</p>
			<ul>
				<li>Send emails from any web-based application using HTTP(S)</li>
				<li>Modify configuration in Xeams, such as:
					<ul>
						<li>Adding/modifying users</li>
						<li>Adding/modifying domains</li>
						<li>Adding/modifying distribution lists</li>
						<li>Restarting Xeams</li>
					</ul>
				</li>
			</ul>
			
			
			<div class="pull-right">
			<a href="https://www.xeams.com/api.htm" target="_blank" title="Click here for more details">
				<button class="btn btn-success"><i class="glyphicon glyphicon-facetime-video"> </i> More Details</button></a>
			</div>
			<br><br>
		</div>
	</div>
	<div class="col-md-4">
		<%
		

		if(request.getAttribute("apiEnabled").equals("true")){
			%>
			<a href="<%=response.encodeURL("FrontController?operation=mapip") %>" title="Click here to manage Xeams API"><button class="btn btn-default">Manage</button></a>
			<%
		}else{
			%>
			
			<%@ include file="PluginBuy.jsp" %>
			
			<br><br>
			<div class="well">
			<b>NOTE:</b> You need at least a 20 users license in order to use this feature.
			</div>
			<!-- 
			A license for plugin is sold separately. Please click the button below to purchase a license. 
			<br><br>
			<a href="<%=response.encodeURL("FrontController?operation=253&pr=ob") %>" title="Click here to purchase a license"><button class="btn btn-default">Purchase</button></a>
			-->
			<%
		}
		%>
	</div>
</div>

<!-- ===========================================   Outbound Email Campaign  =============================================     -->
<h2>Outbound Email Campaign</h2>
<div class="row">
	<div class="col-md-8">
		<div class="well">
			Outbound Email Campaigns provide a convenient way to tracking outbound messages. You can track the following information:
			<br>
			<ul>
				<li>List of recipients who were sent emails</li>
				<li>Bounce Rate</li>
				<li>Click Through Rate</li>
				<li>Logs containing failed address</li>
			</ul>
			
			<div class="pull-right">
			<a href="https://www.xeams.com/video-plugins.htm" target="_blank" title="Click here to watch a video on this topic"><button class="btn btn-success"><i class="glyphicon glyphicon-facetime-video"> </i> Tutorial Video</button></a>
			</div>
			<br><br>
		</div>
	</div>
	<div class="col-md-4">
		<%
		

		if(request.getAttribute("obCampaignEnabled").equals("true")){
			%>
			<a href="<%=response.encodeURL("FrontController?operation=248") %>" title="Click here to manage Outbound Email Campaigns"><button class="btn btn-default">Manage</button></a>
			<%
		}else{
			%>
			
			<%@ include file="PluginBuy.jsp" %>
			
			<!-- 
			A license for plugin is sold separately. Please click the button below to purchase a license. 
			<br><br>
			<a href="<%=response.encodeURL("FrontController?operation=248&pr=ob") %>" title="Click here to purchase a license"><button class="btn btn-default">Purchase</button></a>
			-->
			<%
		}
		%>
	</div>
</div>





<!-- ===========================================   Mail Merge Campaign  =============================================     -->

<h2>MailMerge Campaign</h2>
<div class="row">
	<div class="col-md-8">
		<div class="well">
			Mail Merge Campaign allow users to send a similar email to multiple recipients. This is done by uploading a file in CSV (comma separated values)
			containing user's data. Incoming emails are distributed up by merging this message with the uploaded data in the CSV file. 
			
			<br><br>
			<div class="pull-right">
			<a href="https://www.xeams.com/video-plugins.htm" target="_blank" title="Click here to watch a video on this topic"><button class="btn btn-success"><i class="glyphicon glyphicon-facetime-video"> </i> Tutorial Video</button></a>
			</div>
			<br><br>
			
			
		</div>
	</div>
	<div class="col-md-4">
		<%
		
		
		if(request.getAttribute("mmCampaignEnabled").equals("true")){
			%>
			<a href="<%=response.encodeURL("FrontController?operation=250") %>" title="Click here to manage MailMerge Campaigns"><button class="btn btn-default">Manage</button></a>
			<%
		}else{
			%>
			
			<%@ include file="PluginBuy.jsp" %>
			
			
			<!-- 
			A license for plugin is sold separately. Please click the button below to purchase a license. 
			<br><br>
			<a href="<%=response.encodeURL("FrontController?operation=248&pr=mm") %>" title="Click here to purchase a license"><button class="btn btn-default">Purchase</button></a>
			-->
			<%
		}
		%>
	</div>
</div>


<!-- ===========================================   Pre-Approval Plugin  =============================================     -->

<h2>Pre-Approval Plugin</h2>
<div class="row">
	<div class="col-md-8">
		<div class="well">
			 Occasionally, you may need a moderator to look at an incoming email before delivering it to the intended recipient.

			Incoming emails that match certain criteria can be redirected to a moderator, who 
			must either <b>Approve</b> or <b>Reject</b> the email. 
			
			<br><br>
			<div class="pull-right">
			<a href="https://www.xeams.com/pre-approval-plugin.htm" target="_blank" title="Click here to watch a video on this topic"><button class="btn btn-success"><i class="glyphicon glyphicon-facetime-video"> </i> Tutorial Video</button></a>
			</div>
			<br><br>
			
			
		</div>
	</div>
	<div class="col-md-4">
		<%
		
		
		if(request.getAttribute("preapprovalEnabled").equals("true")){
			%>
			<a href="<%=response.encodeURL("FrontController?operation=268") %>" title="Click here to manage Pre-Approval Plugin"><button class="btn btn-default">Manage</button></a>
			<%
		}else{
			%>
			
			<%@ include file="PluginBuy.jsp" %>
			
			
			<!-- 
			A license for plugin is sold separately. Please click the button below to purchase a license. 
			<br><br>
			<a href="<%=response.encodeURL("FrontController?operation=248&pr=mm") %>" title="Click here to purchase a license"><button class="btn btn-default">Purchase</button></a>
			-->
			<%
		}
		%>
	</div>
</div>


<!-- ===========================================   Read Receipt Plugin  =============================================     -->

<h2>Read Receipt Plugin</h2>
<div class="row">
	<div class="col-md-8">
		<div class="well">
			Add delivery receipt to track an email message. This receipt tells the sender (a local user) once the recipient opens the email 
			to view it.
			
			<br><br>
			<div class="pull-right">
			<a href="https://www.xeams.com/read-receipt.htm" target="_blank" title="Click here to watch a video on this topic"><button class="btn btn-success"><i class="glyphicon glyphicon-facetime-video"> </i> Tutorial Video</button></a>
			</div>
			<br><br>
			
			
		</div>
	</div>
	<div class="col-md-4">
		<%
		
		
		if(request.getAttribute("preapprovalEnabled").equals("true")){
			%>
			<a href="<%=response.encodeURL("FrontController?operation=rrconf") %>" title="Click here to manage Read Receipt Plugin"><button class="btn btn-default">Manage</button></a>
			<%
		}else{
			%>
			
			<%@ include file="PluginBuy.jsp" %>
			
			
			<!-- 
			A license for plugin is sold separately. Please click the button below to purchase a license. 
			<br><br>
			<a href="<%=response.encodeURL("FrontController?operation=248&pr=mm") %>" title="Click here to purchase a license"><button class="btn btn-default">Purchase</button></a>
			-->
			<%
		}
		%>
	</div>
</div>




<!-- ===========================================   Missed Email Plugin  =============================================     -->

<h2>Missed Email Plugin</h2>
<div class="row">
	<div class="col-md-8">
		<div class="well">
			Alerts are generated if an expected email is not received within a predefined time frame. Imagine you're
			supposed to receive a backup report every day around 4 PM. Xeams can generate an alert if this report 
			is not received.
			
			<br><br>
			<div class="pull-right">
			<a href="https://www.xeams.com/missed-email-alerts.htm" target="_blank" title="Click here to watch a video on this topic"><button class="btn btn-success"><i class="glyphicon glyphicon-facetime-video"> </i> Tutorial Video</button></a>
			</div>
			<br><br>
			
			
		</div>
	</div>
	<div class="col-md-4">
		<%
		
		
		if(request.getAttribute("preapprovalEnabled").equals("true")){
			%>
			<a href="<%=response.encodeURL("FrontController?operation=amea") %>" title="Click here to manage Missed Email Plugin"><button class="btn btn-default">Manage</button></a>
			<%
		}else{
			%>
			
			<%@ include file="PluginBuy.jsp" %>
			
			
			<!-- 
			A license for plugin is sold separately. Please click the button below to purchase a license. 
			<br><br>
			<a href="<%=response.encodeURL("FrontController?operation=248&pr=mm") %>" title="Click here to purchase a license"><button class="btn btn-default">Purchase</button></a>
			-->
			<%
		}
		%>
	</div>
</div>





<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
