<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<%

String white = "#FFFFFF";
String grey = "#EEEEEE";
int rowCount = 0;
%>

<h1>Policy Violation Alerts</h1>
<br>
<div class="well">
	Policy violation alerts are email messages sent to individuals within your company when a policy rule is violated.
	Consider the following scenario. Let's say your company has a policy that no employee should send messages to certain domains
	on the Internet.
	If any individual tries to send a message to these domains, a new email will be generated by <%= productName %> and will be
	sent to management in your company.
</div>

<div class="row">
	<div class="col-md-6">


		<%
		AlertHolderBean holder = (AlertHolderBean) request.getAttribute("pHolder");
		String index = (String) request.getAttribute("index");


		if(holder == null || index == null){
			out.println("Insufficient data provided. Cannot continue");
			return;
		}
		%>


		<form action="<%= request.getAttribute("appPath") %>" method="post">

		<div class="well-info-wrap">
			<div class="well-info-header">Alert Options</div>
			<div class="well-info-body no-padding">
				<div style="padding:10px;">
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('friendlyName')"><b>?</b></div>
						<span class="form-control pull-left form-middle form-text wth-5">Friendly Name</span>
						<input class="form-control pull-left form-right text-center wth-4" type="text" name="txtFriendlyName" value="<%=holder.getFriendlyName()%>">
							
							<br style="clear:both;">
							<div class="alert alert-info more_info" id="friendlyName">
								An arbitrary name for this alert. Example: Important document protection.
							</div>
					
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('recipients')"><b>?</b></div>
						<span class="form-control pull-left form-middle form-text wth-5">Alert Recipient(s)</span>
						<input class="form-control pull-left form-right text-center wth-4" type="text" name="txtAlertRecipients" value="<%=holder.getAlertRecipients()%>">
							
							<br style="clear:both;">
							<div class="alert alert-info more_info" id="recipients">
								Email address of the individual(s) to whom this alert will be sent. Use a comma to separate multiple addresses.
							</div>
					
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('msgScore')"><b>?</b></div>
						<span class="form-control pull-left form-middle form-text wth-5">Message Score</span>
						<input class="form-control pull-left form-right text-center wth-4" type="text" name="txtScore" value="<%= "" + holder.getAlertScore()%>">
							
							<br style="clear:both;">
							<div class="alert alert-info more_info" id="msgScore">
								You can optionally assign score to the original email message, which allows
								you to block any email you deem necessary. For example, if someone sends any email that violates
								the company policies you can assign a score higher than spam threshold. Doing this will make the
								Rules Engine quarintine the message.
							</div>
					
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('attachOrig')"><b>?</b></div>
						<span class="form-control pull-left form-middle form-text wth-8">Attach Original</span>
						<span class="chkbox-cust form-control form-right pull-left wth-1">
							<input id="chk-atch" type="checkbox" name="chkAttachOriginal" <%=holder.isAttacheOriginal() ? "checked" : ""%>>
							<label for="chk-atch"></label>
						</span>
							
							<br style="clear:both;">
							<div class="alert alert-info more_info" id="attachOrig">
								If checked, the original email will be attached to the notification message.
							</div>
					
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('subject')"><b>?</b></div>
						<span class="form-control pull-left form-middle form-text wth-5">Subject</span>
						<input class="form-control pull-left form-right text-center wth-4" type="text" name="txtAlertSubject" value="<%=holder.getAlertSubject()%>">
							
							<br style="clear:both;">
							<div class="alert alert-info more_info" id="subject">
								Subject of the alert.
							</div>
					
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('sender')"><b>?</b></div>
						<span class="form-control pull-left form-middle form-text wth-5">Sender</span>
						<input class="form-control pull-left form-right text-center wth-4" type="text" name="txtAlertSender" value="<%=holder.getAlertSender()%>">
							
							<br style="clear:both;">
							<div class="alert alert-info more_info" id="sender">
								Email address to use as the sender of this alert. For example: alerts@yourcompany.com
							</div>
				</div>
				<div class="text-center"><h3>Alert Message:</h3></div>
				<textarea rows=10 style="width:100%; padding:10px; border:none; border-top:solid 1px #aaa; border-bottom:solid 1px #aaa; background-color:#fafafa;" name="txtAlertBody"><%=holder.getAlertBody()%></textarea>
				
				<br style="clear:both;"><br>
			</div>
		</div>
	
		<br style="clear:both;">
		<div class="well-info-wrap">
			<div class="well-info-header">Usage Tip</div>
			<div class="well-info-body">
				The body of alert emails can optionally take variables. These variables are replaced
				at run time with the actual value. Variables are enclosed with two ## signs, for example ##SENDER##. Variables are case sensitive.
				Following is a list of possible variables:
				<br><br>
				<li><b>##FRIENDLY_NAME##</b> - Friendly name of this rule</li>
				<li><b>##IP_ADDRESS##</b> - IP Address of the original message</li>
				<li><b>##RECIPIENT##</b> - Email addresses of the recipients in the original message</li>
				<li><b>##SENDER##</b> - Sender's email in the original message</li>
				<li><b>##SUBJECT##</b> - Subject of the original message</li>
				<li><b>##VIOLATION_REASON##</b> - A description explaining which rule triggered this violation</li>
			</div>
		</div>
	</div>
	
	<br class="hide_lg">
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Trigger Criteria</div>
			<div class="well-info-body no-padding">
				<div class="well-info-additional">Note: All input below can be specified as regular expressions.</div>
				
				<div style="padding:10px;">
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('senderEmail')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-5">Sender Email</span>
					<input class="form-control pull-left form-right text-center wth-4" type="text" name="txtSenderFilter" value="<%=holder.getSenderFilter()%>">
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="senderEmail">
							A notification email is triggered when inbound or outbound message containing
							this value is encountered by the Rules Engine. Use regular expression to specify more than one
							address. For example: <br>
							<code>(mycompetitor.com|mycompetitor.net)</code>
						</div>
						
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('recipientEmail')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-5">Recipient Email</span>
					<input class="form-control pull-left form-right text-center wth-4" type="text" name="txtRecipientFilter" value="<%=holder.getRecipientFiler()%>">
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="recipientEmail">
							This is similar to the sender rule, but matches the To, CC and BCC fields.
							For example:<br>
							<code>salesmanager@your-domain.com</code>
						</div>
						
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('senderIP')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-5">Sender IP</span>
					<input class="form-control pull-left form-right text-center wth-4" type="text" name="txtIpFilter" value="<%=holder.getIpFilter()%>">
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="senderIP">
							An alert is triggered if a message comes from this IP address. You
							can use a * character as a wild card. Example:<br>
							<code>199.199.199.199</code><br>
							<code>199.199.199.*</code>
						</div>
						
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('attachment')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-5">Attachment</span>
					<input class="form-control pull-left form-right text-center wth-4" type="text" name="txtAttachmentFilter" value="<%=holder.getAttachmentFilter()%>">
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="attachment">
							Trigger notifications based on attachments. Example:<br>
							<code>ConfidentialDocument.doc</code><br>
							<code>*.pdf</code>
						</div>
						
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('txtSubject')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-5">Subject</span>
					<input class="form-control pull-left form-right text-center wth-4" type="text" name="txtSubjectFilter" value="<%=holder.getSubjectFilter()%>">
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="txtSubject">
							Subject of the message is matched against this value before triggering a notification.
						</div>
						
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('txtBody')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-5">Body</span>
					<input class="form-control pull-left form-right text-center wth-4" type="text" name="txtBodyFilter" value="<%=holder.getBodyFilter()%>">
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="txtBody">
							Body of the message is matched against this value before triggering a notification.
						</div>
				</div>
			</div>
		</div>
		<br style="clear:both;">
		<button class="btn btn-sm btn-submit pull-right">Save</button>
		<input type="hidden" value="128" name="operation" />
		<input type="hidden" value="<%=index%>" name="index"/>
		</form>
	</div>
</div>

<!--
Following settings define a trigger criteria for an alert. <br><br>
<table width="100%">
    <tr>
        <td valign="top"><b>Example:</b></td>
        <td valign="top">Let's say you want to intercept any message sent to or from <u><b>ourCompetitor.com</b></u>. Use the
            following steps:

            <ol>
                <li>For both Sender and Recipient values type "ourCompetitor.com"</li>
            </ol>
        </td>
    </tr>
</table>

-->

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
