<%@page import="com.synametrics.xeams.pop3.Pop3FetcherManager"%>
<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%

List sideButtons = new ArrayList(5);
sideButtons.add(new UrlAnchorHolder("Pop Fetcher", "current", true));


//Variables for FAQ
boolean showFAQ = true;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "MainMenu");
%>


<%@ include file="CommonButtons.jsp" %>
<%@ include file="NewPageHeader.jsp" %>



<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-success text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}

String saved = (String)request.getAttribute("saved");

if(saved != null){
%>
<div class="alert alert-info text-center">Configuration Saved Successfully</div>
<%
}
%>

<h1><%= productName %>'s Pop Fetcher</h1>



<div class="row">
	<div class="col-md-6">		
		<%
		AppConfig smConf = AppConfig.getInstance();
		%>

		<div class="well-info-wrap">
			<div class="well-info-header">Configuration</div>
			<div class="well-info-body">

				<form action="<%= request.getAttribute("appPath") %>" method="post">
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('enablePop')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-8">Enable POP Fetcher</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chk-pop" type="checkbox" name="fetchEnabled" size="4" value="1" <%=smConf.isPopFetchEnabled () ? " checked " : ""%> >
					<label for="chk-pop"></label>
				</span>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="enablePop">
					Check this box if you wish to enable this feature.
				</div>

				<br style="clear:both;"><br>
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('fetchInt')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Fetch Interval</span>
				<input class="form-control form-middle pull-left wth-3 text-center" type="text" name="fetchInterval" size="4" value="<%=smConf.getPopFetchInterval()%>">
				<span class="form-control form-right form-text pull-left wth-2 text-center">min</span>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="fetchInt">
					Interval at which <%= productName %> will check the POP account in minutes.
				</div>

				<br style="clear:both;">
				<button class="btn btn-sm btn-submit pull-right" type="submit" value="Save">Save</button>
				<input type="hidden" name="operation" value="71">
				</form>
				<br style="clear:both;">
			</div>
		</div>
	</div>

	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">When should you use this service</div>
			<div class="well-info-body">
				We recommend that you leave the POP Fetcher Service disabled unless following is true:
				<ul>
				<li>You do not have a public IP address, or
				<li>Your emails are hosted by your ISP and you need to download them periodically into your server
				</ul>
			</div>
		</div>
		
		<br style="clear:both;">
		<div class="well-info-wrap">
			<div class="well-info-header">Disadvantages of using POP3 to fetch your emails</div>
			<div class="well-info-body">
				<ul>
				<li>BCC recipients may not get messages</li>
				<li>POP3 mailboxes will have to be created twice - once at your ISP and once on your SMTP server</li>
				<li>Messages sent to a group rather than individual may not be routed correctly</li>
				<li>Xeams will pull and delete messages from the source server. Therefore, you will only be able to access your emails from Xeams.</li>
				</ul>
			</div>
		</div>
	</div>
	
	<br style="clear:both;"><br>
	<div class="col-md-12">
		<a href="<%=response.encodeURL("FrontController?operation=72") %>"><button class="btn btn-sm btn-menu pull-right"><span class="glyphicon glyphicon-plus"></span> New Account</button></a>
		
		<br style="clear:both;"><br>
		<table class="table table-striped table-bordered well-info-wrap">
		
		<tr class="well-info-header">
			<th>Server's Hostname</th>
			<th>User Name</th>
			<th>Deliver To</th>
			<th>Max Fetch</th>
			<th>Action</th>
		</tr>

		<%
		List allPopers = Pop3FetcherManager.getInstance().getAllFetchers(); // .getPopFetchList();

		if(allPopers.size() == 0){
		%>
		<tr class="text-center"><td colspan="5">No accounts have been created. Click "New Account" above to create a new account</td></tr>
		<%
		}
		for(int i = 0; i < allPopers.size(); i++){
			PopFetcherHolder oneHolder = (PopFetcherHolder)allPopers.get(i);

		%>
		<tr>
		<td><%=oneHolder.getPopFetchPopServer()%></td>
		<td><%=oneHolder.getPopFetchUser()%></td>
		<td><%=oneHolder.getPopFetchRecipient()%></td>
		<td><%=oneHolder.getPopFetchCount()%></td>
		<td><a href="<%=response.encodeURL("FrontController?operation=74") %>&index=<%=i%>"><i class="glyphicon glyphicon-pencil" title="Modify settings"></i> Edit</a> |
			<a href="<%=response.encodeURL("FrontController?operation=75") %>&index=<%=i%>"><i class="glyphicon glyphicon-trash" title="Permanantly delete this entry"></i> Delete</a>
			<span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=75d") %>&index=<%=i%>" title="Test Connectivity"><i class="glyphicon glyphicon-refresh"></i> Test</a></span>
			
		</td>
		</tr>
		<%

		}
		%>
		</table>
	</div>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
