<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<%
List<String> exceptions = (List<String>) request.getAttribute("exceptions");

if(exceptions == null){
%>

<div class="row">
	<div class="col-md-8 col-md-offset-2">
		<!-- ******* Create Window Panel ******* -->
		<div class="well-info-wrap">
			<div class="well-info-header">Inherit Profile Wizard</div>
			<div class="well-info-body">
				This wizard allows you to convert an independent profile to an inherited profile. <a href="http://xeams.com/inherited-profiles.htm" target="_blank">Click here</a> for 
				details. The system will perform following tasks when you click proceed below:
				<br><br>
				<ul>
					<li>Creates a backup of <code><%= request.getAttribute("profFileName") %></code> to <code><%= request.getAttribute("profFileName") %>.independent</code>. This backup 
					can be used to rollback changes made by this wizard if necessary. To rollback, you will have to stop Xeams, replace the file back to <code><%= request.getAttribute("profFileName") %></code>
					and restart</li>
					
					<li>This wizard will affect following filters:
						<ul>
							<li>Attachment filters</li>
							<li>Body filters</li>
							<li>Country filters</li>
							<li>Custom filters</li>
							<li>Header filters</li>
							<li>RBL servers</li>
							<li>Sender filters</li>
							<li>Subject filters</li>
						</ul>
					</li>  
					
					<li>Matching filters will be removed. A 100% match is found if <b>search string</b>, <b>score</b> and <b>operator</b> are identical.</li>
					<li>In case of a partial match (search string matches but score does not), score will be adjusted</li>
					<li>If the operator does not match, an exception is raised and will be displayed on the screen once wizard is complete. You will have to manually adjust 
					the rules that go in this category</li>
				</ul>
				
				
				<div class="text-center">
					<form action="<%= request.getAttribute("appPath") %>" method="post">
						<button class="btn btn-sm btn-submit" type="submit">Submit</button>
						<input type="hidden" name="operation" value="244">
						<input type="hidden" name="proceed" value="true">
						<input type="hidden" name="pid" value="<%= request.getParameter("pid") %>">
						
					</form>
				</div>
			</div>
		</div>
	</div>
</div>


<%}else{
	if(exceptions.size() == 0){
		%>
		<h2>Success</h2>
		Profile has been successfully migrated to inherted version.
		<%
	}else{
		%>
		<h2>Partial Success</h2>
		Some of the rules were not migrated because a partial mismatch. It is recommended you manually check these filters and adjust their values
		if necessary. The following list displays those rules:
		
		<div class="well">
			<%
			for(int i = 0; i < exceptions.size(); i++){
				out.println(exceptions.get(i) + "<br>");
			}
			%>
		</div>
		<%
	}
	
	%>
	
	<%
}
%>


<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
