<!-- ******** NEW_SKIN_2015 ******** -->

<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>

<%

List sideButtons = new ArrayList(5);
sideButtons.add(new UrlAnchorHolder("Server Configuration", "current", true));

//Variables for FAQ
boolean showFAQ = true;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "MultiDomain");

AppConfig smConf = AppConfig.getInstance();

String boundIPStr = ResourceBean.printAvailableIPOptions(smConf.getSmtpProxyBindIP());
boolean showCanvasGraphs = System.getProperty("use.canvas.for.graphs", "true").equals("true");

%>


<%@ include file="CommonButtons.jsp" %>
<%@ include file="NewPageHeader.jsp" %>


<h1>Profile Selection Screen</h1>

<span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=61") %>" class="btn btn-sm btn-menu"><span class="glyphicon glyphicon-plus"></span>&nbsp; New Profile</a></span>
<br style="clear:both;">

			<%
			
			int totalSpam = (Integer) request.getAttribute("junk");
			int totalPossibleSpam = (Integer) request.getAttribute("possible");
			int totalGood = (Integer) request.getAttribute("good");
			%>

<div class="row">
	<div class="col-md-6" style="padding:15px;">			
		<div class="well-info-green">
			<div class="text-center well-info-header">Default Profile</div>

			<div class="well-info-body">
				<!-- DEFAULT PROFILE -->
					<a href="<%=response.encodeURL("FrontController?operation=58&pid=1") %>" class="btn btn-md btn-default"><span class="glyphicon glyphicon-user"></span> &nbsp; Default Profile</a>
						
						<br><br>						
						<p>This profile handles email for every domain for which a
						specific profile is not defined.</p>

						<br><br><br>
				<div class="row">

					<div class="col-md-6 col-xs-6">
						
						<h3>Email Statistics</h3>
						<table class="table table-bordered table-striped table-condensed">
						<tr>
						<td>Spam Messages: </td><td><%=totalSpam%></td>
						</tr>
						<tr>
						<td>Possible Spam Messages: </td><td><%=totalPossibleSpam%></td>
						</tr>
						<tr>
						<td>Good Messages: </td><td><%=totalGood%></td>
						</tr>
						</table>
					</div>

					<div class="col-md-6 col-xs-6 text-center">
						<br>
						<%if(showCanvasGraphs){ %>
							<canvas id="msg-dist-chart"></canvas>
					
							<script>
							var ctxMsgDist = document.getElementById("msg-dist-chart").getContext('2d');
							var myChart = new Chart(ctxMsgDist, {
							    type: 'pie',
							    data: {
							        labels: ["Good", "Possible Spam", "Spam"],
							        datasets: [{
							            label: '# of Votes',
							            data: [<%=totalGood%>, <%=totalPossibleSpam%>, <%=totalSpam%>],
							            backgroundColor: [
							                '#326bac',
							                '#dcdcdc',
							                '#aa3333'
							            ],
							            borderColor: [
							                '#326bac',
							                '#dcdcdc',
							                '#aa3333'
							            ],
							            borderWidth: 1
							        }]
							    }
							});
							</script>
						<%}else{%>
							<img src="ImageController?operation=1&totalGood=<%=totalGood%>&totalSpam=<%=totalSpam%>&totalPossible=<%=totalPossibleSpam%>" style="width:250px; max-width:100%;">
						<%}%>

						
					</div>
				</div>	
			</div>
		</div>
	</div>
			<!-- DEFAULT PROFILE ENDS HERE -->
			<%
			
			
			List<ProfileBean> beans = (List<ProfileBean>) request.getAttribute("beans");
			
			String currentProfileName = "";
			int currentProfileId = 1;
			String currentSender = "";
			String currentRecipient = "";
			
			for(ProfileBean oneBean : beans){
				currentProfileName = oneBean.getProfileName();
				currentProfileId = oneBean.getProfileId();
				currentSender = oneBean.getSenderForHtml();
				currentRecipient = oneBean.getRecipientForHtml();
				totalSpam = oneBean.getJunk();
				totalPossibleSpam = oneBean.getPossible();
				totalGood = oneBean.getGood();
				
			
				String inheritedParam = oneBean.isInherited() ? "&inh=1" : "&inh=0";
			%>
		
		<!-- CUSTOM PROFILE STARTS HERE -->



	<div class="col-md-6" style="padding:15px;">
		<div class="well-info-green">
			<div class="text-center well-info-header">
				<%=currentProfileName%>
				
				
				<span class="pull-right">
					<a href="<%=response.encodeURL("FrontController?operation=61" + inheritedParam) %>&id=<%=oneBean.getIndex()%>" title="Edit"><span class="glyphicon glyphicon-edit"></span></a> &nbsp; | &nbsp;
					<a href="<%=response.encodeURL("FrontController?operation=63") %>&id=<%=oneBean.getIndex()%>" title="Delete"><span class="glyphicon glyphicon-trash"></span></a> &nbsp; &nbsp;
				</span>
			</div>	
			<div class="well-info-body">
			
				<a href="<%=response.encodeURL("FrontController?operation=58") %>&pid=<%=currentProfileId%>" class="btn btn-md btn-default"><span class="glyphicon glyphicon-user"></span> &nbsp; <%=currentProfileName%></a>
				<% if(!oneBean.isInherited()){
					%>
					( <a href="<%=response.encodeURL("FrontController?operation=244") %>&pid=<%=oneBean.getProfileId()%>"><i class="glyphicon glyphicon-export"></i> Convert to inherited</a> )
					<%
				}%>
				<br><br>
				<p>This profile handles email for every domain where<br><br>
				
				<%if(currentSender != null && currentSender.length() > 0){
					%>
					<u>FROM</u> matches <%=currentSender%> and/or <br>
					<%
				}%>
				
				
				<%if(currentRecipient != null && currentRecipient.length() > 0){
					%>
					<u>TO/CC/BCC</u> matches <%=currentRecipient%><br><br>
					<%
				}%>
				
				
						
						
				<div class="row">
					<div class="col-md-6 col-xs-6">
						

						<br>
						<h3>Email Statistics</h3>
						<table class="table table-bordered table-striped table-condensed">
						<tr>
						<td>Spam Messages: </td><td><%=totalSpam%></td>
						</tr>
						<tr>
						<td>Possible Spam Messages: </td><td><%=totalPossibleSpam%></td>
						</tr>
						<tr>
						<td>Good Messages: </td><td><%=totalGood%></td>
						</tr>
						</table>
					</div>

					<div class="col-md-6 col-xs-6 text-center">
						<br>
						
						
						<%if(showCanvasGraphs){ %>
							<canvas id="msg-dist-chart_<%=currentProfileId%>"></canvas>
					
							<script>
							var ctxMsgDist_<%=currentProfileId%> = document.getElementById("msg-dist-chart_<%=currentProfileId%>").getContext('2d');
							var myChart_<%=currentProfileId%> = new Chart(ctxMsgDist_<%=currentProfileId%>, {
							    type: 'pie',
							    data: {
							        labels: ["Good", "Possible Spam", "Spam"],
							        datasets: [{
							            label: '# of Votes',
							            data: [<%=totalGood%>, <%=totalPossibleSpam%>, <%=totalSpam%>],
							            backgroundColor: [
							                '#326bac',
							                '#dcdcdc',
							                '#aa3333'
							            ],
							            borderColor: [
							                '#326bac',
							                '#dcdcdc',
							                '#aa3333'
							            ],
							            borderWidth: 1
							        }]
							    }
							});
							</script>
						<%}else{%>
							<img src="ImageController?operation=1&totalGood=<%=totalGood%>&totalSpam=<%=totalSpam%>&totalPossible=<%=totalPossibleSpam%>"  style="width:250px; max-width:100%;">
						<%}%>
						
						
						
						
						
					</div>
				</div>
			</div>
		</div>
	</div>

			<!-- CUSTOM PROFILE ENDS HERE -->
			<%
			}
			%>
</div>
			
<br style="clear:both;">
<span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=61") %>" class="btn btn-sm btn-menu"><span class="glyphicon glyphicon-plus"></span>&nbsp; New Profile</a></span>

<br style="clear:both;"><br><br>
<%@ include file="InnerRightGrey.jsp" %>
<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>

