<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<h1>Upgrade User Repository</h1>


<h3>Why upgrade?</h3>
Older versions of Xeams used one copy of emails to archive messages as well serve the user repositories for IMAP and POP3 servers. Starting
from version 4.9, Xeams stores user's repository independent of the archived messages. User's repositories are used when displaying 
messages through IMAP and/or POP3 server. There are several benefits in doing so:
<br><br>
<ul>	
	<li>Archived messages can be moved (from Spam to Good or vice-versa) without affecting user repositories</li>
	<li>Prevents file corruption in IMAP/POP3 stores</li>
	<li>Allow new emails to be added through IMAP</li>
	<li>Allow backing up emails belonging to individual users</li>
</ul>

<div class="alert alert-success">
<h4>Important</h4>
You will need additional disk space to store user repository. 
Consider <a href="http://www.xeams.com/custom-path-user-repository.htm" target="_blank">moving the repository</a> to a bigger 
drive if you do not have enough space on the current volume.
</div>


<h3>Steps</h3>
Upgrading to this new repository is automatic. However, depending upon the size of your existing IMAP/POP3 repository, it could take
some time. Therefore, it is recommended you perform this task during end of business when you get fewer incoming emails. 
Access to IMAP/POP3 servers will be slow during this process.

<p>

<div class="row">
	<div class="col-md-3"></div>
	<div class="col-md-3">
		<form action="<%= request.getAttribute("appPath") %>" method="post">
			<input type="submit" class="btn btn-sm btn-submit" value="Upgrade Now" title="Click here to upgrade user's repository">
			<input type="hidden" name="st" value="upgrade">
			<input type="hidden" name="operation" value="209">
		</form>
	</div>
	<div class="col-md-3">
		<form action="<%= request.getAttribute("appPath") %>" method="post">
			<input type="submit" class="btn btn-sm btn-default" value="Upgrade Later" title="Click here to perform this task next time you login">			
			<input type="hidden" name="operation" value="60">
		</form>
	</div>
	<div class="col-md-3"></div>
</div>

</p>





<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
