

<link rel="stylesheet" href="images/quill.snow.css" />
<style>
  .standalone-container {
    margin: 50px auto;
    max-width: 99900px;
  }
  #snow-container {
    height: 350px;
  }
</style>


<script src="images/quill.min.js"></script>

<script>
	//var toolbarOptions = [[ { 'header': 1 }, { 'header': 2 }, { 'header': 3 }] , ['bold', 'italic', 'underline', 'strike'] , ['link', 'image']];
	
	var toolbarOptions = [
	  ['bold', 'italic', 'underline', 'strike'],        // toggled buttons
	  ['blockquote', 'code-block', 'image', 'link'],

	  [{ 'list': 'ordered'}, { 'list': 'bullet' }],
	  [{ 'script': 'sub'}, { 'script': 'super' }],      // superscript/subscript
	  [{ 'indent': '-1'}, { 'indent': '+1' }],          // outdent/indent
	  [{ 'direction': 'rtl' }],                         // text direction

	
	  [{ 'header': [1, 2, 3, 4, 5, 6, false] }],

	  [{ 'color': [] }, { 'background': [] }],          // dropdown with defaults from theme
	  [{ 'font': [] }],
	  [{ 'align': [] }],

	  ['clean']                                         // remove formatting button
	];
	
	var options = {
	  debug: 'info',
	  modules: {
		toolbar: toolbarOptions
	  },
	  placeholder: <%= request.getAttribute("edPlaceHolder") == null ? "'Compose your message...'" : request.getAttribute("edPlaceHolder") %>,
	  theme: 'snow'
	};


	var quill = new Quill('#snow-container', options);
	
	
	
	function copyBody() {
	  // Populate hidden form on submit
	  var hiddenBodyText = document.querySelector('input[name=actualBodyText]');
	  hiddenBodyText.value = quill.root.innerHTML;

	}
	
	function loadTemplate() {
		var templates = document.getElementById("templates");
		templates = templates.options[templates.selectedIndex].value;

	
		var finalUrl = window.location.protocol + '//' + window.location.hostname + ':' + window.location.port + window.location.pathname;
		const myURL = new URL(finalUrl);
		
		myURL.searchParams.append('operation', 'bcast');
		myURL.searchParams.append('st' ,'t');
		myURL.searchParams.append('i', templates);

		if (templates > -1) {
			  fetch(myURL.href).then(function (response){
				  return response.text();
			  }).then(function(html) {
				  
				  
				  var subject = document.getElementById("templates");
				  
				  if(templates > 1){
					  //console.log("Setting subject for template: " + template)
				  	document.getElementById("subject").value = subject.options[subject.selectedIndex].text;	
				  }else{
					//console.log("Setting subject to def")
					document.getElementById("subject").value = "<%= (request.getAttribute("defSubject") == null ? "" : request.getAttribute("defSubject")) %>";	  
				  }
				  quill.root.innerHTML = html.trim();
				  
			  }).catch(function(err) {
				  console.log('failed to fetch the page: ', err);
			  });
		}else{
			document.getElementById("subject").value = "";	
			quill.root.innerHTML = "";
		}
	}
	
</script>


