<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Read Receipt Plugin</h1>


<%
String infoMsg = (String) request.getAttribute("infoMsg");
String errorMsg = (String) request.getAttribute("errorMsg");


if(infoMsg != null){
	%>
	<div class="alert alert-info"><%=infoMsg %></div>
	<%
}


if(errorMsg != null){
	%>
	<div class="alert alert-info"><h4>Error</h4><%=errorMsg %></div>
	<%
}


%>
<div class="row">

	<div class="col-md-6">
		<p>Add delivery receipt to track an email message. This receipt tells the sender (a local user) once the recipient opens the email 
		to view it. Receipts are sent via email to the original sender.
		</p>
		
		<h2>Important Information</h2>
		<p>Keep the following points in mind when using this feature:</p>
		<ul>
			<li>This only works for Outbound and Internal messages</li>
			<li>Recipients have the ability to disable this feature. Senders will never receive an alert in such cases.</li>
			
		</ul>
		
	</div>
	
	
	<div class="col-md-6">
		<!-- ******* Create Window Panel ******* -->
		<div class="well-info-wrap">
			<div class="well-info-header">Parameters</div>
			<div class="well-info-body">
				<form action="<%= request.getAttribute("appPath") %>" method="post">



					<!-- ENABLED  -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblEnabled')"><b>?</b></div>
					<span class="form-control form-text form-middle pull-left wth-8">Enabled</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="rrEnabled" name="rrEnabled" type="checkbox" <%= request.getAttribute("rrEnabled") %> >
						<label for="rrEnabled"></label>
					</span>
	
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblEnabled">
						Check to enable this plugin
					</div>
					
					
					
					<!--  PROCESS PLAIN TEXT MESSAGES  -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblPptm')"><b>?</b></div>
					<span class="form-control form-text form-middle pull-left wth-8">Convert Plain Text Messages</span>
					<span class="chkbox-cust form-control form-right pull-left wth-1">
						<input id="processForText" name="processForText" type="checkbox" <%= request.getAttribute("processForText") %> >
						<label for="processForText"></label>
					</span>
	
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblPptm">
						If checked, messages in plain text will be converted to HTML. Otherwise, plain text messages will be skipped.
					</div>
					
					
					
					
					
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblSuffix')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Subject Suffix</span>
					<input class="form-control form-right pull-left wth-5" type="text" name="rrSubject" value="<%= request.getAttribute("rrSubject") %>">
				
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="lblforwardTo">
						String to search for in the subject.
					</div>
				
				
					<!-- ******* Save Button | default is pulled right ******* -->
					<br style="clear:both;">
					<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
					<br><br>
					
					<input type="hidden" name="operation" value="rrconf">
					<input type="hidden" name="a" value="a">
				</form>

			</div>
		</div>
		
	</div>
	
	
</div>









<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
