<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>

<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<h1>Reload Message Cache</h1>
<br>
<div class="well">
	<%= productName %> caches the names (not the actual content) of ALL files are that in Spam, Possible spam
	and Good folder. This prevents <%= productName %> from reading the hard disk every time you go into View
	Messages. This cache is retained even after you bring down <%= productName %> and therefore, restarting
	the engine does not clear this cache.

	<p>If any file is manually altered in these folders the cache in <%= productName %> gets out of synch.
	One way to confirm if the cached data is correct is to compare the number of files in the actual folders
	with the number of files in the cache. The size of cache for each folder is shown below.
	</p>
</div>

<div class="well-info-wrap table-responsive">
	<table class="table table-striped table-bordered table-hover">
	<tr class="well-info-header">
		<td>Directory name</td>
		<td>Cache size</td>
	</tr>

	<tr class="well-info-additional"><td colspan="2">If the number of messages in the actual folder is significantly different from cache size, you should
	rebuild the cache.</td></tr>

	<tr bgcolor="#EDECE3">
		<td>GoodEmails</td>
		<td><%= request.getAttribute("good") %></td>
	</tr>

	<tr bgcolor="#FFFFFF">
		<td>SpamEmails</td>
		<td><%=  request.getAttribute("spam") %></td>
	</tr>

	<tr bgcolor="#EDECE3">
		<td>PossibleSpams</td>
		<td><%=  request.getAttribute("possible") %></td>
	</tr>

	</table>
</div>

<br style="clear:both;">
<div class="alert alert-danger">
	<b>IMPORTANT</b> -
	While the cache is rebuilding you will NOT be able to receive any emails. If there are too many files
	in these directories, it may take a long time - approximately 1 minute for every 10000 messages.
	<br><br>
	<form action="<%= request.getAttribute("appPath") %>" method="post">
	<input type="hidden" name="operation" value="110"/>
	<button class="btn btn-sm btn-menu pull-right" type="submit">Reload Message Cache</button>
	</form>
	<br style="clear:both;">
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
