<%@ page import="com.synametrics.xeams.bean.*" %>
<%@ page import="java.util.*" %>

<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>





<h1>Rules Optimization Wizard</h1>
<br>
<div class="well">It is recommended you run this wizard once a month.</div>


<%
List<BadRuleBeans> badRules = (List<BadRuleBeans>) request.getSession().getAttribute("badRules");
int totalMissingSpfDomains = 0;
int totalBadBuddies = 0;

if(badRules != null && badRules.size() > 0){
	for(int i = 0; i < badRules.size(); i++){
		BadRuleBeans oneRule = badRules.get(i);
		
		if(oneRule.getRuleType() == 3){
			totalMissingSpfDomains++;
		}
		if(oneRule.getRuleType() == 1 || oneRule.getRuleType() == 2){
			totalBadBuddies++;
		}
	}
	
	if(totalBadBuddies > 0){
		%>
		<h2>Incorrect sender filters</h2>
		White-listing your own domain name or email address is not a good idea as it will let forged emails get through. 
		<span class="pull-right">
		<form action="<%= request.getAttribute("appPath") %>" method="post" title="Fix every white-listed rule">
			<input type="submit" class="btn btn-sm btn-submit" value="Fix all">
			<input type="hidden" name="operation" value="211">
			<input type="hidden" name="st" value="fixall">	
		</form>
		</span>
		
		<table class="table table-condensed table-bordered table-striped">
		<tr>
			<th>Rule</th><th>Description</th><th>Remove</th>
		</tr>
		
		<%
			for(int i = 0; i < badRules.size(); i++){
				BadRuleBeans oneRule = badRules.get(i);
				if(oneRule.getRuleType() == 1 || oneRule.getRuleType() == 2){
					%>
					<tr>
						<td><%=oneRule.getRuleText() %></td>
						<td><%=oneRule.getReason() %></td>
						<td><a href="<%=response.encodeURL("FrontController?operation=211&st=f1") %>&ix=<%=i %>" title="Remove <%= oneRule.getRuleText() %> from rules">Remove</a></td>
					</tr>
					<%		
				}
			}
		%>
		</table>
		<div>
		<span class="pull-right">
		<form action="<%= request.getAttribute("appPath") %>" method="post" title="Fix every white-listed rule">
			<input type="submit" class="btn btn-sm btn-submit" value="Fix all">
			<input type="hidden" name="operation" value="211">
			<input type="hidden" name="st" value="fixall">	
		</form>
		</span>
		</div>
		
		<br><br>
		
		
		<%
	}

if(totalMissingSpfDomains > 0){
%>

<h2>Missing SPF records</h2>
Following local domains do not publish an SPF record in the DNS. Consider adding SPF record in your DNS server to prevent forgery. 
Check <a href="http://www.xeams.com/spf.htm" target="_blank">http://www.xeams.com/spf.htm</a> for details on how to add an SPF record.

<ul>
	<%
	for(int i = 0; i < badRules.size(); i++){
		BadRuleBeans oneRule = badRules.get(i);
		if(oneRule.getRuleType() == 3){
			%>
			<li><%=oneRule.getRuleText() %></li>
			<%
		}
	}
	%>
</ul>
<%
}
%>






<%
}else{
	%>
	System did not find any rule that you should change.	
	<%
}
%>




<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
