<!--NEWSKIN2015JP-->
<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>


<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>


<%!
     static String resultToName(String result) {

        if (result.equals("+")) {
            return "Pass";
        }
        else if (result.equals("-")) {
            return "Fail";
        }
        else if (result.equals("?")) {
            return "Neutral";
        }
        else if (result.equals("~")) {
            return "Softfail";
        }
        else {
            return "None";
        }

    }

%>

<h1>SPF Record Generator</h1>
<div class="well">
    This screen helps you to create SPF Record by providing suitable arguments against each SPF mechanism.
    An SPF string is created as you apply different options. Refer to
    <a href="<%= ResourceBean.getResourceURL()%>Spf.htm">our web site</a> for further details regarding SPF.
</div>

<div class="row">
	<div class="col-md-4">
		<div class="alert alert-success">
			<!-- operation 515 start-->		
			<form action="<%= request.getAttribute("appPath") %>" method="post">
				<input type="hidden" name="operation" value="515"/>
				<input type="hidden" name="spfRecord" value="<%=request.getAttribute("spfRecord")%>"/>
				<b>If you wanted to check  SPF Record against email address and sending host ip argument click Verify.</b>
				<br><br>
				<button class="btn btn-sm btn-submit pull-right" type="submit">Verify</button>
			</form>
			<br style="clear:both;">
		</div>
	</div>
<form action="<%= request.getAttribute("appPath") %>" method="post" name="aMechanism">	
	<div class="col-md-8">
		<!-- operation 515 start-->
		<div class="well-info-wrap">
			<div class="well-info-header">SPF Wizard</div>
			<div class="well-info-body no-padding">
				<table class="table table-striped table-bordered table-hover table-condensed">
					<%
					String dnsServer = System.getProperty("default.dns.server", "");

					if(dnsServer.length() == 0){
					dnsServer = "No DNS specified. Will use the DNS configured for the OS";
					}
					String r1 = (String)request.getAttribute("ARecord").toString();
					String r2 = (String)request.getAttribute("MXRecord").toString();
					String r3 = (String)request.getAttribute("MXIP").toString();
					String r4 = (String)request.getAttribute("NSRecord").toString();
					%>

					<input type="hidden" name="aRecord" value="<%=r1%>"/>
					<input type="hidden" name="mxRecord" value="<%=r2%>"/>
					<input type="hidden" name="mxipRecord" value="<%=r3%>"/>
					<input type="hidden" name="nsRecord" value="<%=r4%>"/>

					<tr>
					<td><b>DNS Server:</b></td><td><%=dnsServer%></td>
					<tr>
					<td><b>"A" Record points to:</b></td><td><%=r1%></td>
					<tr>
					<td><b>"MX" Record points to:</b></td><td><%=r2%></td>
					<tr>
					<td><b>IP for MX record:</b></td><td><%=r3%></td>
					<tr>
					<td><b>"NS" record:</b></td><td><%=r4%></td>

					<tr>
					</tr>
					<tr>
					<td><b>SPF record:</b></td><td><%=request.getAttribute("spfRecord")%></td>
					</tr>
				</table>
			</div>
		</div>
	</div>
</div>

<BR>

<input type="hidden" name="operation" value="514"/>

<div class="well-info-wrap">
	<table class="table table-striped table-bordered">
		<tr class="well-info-header">
			<td class="wth-1">Mechanism</td>
			<td class="wth-6">Description</td>
			<td class="wth-3">Configuration</td>
		</tr>
		
		<!-- * * * * * * * * A mechanicsm * * * * * * * * -->
		<tr>
			<td class="text-center">A</td>
			<td>
				<p align="justify" class="style1">
				DNS A lookup will be performed against the argument and the sending-host IP is compared to the IP addresses resolved by the DNS lookup. If any address matches, mechanism matches. </p>
				<p align="justify" class="style1"><em>Note: If no domain is specified in the argument than the current domain is used as the lookup. </em></p>
				<hr>
				<p align=justify>
				<h3>Help!</h3> To add a mechanism you should select Yes or Yes and Add a.<br>
				By selecting 'Yes' you can only add hostnames to A mechanism. You can enter hostnames throug textbox given. To add A mechanism with no arguments you should select 'Yes and Add a' , by selecting this you can also add hostnames through textbox given.
				<h3>What are A Records? </h3>
				A Record are used to translate human friendly domain names such as "www.mydomain.com" into IP-addresses such as 203.191.11.53 machine friendly numbers.
				These records are simple domain name to IP-address mapping.
				A-records are not required for all computers, but are needed for any computer that provides shared resources on a network.
				This record type is defined in RFC1035.
				</p>
			</td>
			<td>
				<%
					String aFlag = (String)request.getAttribute("aFlag");
					String hostname = (String)request.getAttribute("ahostnames");
				%>
				<% if(aFlag != null && aFlag.startsWith("yes")) {

					if(aFlag.equals("yes")) {
				%>
				
				<u>Include A mechanism</u><br>
				<input name="aFlag" type="radio" value="no"> &nbsp; No <br>
				<input name="aFlag" type="radio" value="yesa:"> &nbsp; Yes <br>
				<input name="aFlag" type="radio" value="yes" checked> &nbsp; Yes, with following domain names <br><br>

				<% } else if( aFlag.equals("yesa:") ) { %>
				
				<u>Include A mechanism</u><br>
				<input name="aFlag" type="radio" value="no"> &nbsp; No <br>
				<input name="aFlag" type="radio" value="yesa:" checked> &nbsp; Yes <br>
				<input name="aFlag" type="radio" value="yes"> &nbsp; Yes, with following domain names <br><br>
				
				<% } %>
					Enter hostname(s):
					<% if(hostname != null && !hostname.equals("")) { %>
						<textarea name="ahostnames" style="width:100%;" rows="7"><%=hostname%></textarea>
					<% } else { %>
						<textarea name="ahostnames" style="width:100%;" rows="7"></textarea>
					<% } %>

				<% } else { %>
				
				<u>Include A mechanism</u><br>
				<input name="aFlag" type="radio" value="no" checked> &nbsp; No <br>
				<input name="aFlag" type="radio" value="yesa:"> &nbsp; Yes <br>
				<input name="aFlag" type="radio" value="yes"> &nbsp; Yes, with following domain names <br><br>				
				<u>Enter hostname(s)</u>
				<textarea name="ahostnames" style="width:100%;" rows="7"></textarea>
				<br style="clear:both;"><br>
				<button class="btn btn-sm btn-submit pull-right" type="submit">Proceed</button>
				
				<% } %>
			</td>
		</tr>
		
		<!-- * * * * * * * * MX mechanicsm * * * * * * * * -->
		<tr>
			<td class="text-center">MX</td>
			<td>
				<p align="justify" class="style1">MX list is evaluated for the specified domain. MX lookup is performed against the domain. The list of IP addresses obtained is compared with the sending host IP address. If any address matches, the mechanism matches.</p>
				<hr>
				<p align=justify>
				<h3>Help!</h3> To add MX mechanism you should select Yes or Yes and Add mx.<br>
				By selecting 'Yes' you can only add hostnames to MX mechanism. You can enter hostnames throug textbox given. To add MX mechanism with no arguments you should select 'Yes and Add mx' , by selecting this you can also add hostnames through textbox given.
				<h3>What are MX-Records (Mail exchange)?</h3>
				MX-records are used to specify the email server(s) responsible for a domain name.
				Each MX-record points to the name of an email server and holds a preference number for that server.
				If a domain name is handled by multiple email servers , a separate MX-record is used for each email server, and the preference numbers then determine in which order (lower numbers first) these servers should be used by other email servers.
				If a domain name is handled by a single email server, only one MX-record is needed and the preference number does not matter.
				This record type is defined in RFC1035.
				</p>
			</td>
			<td>
				<%
					String mxFlag = (String)request.getAttribute("mxFlag");
					String mxhostname = (String)request.getAttribute("mxhostnames");
				%>
				<% if(mxFlag != null && mxFlag.startsWith("yes")) {

					if(mxFlag.equals("yes")) {
				%>
				
				<u>Include MX mechanism</u><br>
				<input name="mxFlag" type="radio" value="no"> &nbsp; No <br>
				<input name="mxFlag" type="radio" value="yesmx:"> &nbsp; Yes <br>
				<input name="mxFlag" type="radio" value="yes" checked> &nbsp; Yes, with following domain names <br><br>

				<% } else if( mxFlag.equals("yesmx:") ) { %>
				
				<u>Include MX mechanism</u><br>
				<input name="mxFlag" type="radio" value="no"> &nbsp; No <br>
				<input name="mxFlag" type="radio" value="yesmx:" checked> &nbsp; Yes <br>
				<input name="mxFlag" type="radio" value="yes"> &nbsp; Yes, with following domain names <br><br>
				
				<% } %>
				<u>Enter hostname(s)</u>
					<% if(mxhostname != null && !mxhostname.equals("")) { %>
						<textarea name="mxhostnames" style="width:100%;" rows="7"><%=mxhostname%></textarea>
					<% } else { %>
						<textarea name="mxhostnames" style="width:100%;" rows="7"></textarea>
					<% } %>
					
				<% } else { %>

				<u>Include MX mechanism</u><br>
				<input name="mxFlag" type="radio" value="no" checked> &nbsp; No <br>
				<input name="mxFlag" type="radio" value="yesmx:"> &nbsp; Yes <br>
				<input name="mxFlag" type="radio" value="yes"> &nbsp; Yes, with following domain names <br><br>
				
				<u>Enter hostname(s)</u>
				<textarea name="mxhostnames" style="width:100%;" rows="7"></textarea>
				<br style="clear:both;"><br>
				<button class="btn btn-sm btn-submit pull-right" type="submit">Proceed</button>
				
				<% } %>
			</td>
		</tr>
		
		<!-- * * * * * * * * PTR mechanicsm * * * * * * * * -->
		<tr>
			<td class="text-center">PTR</td>
			<td>
				<p align="justify" class="style1">This mechanism has two phases. In first phase PTR lookup is performed against the sending-host IP address to obtain hostname or hostnames. A lookup is performed against each record to validate the sending host IP address. Second phase involves validation of hostnames to see they actually are in the domain name specified in the argument. If any hostname is matched the mechanism matches if none matches than mechanism fails.</p>
				<hr>
				<p align=justify>
				<h3>Help!</h3> To add PTR mechanism you should select Yes or Yes and Add ptr.<br>
				By selecting 'Yes' you can only add hostnames to PTR mechanism. You can enter hostnames throug textbox given. To add PTR mechanism with no arguments you should select 'Yes and Add ptr' , by selecting this you can also add hostnames through textbox given.
				<h3>What are PTR-Records?</h3>
				A PTR record is the reverse of an A record. That is, it maps an IP address to a hostname, rather than vice versa. Given an IP address of the form a.b.c.d, the usual form for a PTR record is this:
				<br>d.c.b.a.in-addr.arpa.   PTR     host.name.
				</p>
			</td>
			<td>
				<%
				String ptrFlag = (String)request.getAttribute("ptrFlag");
				String ptrhostname = (String)request.getAttribute("ptrhostnames");
				%>
				<% if(ptrFlag != null && ptrFlag.startsWith("yes")) {

				if(ptrFlag.equals("yes")) {
				%>
				
				<u>Include PTR mechanism</u><br>
				<input name="ptrFlag" type="radio" value="no"> &nbsp; No <br>
				<input name="ptrFlag" type="radio" value="yesptr:"> &nbsp; Yes <br>
				<input name="ptrFlag" type="radio" value="yes" checked> &nbsp; Yes, with following domain names <br><br>

				<% } else if( ptrFlag.equals("yesptr:") ) { %>
				
				<u>Include PTR mechanism</u><br>
				<input name="ptrFlag" type="radio" value="no"> &nbsp; No <br>
				<input name="ptrFlag" type="radio" value="yesptr:" checked> &nbsp; Yes <br>
				<input name="ptrFlag" type="radio" value="yes"> &nbsp; Yes, with following domain names <br><br>
				
				<% } %>
				
				<u>Enter hostname(s)</u>
				<% if(ptrhostname != null && !ptrhostname.equals("")) { %>
					<textarea name="ptrhostnames" style="width:100%;" rows="7"><%=ptrhostname%></textarea></td>
				<% } else { %>
					<textarea name="ptrhostnames" style="width:100%;" rows="7"></textarea></td>
				<% } %>
				</tr>

				<% } else { %>

				<u>Include PTR mechanism</u><br>
				<input name="ptrFlag" type="radio" value="no" checked> &nbsp; No <br>
				<input name="ptrFlag" type="radio" value="yesptr:"> &nbsp; Yes <br>
				<input name="ptrFlag" type="radio" value="yes"> &nbsp; Yes, with following domain names <br><br>
				
				<u>Enter hostname(s)</u>
				<textarea name="ptrhostnames" style="width:100%;" rows="7"></textarea>
				<br style="clear:both;"><br>
				<button class="btn btn-sm btn-submit pull-right" type="submit">Proceed</button>
				
				<% } %>
			</td>
		</tr>
		
		<!-- * * * * * * * * IP4 mechanicsm * * * * * * * * -->
		<tr>
			<td class="text-center">IP4</td>
			<td>
				<p align="justify" class="style1">This mechanism matches if the sending-host is from a given IP4 network.</p>
				<hr>
				<h3>Help!</h3> To add IP4 mechanism you should select Yes.
				By selecting 'Yes' you can add IP Addresses to IP4 mechanism. You can enter IP Addresses throug textbox given.</p>
			</td>
			<td>
				<%
				String ip4Flag = (String)request.getAttribute("ip4Flag");
				String ip4hostname = (String)request.getAttribute("ip4hostnames");
				%>
				<% if(ip4Flag != null && ip4Flag.startsWith("yes")) {

				if(ip4Flag.equals("yes")) {
				%>
				
				<u>Include IP4 mechanism</u><br>
				<input name="ip4Flag" type="radio" value="no"> &nbsp; No <br>
				<input name="ip4Flag" type="radio" value="yes" checked> &nbsp; Yes <br><br>
			
				<% } %>
				
					<u>Enter IP Addresses(s)</u>
					<% if(ip4hostname != null && !ip4hostname.equals("")) { %>
						<textarea name="ip4hostnames" style="width:100%;" rows="7"><%=ip4hostname%></textarea></td>
					<% } else { %>
						<textarea name="ip4hostnames" style="width:100%;" rows="7"></textarea></td>
					<% } %>

				<% } else { %>

				<u>Include IP4 mechanism</u><br>
				<input name="ip4Flag" type="radio" value="no" checked> &nbsp; No <br>
				<input name="ip4Flag" type="radio" value="yes"> &nbsp; Yes <br><br>
				
				<u>Enter IP Addresses(s)</u>
				<textarea name="ip4hostnames" style="width:100%;" rows="7"></textarea>
				<br style="clear:both;"><br>
				<button class="btn btn-sm btn-submit pull-right" type="submit">Proceed</button>
				
				<% } %>
			</td>
		</tr>
		
		<!-- * * * * * * * * INCLUDE mechanicsm * * * * * * * * -->
		<tr>
			<td class="text-center">INCLUDE</td>
			<td>
				<p align="justify" class="style1">SPF Client must lookup the SPF record for the domain defined as the argument and perform Test against the record. The test is only assumed match if inner test returns PASS or UNKNOWN otherwise it means test does not match.</p>
				<hr>
				<h3>Help!</h3>
				To add Include mechanism you should select Yes.<br>
				By selecting 'Yes' you can add hostnames to Include mechanism. You can enter hostnames through textbox given.</p>
			</td>
			<td>
				<%
				String includeFlag = (String)request.getAttribute("includeFlag");
				String includehostname = (String)request.getAttribute("includehostnames");
				%>
				<% if(includeFlag != null && includeFlag.startsWith("yes")) {

				if(includeFlag.equals("yes")) {
				%>
				
				<u>Add Include mechanism</u><br>
				<input name="includeFlag" type="radio" value="no"> &nbsp; No <br>
				<input name="includeFlag" type="radio" value="yes" checked> &nbsp; Yes <br><br>
			
				<% } %>
				
				<u>Enter hostname(s)</u>
				<% if(includehostname != null && !includehostname.equals("")) { %>
					<textarea name="includehostnames" style="width:100%;" rows="7"><%=includehostname%></textarea></td>
				<% } else { %>
					<textarea name="includehostnames" style="width:100%;" rows="7"></textarea></td>
				<% } %>

				<% } else { %>

				<u>Add Include mechanism</u><br>
				<input name="includeFlag" type="radio" value="no" checked> &nbsp; No <br>
				<input name="includeFlag" type="radio" value="yes"> &nbsp; Yes <br><br>
				
				<u>Enter hostname(s)</u>
				<textarea name="includehostnames" style="width:100%;" rows="7"></textarea>
				<br style="clear:both;"><br>
				<button class="btn btn-sm btn-submit pull-right" type="submit">Proceed</button>
				
				<% } %>
			</td>
		</tr>
		
		<!-- * * * * * * * * ALL mechanicsm * * * * * * * * -->
		<tr>
			<td class="text-center">ALL</td>
			<td>
				<p align="justify" class="style1">This mechanism always matches whenever it occurs it mean any machine anywhere. It can also be used as wild card to valid all machines. It is placed at the rightmost of the SPF record to provide an explicit default result.</p>
				<hr>
				<p><h3>Help!</h3> To add All mechanism you should select Yes.<br>
				By selecting 'Yes' you can set the result by selecting any option from list box.</p>
			</td>
			<td>
				<%
				String allFlag = (String)request.getAttribute("allFlag");
				String allResult = (String)request.getAttribute("allResult");
				%>

				<% if(allFlag != null && allFlag.equals("no")) { %>

				<u>Add All mechanism</u><br>
				<input name="allFlag" type="radio" value="no" checked> &nbsp; No <br>
				<input name="allFlag" type="radio" value="yes"> &nbsp; Yes <br><br>
				
				<u>What result should be evaluated?</u>

				<select class="form-control" name="allResult" id="allResult">
					<option value="0" selected>None</option>
					<option value="+">Pass</option>
					<option value="-">Fail</option>
					<option value="~">Softfail</option>
					<option value="?">Neutral</option>
				</select>
				<% } else { %>

				<u>Add All mechanism</u><br>
				<input name="allFlag" type="radio" value="no"> &nbsp; No <br>
				<input name="allFlag" type="radio" value="yes" checked> &nbsp; Yes <br><br>
				
				<u>What result should be evaluated?</u>
				
				<select class="form-control" name="allResult" id="allResult">
					<% if(allResult != null && !allResult.equals("") && !allResult.equals("0") ) { %>
					<option value="<%=allResult%>" selected><%=resultToName(allResult)%></option>
					<% } else { %>
					<option value="-" selected="selected">Fail</option>
					<% } %>
					<option value="0" >None</option>
					<option value="+">Pass</option>
					<option value="~">Softfail</option>
					<option value="?">Neutral</option>
				</select>
				<br style="clear:both;"><br>
				<button class="btn btn-sm btn-submit pull-right" type="submit">Proceed</button>
				
				<% } %>
			</td>
		</tr>
	</table>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
