<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>


<%

List sideButtons = new ArrayList(5);

//Variables for FAQ
boolean showFAQ = false;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "Reports");
%>


<%@ include file="CommonButtons.jsp" %>
<%@ include file="NewPageHeader.jsp" %>

<%
String infoMsg = (String) request.getAttribute("infoMsg");

if(infoMsg != null){
	%>
	<div class="infoMessage"><%=infoMsg %></div>
	<%
}
%>

<h1>Keystore Parameters</h1>
<br>
<div class="row">
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Configuration</div>
			<div class="well-info-body">
				<form  action="<%= request.getAttribute("appPath") %>" method="post">
					<br style="clear:both;">
					<span class="form-control form-left form-text pull-left wth-5">Keystore file name</span>
					<input class="form-control form-right pull-left wth-5" type="text" value="<%= request.getAttribute("keystoreFileName") %>" name="keystoreFileName" size="40">
					
					<br style="clear:both;">
					<span class="form-control form-left form-text pull-left wth-5">Keystore password</span>
					<input class="form-control form-right pull-left wth-5" type="password" value="<%= request.getAttribute("keystorePassword") %>" name="keystorePassword" size="15">
					
					<br style="clear:both;">
					<span class="form-control form-left form-text pull-left wth-5">Keystore type</span>
					<select class="form-control form-right pull-left wth-5" name="keystoreType">
						<option value="jks" <%= request.getAttribute("keystoreTypeJKS") %>>JKS - default</option>
						<option value="PKCS12" <%= request.getAttribute("keystoreTypePKCS12") %>>PKCS12</option>
					</select>
					
					<br style="clear:both;">
					<button class="btn btn-sm btn-submit pull-right" type="submit">Save</button>
					<br style="clear:both;">
					<input type="hidden" name="operation" value="187">
				</form>
			</div>
		</div>
	</div>
</div>

<br>
<h1>Using SSL</h1>
<br>
<div class="well">
	Before enabling SSL, you need to create an SSL certificate. A self-signed certificate is included in Xeams allowing you to the SSL functionality before
	investing in an SSL certificate. This self-sign certificate is <b>NOT</b> trusted by any browser or email client. As a result, you will see a message
	warning you about the certificate. Once you accept this warning message and tell the browser/email client to trust this certificate you will be able to 
	use SSL in Xeams.
</div>

<h3 class="text-center">There are several options for applying a certificate:</h3>

<div class="row">

	<div class="col-md-6 col-md-offset-3">
		<div class="well-info-wrap">
			<div class="well-info-header"><b>Option 1</b> - Create a FREE SSL Certificate through Let's Encrypt (Recommended)</div>
			<div class="well-info-body">
			
				<div class="row">
					<div class="col-md-9">
					<p style="text-align:justify">
						Let's Encrypt is non-profile certificate authority that provides X.509 certificates for TLS/SSL at no charge. 
						<a href="<%=response.encodeURL("FrontController?operation=259") %>">Click here</a> to configure/manage certificates signed by Let's Encrypt. 
						These certificates must be renewed every 90 days. Xeams can automatically renew them, provided you have a server listening on port 80.
					</p>
					</div>
					<div class="col-md-3">
					<br><br>
					<center>
						<a href="http://xeams.com/video-letsencrypt.htm" title="Watch a short video on this topic" style="text-align:center" target="_blank">
						<button type="button" class="btn btn-default">
						  <span class="glyphicon glyphicon-facetime-video" aria-hidden="true"></span> Video
						</button>
						
					</center>
					</div>
					
				</div>
				
				
				<br><br>
				<center>
					<a href="<%=response.encodeURL("FrontController?operation=259") %>" 
					title="Create a free certificate using Let's Encrypt"><button class="btn btn-submit" style="width:250px">
					<%
					if(request.getAttribute("oldCertExists").equals("true")){
						%>Manage Existing Certificate<%
					}else{
						%>Create A New Certificate<%
					}
					
					%>
					</button></a>
				</center>
			</div>
		</div>
	</div>
	
	
	
	<br style="clear:both;"><br>
	
	
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header"><b>Option 2</b> - Continue using the self-signed certificate</div>
			<div class="well-info-body">
				This option is only viable if you can ask every use to trust the certificate. An SSL certificate solves two problems: first, it encrypts the data between client and server
				and second, it ensures the identity of the server. By using a self-signed certificate you can achieve the first goal but not second - meaning data will still be encrypted
				but the server's identity cannot be verified.
			</div>
		</div>
	</div>
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header"><b>Option 3</b> - Create a new certificate</div>
			<div class="well-info-body">
				Use this option if you want to use Xeams in production environment and you do not have any other certificate for this domain. 
				<a href="http://www.xeams.com/usingssl.htm" target="_blank">Click here</a> for instructions on how to create a new certificate for your domain. An important
				point to keep in mind is that certificates are tied to domain names. For example, if the hostname of your email server (where Xeams is running) is mail.yourcompany.com, you 
				will need a certificate matching this value. You can also use a wildcard certificate.
			</div>
		</div>
	</div>
	
	
	
	<br style="clear:both;"><br>
	
	
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header"><b>Option 4</b> - Import a certificate from an IIS server</div>
			<div class="well-info-body">
				Use this option if you want to use Xeams in production environment and you have a Microsoft IIS server <b>with a certificate</b> already running in your company.
				You can export a certificate from IIS and import it into Xeams using the following steps:
				<ul>
					<li><a href="http://www.microsoft.com/technet/prodtechnol/WindowsServer2003/Library/IIS/2cfeeba2-511f-47e8-913c-f196b74e6a44.mspx?mfr=true" target="_blank">Click here</a>
					for instructions on how to export a certificate from an IIS server.</li>
					
					<li>Export the certificate to a .pfx file</li>
					<li>You will have to specify a password during the export procedure. Use this password in the form you see above.</li>
					<li>Save the .pfx file to the config folder and specify its path to the <b>Keystore file name</b> field in the form above.</li>
					<li>Select <b>PKCS12</b> from the keystore type.
				</ul>
			</div>
		</div>
	</div>
	
	
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header"><b>Option 5</b> - Import a certificate from an Apache HTTPD server</div>
			<div class="well-info-body">
				Use this option if you want to use Xeams in production environment and you have a Apache HTTPD <b>with a certificate</b> already running in your company.
				Use the steps below to convert an Apache certificate to Xeams:
				<ul>
					<li><a href="https://www.xeams.com/importing-apache-cert.htm" target="_blank">Click here</a>
					for instructions on how to export a certificate from an Apache server.</li>
					<li>Once the keystore is ready, copy it to the config folder.</li>
				</ul>
			</div>
		</div>
	</div>
	
	
</div>

<%@ include file="NewPageFooter.jsp" %>