<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>URL Sandbox <small>Results</small></h1>
<br>

<%
Integer fc = (Integer) request.getAttribute("forwardCount");
String goodIcon = "<span style='color:green'><i class='glyphicon glyphicon-ok'> </i></span> ";
String noGoodIcon = "<span style='color:red'><i class='glyphicon glyphicon-remove'> </i></span> ";
String badDomain = "<span style='color:red'><i class='glyphicon glyphicon-thumbs-down'> </i></span> ";
String goodDomain = "<span style='color:green'><i class='glyphicon glyphicon-thumbs-up'> </i></span> ";


%>
<div class="row">
	<div class="col-md-4">
	<H3>What is a Sandbox</H3>
	URL Sandboxing allow you to inspect suspicious URL before you click them.
	
	<%
	if(fc.intValue() > 0){
		%>
		
		<h2>What is Forward Count</h2>
		Often URLs are redirected from several web servers. 
		<b>Forward Count</b> display the number of hops before reaching final destination. Xeams will
		evaluate the reputation of each intermediate hop and display a <%=badDomain %> icon if the host is blacklisted. 
		
		<%
	}
	%>
	</div>
	<div class="col-md-8">
	
		<!-- ******* Create Window Panel ******* -->
		<div class="well-info-wrap">
			<div class="well-info-header">Sandbox Results</div>
			<div class="well-info-body">
				<!-- 
				
				request.setAttribute("certSignedBy", results.getCertSignedBy());
				request.setAttribute("downloadedFilename", results.getDownloadedFileName());
				request.setAttribute("isText", "" + results.isText());
				request.setAttribute("contentLength", results.getContentLengthStr());
				request.setAttribute("contentType", results.getContentType());
				request.setAttribute("errorMsg", results.getError());
				request.setAttribute("forwardCount", results.getForwardCount());
				request.setAttribute("host", results.getHost());
				request.setAttribute("prevLocs", results.getPreviousLocations());
				request.setAttribute("secure", "" + results.isSecure());
				request.setAttribute("certTrusted", results.isSslCertTrusted());
				request.setAttribute("success", results.isSuccess());
				
				 -->
				 
				<%
				
				boolean success = (Boolean) request.getAttribute("success");
				
				if(!success){
					%>
					<div class="alert alert-danger"><h4>Error</h4>An error occurred while processing the actual URL. Message: <%= request.getAttribute("errorMsg") %></div>
					<%
				}

				boolean sslUsed = request.getAttribute("secure").equals("true");
				boolean isDownload = !request.getAttribute("isText").equals("true");
				boolean certTrusted = request.getAttribute("certTrusted").equals("true");
				
				%> 
				<table class="table table-bordered table-condensed">
					<tr><th><acronym title="The link eventually leads to this hostname">Hostname</acronym>:</th><td><%= request.getAttribute("host") %></td></tr>
					<tr><th>SSL Used:</th><td><%= sslUsed ? (goodIcon + "Yes") : (noGoodIcon + "No") %></td></tr>
					<%
					if(sslUsed){
					%>
					<tr><th>Certificate&nbsp;Authority:</th><td><%= request.getAttribute("certSignedBy") %></td></tr>
					<tr><th>Certificate&nbsp;Trusted:</th><td><%= certTrusted ? (goodIcon + "Yes")  : (noGoodIcon + "No") %></td></tr>
					<%} %>
					
					
					<tr><th>Downloads&nbsp;File:</th><td><%= isDownload ? (badDomain + "Yes") : (goodDomain + "No") %></td></tr>
					
					<%
					if(isDownload){
					%>
					<tr><th>File&nbsp;Name:</th><td><%= request.getAttribute("downloadedFilename") %></td></tr>
					<tr><th>File&nbsp;Size:</th><td><%= request.getAttribute("contentLength") %></td></tr>
					<%} %>
					
					
					<%
					
					if(fc.intValue() > 0){
						%>
						<tr><th>Forward&nbsp;Count:</th><td><%= ((Integer) request.getAttribute("forwardCount") + 1) %>
						<br><b>Intermediate Hops:</b><br>
						
						<%
						List<String> hops = (List<String>) request.getAttribute("prevLocs");
						DomainReputationBean blDomains = new DomainReputationBean(hops);
						
						
						for(String aHop : hops){
							String blReason = blDomains.isBlackListed(aHop);
							if(blReason == null){
								out.print(goodDomain);
							}else{
								%>
								<acronym title="Blacklisted by: <%= blReason%>"><%=badDomain %></acronym>
								<%
							}
							%>
							<code><%=aHop %></code><hr>
							<%
						}
						%>
						<%
					}else{
						%>
						<tr><th>Link:</th><td>
						<%
						List<String> fakeList = new ArrayList<String>();
						fakeList.add(request.getAttribute("orgUrl").toString());
						DomainReputationBean blDomains = new DomainReputationBean(fakeList);
						String blReason = blDomains.isBlackListed(request.getAttribute("orgUrl").toString());
						if((blReason == null)){
							out.print(goodDomain);
						}else{
							%>
							<acronym title="Blacklisted by: <%= blReason%>"><%=badDomain %></acronym>
							<%
						}
						%>
						<code><%= request.getAttribute("orgUrl") %></code><hr>
						<%
					}
					%>
					</td></tr>
					
				</table>
				
				<% 
				if(isDownload){
				%>	
				It appears the link eventually downloads <code><%= request.getAttribute("downloadedFilename")%></code>. 
				Therefore, only click the <b>Proceed</b> button if you're sure the contents are safe.
				<%
				}else{
					%>
				Although it appears that the link leads to an HTML page, using JavaScripts a malicious site can still
				redirect you to download file(s). Click <b>Proceed</b> if you're sure the link is safe.
					<%
				}
				%>
				<br><br>
				<center>
					<a href="<%= request.getAttribute("orgUrl") %>"><button class="btn btn-sm btn-submit">Proceed</button></a>
				</center>
				
				
			</div>
		</div>
	</div>
</div>







<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
