<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Sandbox Configuration</h1>
<br>

<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info"><%=infoMsg %></div>
	<%
}
%>

<div class="row">
	<div class="col-md-7">
		Sandboxing wraps every URL contained in inbound email messages with a different URL so the user is forced to 
		go through Xeams when they click a hyperlink in their email. Xeams will inspect the URL and display detail information
		about it so the user can make a better decision before proceeding.
		<br><br>
		Sandboxing does the following:<br><br>
		<ul>
			<li>Warns the user if a link leads to a file download</li>
			<li>Lets the user know if the link hops between multiple servers</li>
			<li>Warns if any of the intermediate hops are blacklisted</li>
			<li>Confirms if SSL is used</li>
		</ul>
		<div class="alert alert-warning"><h4>Important:</h4>Sandbox will use the URL specified for <b>Preferred URL</b> in 
			<a href="<%=response.encodeURL("FrontController?operation=158") %>">Server Configuration</a>. Therefore, ensure that
			value is correct.</div>
	
	</div>
	<div class="col-md-5">
		<div class="well-info-wrap">
		<div class="well-info-header">Configuration Parameters</div>
		<div class="well-info-body">
			<form action="<%= request.getAttribute("appPath") %>" method="post">
			
			
				<!-- ******* Create Checkbox Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('enableSB')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-7">Enable Sandbox</span>
				<span class="chkbox-cust form-control form-right pull-left wth-2">
					<input id="lblEnableSB" type="checkbox" name="enableSB" <%= request.getAttribute("sbEnabled") %>>
					<label for="lblEnableSB"></label>
				</span>
			    <br style="clear:both;">
				<div class="alert alert-info more_info" id="enableSB">
					If checked, Sandboxing is enabled. No other option matters if this box is not checked.
				</div>
				
				
				<!-- ******* Create Checkbox Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('skipTrusted')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-7">Skip Trusted Domains</span>
				<span class="chkbox-cust form-control form-right pull-left wth-2">
					<input id="lblSkipTrusted" type="checkbox" name="skipTrusted" <%= request.getAttribute("ignoreTrusted") %>>
					<label for="lblSkipTrusted"></label>
				</span>
			    <br style="clear:both;">
				<div class="alert alert-info more_info" id="skipTrusted">
					If checked, Sandboxing will not occur if the sender belongs to a <a href="<%=response.encodeURL("FrontController?operation=194") %>">trusted domain</a>.
				</div>
				

				<!-- ******* Create Text Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('minScore')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-6">Minimum Score</span>
				<input class="form-control form-right pull-left wth-3" type="number" name="minScore" value="<%= request.getAttribute("minScore") %>" required>
			
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="minScore">
					Sandboxing will only occur if the final score is higher than this value.
				</div>
			
				<br><br>
			
				<!-- ******* Save Button | default is pulled right ******* -->
				<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
			
				<br><br>
				<input type="hidden" name="operation" value="260">
				<input type="hidden" name="st" value="s">
				 
			</form>
			
			
			
		</div>
	</div>
	
	</div>

</div>









<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
