<%@ page import="com.synametrics.xeams.bean.*" %>
<%@ page import="java.util.*" %>
<% 

List sideButtons = new ArrayList(5);
sideButtons.add(new UrlAnchorHolder("Server Configuration", "current", true));

//Variables for FAQ
boolean showFAQ = true;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "MainMenu");



com.synametrics.xeams.config.AppConfig smConf = com.synametrics.xeams.config.AppConfig.getInstance();

String boundIPStr = com.synametrics.xeams.bean.ResourceBean.printAvailableIPOptions(smConf.getSmtpProxyBindIP());

%>

<%@ include file="CommonButtons.jsp" %>
<%@ include file="NewPageHeader.jsp" %>

<h1>Server Configuration</h1>

<%
String infoMessage = (String)request.getAttribute("InfoMessage");

if(infoMessage != null){
	out.println("<div class=\"alert alert-info text-center\">" + infoMessage + "</div>");
}
%>

<br>
<ul class="nav nav-tabs" role="tablist" id="myTab">
  <li role="presentation" class="active"><a href="#basic" aria-controls="basic" role="tab" data-toggle="tab">Basic</a></li>
  <li role="presentation"><a href="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
  <li role="presentation"><a href="#challenge" aria-controls="challenge" role="tab" data-toggle="tab">Challenge Response</a></li>
  <li role="presentation"><a href="#proxy" aria-controls="proxy" role="tab" data-toggle="tab">HTTP Proxy</a></li>
</ul>


<form action="<%= request.getAttribute("appPath") %>" method="post">
<div class="tab-content">
	<div role="tabpanel" class="tab-pane active config-box fade in" id="basic">
		<div class="row">
			<div class="col-md-3">
				<br style="clear:both">
				<a href="<%=response.encodeURL("FrontController?operation=245") %>" title="Manage a list of IP addresses administrator's can connect.">
				<span class="btn btn-success">Access Control</span></a>
			</div>
			<div class="col-md-6">
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('serverType')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Server Type</span>
				<select class="form-control form-right pull-left wth-5" name="serverType">
					<option value="1" <%=smConf.getServerType() == 1 ? "selected" : "" %> >Stand-alone server</option>
					<option value="2" <%=smConf.getServerType() == 2 ? "selected" : "" %> >Spam firewall</option>
					<option value="3" <%=smConf.getServerType() == 3 ? "selected" : "" %> >Hybrid mode</option>
				</select>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="serverType">
					<%=productName %> has 3 modes of operation:
					<ol>
						<li><b>Stand-alone email server - </b>Full email server supporting SMTP, IMAP, and POP3. User mailboxes are 
								created on <%=productName %>. No other email server is required.</li>
						<li><b>Spam firewall - </b>Acts as a spam firewall that sits in front of another email server. Processes every email and sends good message to another server, 
													such as Microsoft Exchange, Sendmail, Lotus Dominos or any other SMTP server. 
													User mailboxes are not created on <%=productName %></li>
						<li><b>Hybrid mode - </b>Acts as a stand-alone as well as a spam firewall. This configuration serves as a backup
												for your main email server.</li>
						
					</ol>
				</div>
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('serverPort')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Web Server Port</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="webServerPort" value="<%=smConf.getWebServerPort() %>">

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="serverPort">
					TCP/IP port number on which the embedded web server listens on. <p>
					You will have to restart <%=productName %> after you change this value. Additionally, 
					remember to change the URL of your browser before connecting.
				</div>
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('serverPort2')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">2nd Web Server Port</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="webServerPort2" value="<%=smConf.getWebServerPort2() %>">

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="serverPort2">
					Secondary TCP/IP port for HTTP. You will have to restart <%=productName %> after you change this value. Additionally, 
					remember to change the URL of your browser before connecting.
				</div>
				
				
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('secureServerPort')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Secure Web Server Port</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="secureWebServerPort" value="<%=smConf.getSecureWebServerPort() %>">

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="secureServerPort">
					TCP/IP port number on which the SSL web server listens on. <p>
					You will have to restart <%=productName %> after you change this value. Additionally, 
					remember to change the URL of your browser before connecting.
				</div>
				
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('forceHttps')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Force HTTPS</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chkForceHttps" name="forceHttps" type="checkbox" <%=smConf.isForceHttps()? " checked " : ""%>>
					<label for="chkForceHttps"></label>
				</span>

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="forceHttps">
					If checked, <%=productName %> will redirect HTTP connections to HTTPS.
				</div>
				
				
				
				
				
				
				
				<%
				if(smConf.getDnsServer() != null && smConf.getDnsServer().length() > 0){
				%>
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('dnsServer')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">DNS Server</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="dnsServer" value="<%=smConf.getDnsServer() %>">

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="dnsServer">
					The DNS server that will be used to resolve IP hostnames. Leave this value blank to use the DNS server configured
					for the machine.
				</div>
				<%
				}
				%>
				
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('adminEmail')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Administrator's Email</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="adminEmail" value="<%=smConf.getAdminEmail() %>">

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="adminEmail">
					Email address of the administrator. Often <%= productName %> sends out-bound emails to the administrator containing
					important information about the server's status. Daily reports are also sent to this email address. 
					<p><b>It is very important that you specify this value correctly.</b><p>
					Specify multiple values separated by a comma.
				</div>
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('preferredUrl')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Preferred URL</span>
				<input class="form-control form-right pull-left wth-5" type="url" name="preferredUrl" value="<%=smConf.getPreferredUrl() %>">
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="preferredUrl">
					URL used in email alerts connecting back to the Admin Console. If this value is missing, Xeams will try to determine its value based on the local IP address
					of the machine.
				</div>
				
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('statusReport')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Send Daily Status Report</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chk-dailyRep" name="sendStatus" type="checkbox" <%=smConf.isStatusEmailNotification() ? " checked " : ""%>>
					<label for="chk-dailyRep"></label>
				</span>

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="statusReport">
					When this box is checked, <%= productName %> will send a daily status report to the administrator 
					containing information about your server.
				</div>
			</div>
		</div>
	</div>
	
	<!-- ***************************************************
		 ******** END BASIC CONFIG / START ADVANCED ********
		 *************************************************** -->
	
	<div role="tabpanel" class="tab-pane config-box fade in" id="advanced">
		<div class="row">
			<div class="col-md-3"></div>
			<div class="col-md-6">
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('multiDomain')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Multi-Profile</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chk-multiDomain" name="chkMultiDomain" type="checkbox" <%=smConf.isMultiDomain() ? " checked " : ""%>>
					<label for="chk-multiDomain"></label>
				</span>

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="multiDomain">
					The Multi-Profile feature in Xeams allows you to specify a different set of spam filtering rules on a per-domain basis.<br><br>
					You can also delegate the administration tasks to a domain administrator who can add/modify filtering rules for that domain.
					<a href="<%=helpSite %>MultiDomain.htm">Refer to our website for details</a>.
				</div>
				
				
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('oneClick')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">One-Click Restore</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chk-oneClick" name="oneClickRestore" type="checkbox" <%=!smConf.isAskQuestionWhenUserTriesToRestoreEmailFromDailyReport() ? " checked " : ""%>>
					<label for="chk-oneClick"></label>
				</span>

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="oneClick">
					If checked, emails will be restored from user reports without asking any further questions. When this is not checked, user
					will be prompted for a few questions.</strong>.
				</div>
				
				
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('autoUpdate')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Enable Auto-Update</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chk-autoUpdate" name="chkAutoUpdate" type="checkbox" <%=smConf.isAutoUpdateEnabled() ? " checked " : ""%>>
					<label for="chk-autoUpdate"></label>
				</span>

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="autoUpdate">
					If checked, <%=productName %> will check for new updates every night and download the latest release
					to your server. <p><strong>It is strongly recommended that you leave this option on</strong>.
				</div>
				
				
				
				
				
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('autoNotify')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Enable Auto-Notification</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chk-autoNotify" name="chkAutoUpdateNotification" type="checkbox" <%=smConf.isAutoUpdateNotificationEnabled() ? " checked " : ""%>>
					<label for="chk-autoNotify"></label>
				</span>

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="autoNotify">
					If checked, <%=productName %> will send an email to the administrator(s) notifying about the changes made. 
					<p><strong>It is strongly recommended that you leave this option on</strong>.
				</div>
				
				<!-- 
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('xeamsFooter')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Xeams Footer</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chk-footer" name="chkXeamsAd" type="checkbox" <%=smConf.isXeamsAdEnabled() ? " checked " : ""%>>
					<label for="chk-footer"></label>
				</span>

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="xeamsFooter">
					If checked, Xeams will add a footer to every message that will read:<br><br>
					Powered by Xeams. Visit xeams.com for more information.<br><br>
					<a href="<%=helpSite%>HelpUsSpreadTheWord.htm">Click here</a> for more information.
				</div>
				-->
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('posSpam')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Include possible spam in report</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chk-spamRep" name="chkIncludePossibleSpamInDailyReport" type="checkbox" <%=smConf.isIncludePossibleSpamInDailyReport() ? " checked " : ""%>>
					<label for="chk-spamRep"></label>
				</span>

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="posSpam">
					If checked, messages that fall into possible spam category will be added to the daily report that gets sent
					to users.
				</div>
				
				
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('allowTempEmails')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Allow temporary email addresses</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="allowTempEmails" name="allowTempEmails" type="checkbox" <%=smConf.isAllowTempEmailsWithPlusSign() ? " checked " : ""%>>
					<label for="allowTempEmails"></label>
				</span>

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="allowTempEmails">
					If checked, <%=productName %> will consider emails sent to <code>user+AnyTempValue@company.com</code> to be a temporary email
					address for <code>user@company.com</code>. Any thing after the plus sign (+) in an email address will be considered an alias for the user. A format <code>user+YYYYMMDD@company.com</code> can be used to specify an expiration date. For
					Example, <code>user+20161231@company.com</code> will work until Dec. 31, 2016. This address will be rejected after Dec 31, 2016.
				</div>
				
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('autoBlockBadIP')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Block Malicious IP Addresses</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="blockBadIP" name="blockBadIP" type="checkbox" <%=smConf.isAutoBlacklistBadIP() ? " checked " : ""%>>
					<label for="blockBadIP"></label>
				</span>

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="autoBlockBadIP">
					If checked, <%=productName %> will automatically block connections from IP addresses that try to guess user's passwords.
				</div>
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('chkForce2FA')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Mandatory 2FA</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="tfaMandatory" name="tfaMandatory" type="checkbox" <%=smConf.isTFAMandatory() ? " checked " : ""%>>
					<label for="tfaMandatory"></label>
				</span>

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="chkForce2FA">
					If checked, users will be forced to use two-factor authentication
				</div>
				
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('allowSynRBL')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Disable SynRBL</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chkDisableSynRBL" name="disableSynRBL" type="checkbox" <%=smConf.isSynRblSubmissionDisabled() ? " checked " : ""%>>
					<label for="chkDisableSynRBL"></label>
				</span>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="allowSynRBL">
					If checked, submissions to SynRBL will be disabled. It is recommended you do not check this box. 
					<b>Check <a href="http://xeams.com/synrbl.htm" _target="_blank">http://xeams.com/synrbl.htm</a> for details.</b>
				</div>
				
				
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('heloDomain')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Smtp HELO domain</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="txtSmtpHello" value="<%=smConf.getSmtpHeloCommand()%>" size="40">

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="heloDomain">
					Text to be passed as part of SMTP HELO command to a connecting client.
				</div>
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('smtpSig')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Smtp Signature</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="txtSignature" value="<%=smConf.getSmtpSignature() %>" size="40">

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="smtpSig">
					Banner used to greet an incoming SMTP client.
				</div>
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('retryInt')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Retry Interval</span>
				<input class="form-control form-right pull-left wth-5 text-center" type="number" name="txtRetryInterval" value="<%=smConf.getSmtpRetryInterval()%>"  >

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="retryInt">
					Time to wait in minutes before retrying an outbound email. 
				</div>
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('retryCount')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Retry Count</span>
				<input class="form-control form-right pull-left wth-5 text-center" type="number" name="txtRetryCount" value="<%=smConf.getSmtpRetryCount()%>"  >

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="retryCount">
					Number of times to retry an outbound email message.
				</div>
				
				
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('maxScoreForReports')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Max Score For Reports</span>
				<input class="form-control form-right pull-left wth-5 text-center" type="number" name="txtMaxScoreForReports" value="<%=smConf.getMaxScoreForReports()%>" >

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="maxScoreForReports">
					Daily report sent to users will not contain messages that score higher than this value. For example, if this value is specified at 300, the daily report sent
					to the users will only contain messages lower than 300. This value must be higher than 0 to take affect.
				</div>
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('autoLoginDays')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Auto Login Days</span>
				<input class="form-control form-right pull-left wth-5 text-center" type="number" name="autoLoginDays" value="<%=smConf.getAutoLoginDays()%>" >

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="autoLoginDays">
					<p>Number of days for users to remain logged in to the web interface. Use 0 to disable this feature. </p>
				</div>
				
				
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('masterReportRecipient')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Global Report Recipient</span>
				<input class="form-control form-right pull-left wth-5 text-center" type="email" name="masterReportRecipient" value="<%=smConf.getMasterReportRecipient() %>"  size="4">

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="masterReportRecipient">
					If specified, a blind carbon copy (BCC) of the daily reports will be sent to this address besides the actual recipient.
				</div>
				
				
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('spamLearner')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Spam Learner Address</span>
				<input class="form-control form-right pull-left wth-5 text-center" type="email" name="spamLearner" value="<%=smConf.getSpamLearner() %>"  size="4">

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="spamLearner">
					When user receive spam or possible spam messages in their Inbox, they can optionally forward that message to this email address. Xeams will mark the original 
					message as spam and learn from its mistake. <br><br>
					Visit <a href="http://www.xeams.com/spam-learner.htm" target="_blank">http://www.xeams.com/spam-learner.htm</a> for details.
				</div>
			</div>
		</div>
	</div>
	
	<!-- *******************************************************
		 ******** END ADVANCED CONFIG / START CHALLENGE ********
		 ******************************************************* -->
	
	<div role="tabpanel" class="tab-pane config-box fade in" id="challenge">
		<div class="row">
			<div class="col-md-3"></div>
			<div class="col-md-6">
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('chalResp')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Enable Challenge Response</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chk-chalResp" name="cresponse" type="checkbox" <%=smConf.isChallengeResponseEnabled() ? " checked " : ""%>>
					<label for="chk-chalResp"></label>
				</span>

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="chalResp">
					Checking this box enables the challenge/response feature in <%=productName %>. 
					This mechanism is a type of spam filter that automatically sends a reply with a challenge 
					to the (alleged) sender of an incoming email. In this reply, the sender is asked to perform 
					some action to assure delivery of the original message, which would otherwise not be delivered. 

					<p>
					We do not recommend that you enable this mechanism of filtering junk emails. Many users
					on the Internet consider such mechanisms as rude.
				</div>
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('chalRespEmail')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Email</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="cresponseEmail" <%=smConf.getChallengeResponseEmail()%>>

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="chalRespEmail">
					This MUST be a valid email address in your company, which is required by the challenge/response mechanism to route the message back to your server. IMPORTANT:This address will only be used for routing - no emails will be sent to this address.
					<p>We recommend that you use the postmaster account for this field, example: postmaster@YourCompanyDomain.com</p>
				</div>
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('chalRespThresh')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Threshold</span>
				<input class="form-control form-right pull-left wth-5 text-center" type="text" name="cresponseThreshold" value="<%=smConf.getChallengeResponseThreshold() %>">

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="chalRespThresh">
					Challenge/response email will only be sent if the email score is below this number. Consider the following example:
					<ul>
						<li>Assume every email that is assigned a score of more than 100 is considered junk.</li>
						<li>You receive 3 emails and their respective scores are 20, 150 and 550</li>
						<li>Challenge/Response threshold is set to 300</li>
						<li>The first email is considered good and a challenge is never generated</li>
						<li>The score for the second message is lower than 300 and therefore a challenge will be generated</li>
						<li>The score of the last message to higher and therefore, it is safer to consider is junk. A challenge email will 
							not be generated.</li>
					</ul>
				</div>
			</div>
		</div>
	</div>
	
	<!-- **************************************************
		 ******** END CHALLENGE / START HTTP PROXY ********
		 ************************************************** -->
	
	<div role="tabpanel" class="tab-pane config-box fade in" id="proxy">
		<div class="row">
			<div class="col-md-3"></div>
			<div class="col-md-6">
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('httpProxy')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">HTTP Proxy</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chk-httpProxy" name="chkHttpProxyEnabled" type="checkbox" <%=smConf.isHttpProxyEnabled() ? " checked " : ""%>>
					<label for="chk-httpProxy"></label>
				</span>

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="httpProxy">
					Check this box if <%=productName %> is not able to connect directly to the Internet and must go through a proxy server.

					<p>
					Periodically, your copy of <%=productName %> tries to connect to our web server to pull latest release
					of the server. Besides software updates, it also needs to pull latest virus signatures, new filtering rules and
					FAQ questions. All this information is retrieved using the HTTP protocol. 
					<p>
					We recommend that you let <%=productName %> connect to the Internet without any proxy server. Having said that, if your
					company's network requires the use of a proxy server, you can enable that by checking this box.
				</div>
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('proxyServ')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Proxy Server Host</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="txtProxyHost" value="<%=smConf.getHttpProxyHost()%>">

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="proxyServ">
					Hostname of your HTTP proxy server.
				</div>
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('proxyServPort')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Proxy Server Port</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="txtProxyPort" value="<%=smConf.getHttpProxyPort() %>">

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="proxyServPort">
					TCP/IP port on which your proxy server listens for incoming client connections.
				</div>
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('proxyServUser')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Proxy Server User</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="txtProxyUid" value="<%=smConf.getHttpProxyUid() %>">

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="proxyServUser">
					A user id for your proxy server. Leave this blank if your server does not require authentication.
				</div>
				
				
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('proxyServPwd')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Proxy Server Password</span>
				<input class="form-control form-right pull-left wth-5" type="text" name="txtProxyPwd" value="<%=smConf.getHttpProxyPwd() %>">

				<br style="clear:both;">
				<div class="alert alert-info more_info" id="proxyServPwd">
					Password for the user specified above. Leave this blank if your server does not require authentication.
				</div>
			</div>
		</div>
	</div>
</div>

<div class="col-md-9"><br><button class="btn btn-sm btn-submit pull-right" type="Submit">Save</button></div>
<input type="hidden" name="operation" value="157">
</form>

<script>
	$('#myTab a').click(function (e) {
	  e.preventDefault()
	  $(this).tab('show')
	});
</script>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
