<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>


<%
List sideButtons = new ArrayList(5);
sideButtons.add(new UrlAnchorHolder("Initial Setup", "current", true));



//Variables for FAQ
boolean showFAQ = true;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "Setup5");
%>
<%@ include file="NewPageHeader.jsp" %>

<div class="row">
	<div class="col-md-1 col-xs-1 text-center">
		<br><br><br><br><br>
		<span class="initial glyphicon glyphicon-ok" style="color:#8fbb91;" title="Admin Email &amp; Password"></span>
		<br><br>
			<span>&nbsp;</span>
		<br><br>
		
		<span class="initial glyphicon glyphicon-ok" style="color:#8fbb91;" title="Select Server Type"></span>
		<br><br>
			<span>&nbsp;</span>
		<br><br>
		
		<span class="initial glyphicon glyphicon-ok" style="color:#8fbb91;" title="Corporate Email Server"></span>
		<br><br>
			<span>&nbsp;</span>
		<br><br>
		
		<span class="initial glyphicon glyphicon-ok" style="color:#8fbb91;" title="Domain Configuration"></span>
		<br><br>
			<span>&nbsp;</span>
		<br><br>
		
		<span class="initial glyphicon glyphicon-record" style="color:#8fbb91;" title="Complete Setup"></span>
		<br><br>
			<span class="glyphicon glyphicon-option-vertical" style="color:#c76c64;"></span>
		<br><br>
		
		<a href="<%=response.encodeURL("FrontController?operation=60") %>"><span class="initial glyphicon glyphicon-home" title="Connect to Admin Console"></span></a>
		
		<br><br>
	</div>
	
	<div class="col-md-10 col-xs-11">
		<h1>Setup is now complete <small class="pull-right">Initial Setup Wizard</small></h1>
		<br>
		<div class="well">
			<%=productName %> has collected all necessary information required to run.
		</div>
		
		<%
		String errorMessage = (String)request.getAttribute("errorMessage");
		if(errorMessage != null && errorMessage.length() > 0){
			out.println("<div class=\"alert alert-danger text-center\">ERROR: " + errorMessage + "</div>");
		}


		int i = 0;
		%>
		<table class="table table-striped table-bordered table-hover">
			<tr class="well-info-header">
				<td colspan="2">Server Information</td>
			</tr>
			
			<tr class="well-info-additional">
				<td colspan="2">Based on your answers <%=productName %> has made the following configuration changes to this system. You can change
				these settings by logging into the admin console any time you like.</td>
			</tr>
			
			<tr>
				<td><b>Administrator's email:</b></td>
				<td><%=request.getAttribute("adminEmail") %></td>
			</tr>


			<tr>
				<td><b>Server Type:</b></td>
				<td><%=request.getAttribute("serverType") %></td>
			</tr>

			<tr>
				<td><b>Local domains:</b></td>
				<td>
				<%
				if(request.getSession().getAttribute("stHybrid") != null && request.getSession().getAttribute("stHybrid").equals("true") && request.getAttribute("domainList") != null){
					
					List<LocalDomain> domainList = (List<LocalDomain>)request.getAttribute("domainList");
					%>
					<table class="table table-condensed">
						<%
						for(LocalDomain oneDomain : domainList){
						%>
						<tr>
							<td><%= oneDomain.toString() %></td>
							<td> <i class="glyphicon glyphicon-arrow-right"></i></td>
							<td><%= oneDomain.getForwardTo() %></td>
						</tr>
						<%
						}
						%>
					</table>
					
					<%
				}else{
					%>
					<ul><%=request.getAttribute("localDomains") %></ul>
					<%
				}
				%>
				
				
				</td>
			</tr>

			<tr>
				<td><b>SMTP Server:</b></td>
				<td><%=request.getAttribute("smtpServer") %></td>
			</tr>
			<!-- 
			<tr>
				<td><b>Corporate Email Server:</b></td>
				<td><%=request.getAttribute("targetSmtp") %></td>
			</tr>

			
			
			<tr>
				<td><b>SMTP Proxy Server:</b></td>
				<td><%=request.getAttribute("smtpProxyServer") %></td>
			</tr>
			-->
			<tr>
				<td><b>IMAP Server:</b></td>
				<td><%=request.getAttribute("imapServer") %></td>
			</tr>

			<tr>
				<td><b>POP3 Server:</b></td>
				<td><%=request.getAttribute("pop3Server") %></td>
			</tr>

			<!-- 
			<tr>
				<td><b></b></td>
				<td></td>
			</tr>
			 -->

		</table>
		
		<div class="row">
			<div class="col-md-6">
				<div class="well-info-wrap">
					<div class="well-info-header">What do I have to do next?</div>
					<div class="well-info-body">
						<ul>
							<li><a href="<%=response.encodeURL("FrontController?operation=65") %>">Run diagnostics</a> - Runs a few tests to see if every is working the way it is supposed to</li>
							<li><a href="<%=response.encodeURL("FrontController?operation=500") %>">Manage users</a> - Create new users in the server</li>
							<li><a href="<%=response.encodeURL("FrontController?operation=60") %>">View Admin Console</a> - Connect to the main configuration window</li>
							<li><a href="<%=response.encodeURL("FrontController?operation=259") %>">SSL certificate</a> - Create a free SSL certificate
							<li>Send a test message</a> - Send a test message from the Internet to see if everything is working</li>						
						</ul>
					</div>
				</div>
			</div>
			
			<br class="hide_lg">
			<div class="col-md-6">
				<div class="well-info-wrap">
					<div class="well-info-header">Useful Links</div>
					<div class="well-info-body">
						<i class="glyphicon glyphicon-link"></i> <a href="http://www.xeams.com/how-to-encrypt-emails.htm" target="_blank" title="How to send encrypted emails containing sensitive data">End-to-End Encryption</a><br>
						<i class="glyphicon glyphicon-link"></i> <a href="http://www.xeams.com/ImprovingRules.htm" target="_blank" title="Tips on improving filtering in Xeams">Tips on improving filtering</a><br>
						<i class="glyphicon glyphicon-link"></i> <a href="http://www.xeams.com/spf-dkim-dmarc.htm" target="_blank" title="How to use SPF, DKIM and DMARC">How to use DKIM, DMARC and SPF</a><br>
						<i class="glyphicon glyphicon-link"></i> <a href="http://xeams.com/TroubleshootingInbound.htm" target="_blank" title="Troubleshooting common problems associated with inbound emails">Troubleshooting inbound email</a><br>
						
						<i class="glyphicon glyphicon-link"></i> <a href="http://www.xeams.com/best-practices.htm" target="_blank" title="Best practices for Xeams">Best Practices - Running Xeams</a><br>
						<i class="glyphicon glyphicon-link"></i> <a href="http://www.xeams.com/user-benefits.htm" target="_blank" title="Why you should create local users in Xeams">Benefits of creating users</a><br>
						
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<%@ include file="NewPageFooter.jsp" %>
