<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>


<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<%
EmailCheckResult theResult = (EmailCheckResult)request.getAttribute("theResult");

if(theResult == null){
   out.println("<div class=\"alert alert-danger text-center\">No results available</div>");
   return;
}

String category = "Unknown";

if(theResult.getMsgType() == MaxEmailActions.GOOD){
    category = "<div class=\"alert alert-info text-center\">This is a <b>Good</b> message.</div>";
}else if(theResult.getMsgType() == MaxEmailActions.SPAM){
    category = "<div class=\"alert alert-danger text-center\">This is a <b>Spam</b> message.</div>";
}else if(theResult.getMsgType() == MaxEmailActions.POSSIBLE_SPAM){
    category = "<div class=\"alert alert-warning text-center\">This is a <b>Possible Spam</b> message.</div>";
}

long[] perfTime = theResult.getPerfTime();
%>

<h1>Spam Simulator Results Page</h1>
<br>
<%=category%>

<div class="row">
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Reasons</div>
			<div class="well-info-body">
				<%= ReasonFormatter.generateHTML(theResult.getReason().toString(), "")%>
				<br>
				Total Score: <b><%=theResult.getFinalScore()%></b>
			</div>
		</div>
		<br style="clear:both;">
		<a href="<%= response.encodeURL("FrontController?operation=193") %>"><button class="btn btn-sm btn-menu pull-right">Test Again</button></a>
	</div>
	
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Performance Metrics</div>
			<div class="well-info-body no-padding">
				<table class="table table-striped table-bordered table-hover">
				<tr>
				<td>Message preparation took </td><td><%=perfTime[EmailCheckResult.PI_POST_FORMATTED_OBJ_CREATE] - perfTime[EmailCheckResult.PI_PRE_FORMATTED_OBJ_CREATE]%> (ms)</td>
				</tr>
				<tr>
				<td>Attachemnt filters took </td><td><%=perfTime[EmailCheckResult.PI_POST_ATTACHMENT] - perfTime[EmailCheckResult.PI_PRE_ATTACHMENT]%> (ms)</td>
				</tr><tr>
				<td>Bayesian filter took </td><td><%=perfTime[EmailCheckResult.PI_POST_BAYESIAN] - perfTime[EmailCheckResult.PI_PRE_BAYESIAN]%> (ms)</td>
				</tr><tr>
				<td>Body filters took </td><td><%=perfTime[EmailCheckResult.PI_POST_BODY] - perfTime[EmailCheckResult.PI_PRE_BODY]%> (ms)</td>
				</tr><tr>
				<td>Custom filters took </td><td><%=perfTime[EmailCheckResult.PI_POST_CUSTOM] - perfTime[EmailCheckResult.PI_PRE_CUSTOM]%> (ms)</td>
				</tr><tr>
				<td>Header filters took </td><td><%=perfTime[EmailCheckResult.PI_POST_HEADER] - perfTime[EmailCheckResult.PI_PRE_HEADER]%> (ms)</td>
				</tr><tr>
				<td>Subject filters took </td><td><%=perfTime[EmailCheckResult.PI_POST_SUBJECT] - perfTime[EmailCheckResult.PI_PRE_SUBJECT]%> (ms)</td>
				</tr><tr>
				<td>Sender filters took </td><td><%=perfTime[EmailCheckResult.PI_POST_SENDER] - perfTime[EmailCheckResult.PI_PRE_SENDER]%> (ms)</td>
				</tr><tr>
				<td>RBL filters took </td><td><%=perfTime[EmailCheckResult.PI_POST_RBL] - perfTime[EmailCheckResult.PI_PRE_RBL]%> (ms)</td>
				</tr>
				<tr>
				<td>SPF lookup took </td><td><%=perfTime[EmailCheckResult.PI_POST_SPF] - perfTime[EmailCheckResult.PI_PRE_SPF]%> (ms)</td>
				</tr>
				</table>	
			</div>
		</div>		
	</div>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
