
<%@ page import="java.util.*" %>

<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<h1>Smart Host</h1>

<div class="row">
	<div class="col-md-3"></div>
	<div class="col-md-6">
		<div class="well">
			A Smart Host is used in Xeams to deliver out-going mail through another SMTP server (which is called a "smart host", hence the name). 
			The smart host will deliver your mail to the other SMTP server on your behalf. This is exactly what you do when you use 
			Outlook Express to send mail using your ISP SMTP servers.
		</div>

		<%
		String allDomains = (String) request.getAttribute("allDomains");
		if(allDomains.length() > 0){
			%>
			<div class="alert alert-warning">
			<b>WARNING:</b> You have defined ALLDOMAINS in the local host file. You MUST remove this entry from the local host file before using Smart Host.
			<a href="<%=response.encodeURL("FrontController?operation=85") %>">Click here</a> to configure local host file.
			</div>
			<%
		}

		String errorMessage = (String) request.getAttribute("errorMsg");
		if(errorMessage != null){
			%>
			<div class="alert alert-danger">
			<b>ERROR:</b> <%=errorMessage %>
			</div>
			<%
		}

		%> 
		
		<br><br>

		<form action="<%= request.getAttribute("appPath") %>" method="post">
		<div class="well-info-wrap">
			<div class="well-info-header">Smart Host Configuration</div>
			<div class="well-info-body no-padding">
				<div class="well-info-additional">Smart host is only applicable for out-going emails. It cannot be used for in-bound messages.</div>
				<div style="padding:10px;">
					<br style="clear:both;">
					<span class="form-control pull-left form-left form-text wth-5">Hostname</span>
					<input class="form-control pull-left form-right text-center wth-5" type="text" name="hostName" value="<%=request.getAttribute("hostName")%>" title="Hostname or IP address of the smart host server">
					
					<br style="clear:both;"><br>
					<span class="form-control pull-left form-left form-text wth-5">TCP/IP Port</span>
					<input class="form-control pull-left form-right text-center wth-5" type="text" name="port" value="<%=request.getAttribute("port")%>">
					
					<br style="clear:both;"><br>
					<span class="form-control pull-left form-left form-text wth-5">User ID</span>
					<input class="form-control pull-left form-right text-center wth-5" type="text" name="uid" value="<%=request.getAttribute("uid")%>" autocomplete="off" title="Leave this field blank if no authentication is required">
					
					<br style="clear:both;"><br>
					<span class="form-control pull-left form-left form-text wth-5">Password</span>
					<input class="form-control pull-left form-right text-center wth-5" type="password" name="pwd" value="<%=request.getAttribute("pwd")%>" autocomplete="off">
					
					<br style="clear:both;"><br>
					<h3 class="text-center">Security</h3>
					<div style="padding:20px; border:solid 1px #aaa; background-color:#fbfbfb;">
						<span class="form-control pull-left form-left form-text wth-9">Use STARTTLS</span>
						<span class="chkbox-cust form-control form-right pull-left wth-1">
							<input id="chk-tls" type="checkbox" value="1" name="useSTARTTLS" <%=request.getAttribute("useSTARTTLS")%> title="Check here if your server expects authentication using STARTTLS">
							<label for="chk-tls"></label>
						</span>
						
						<br style="clear:both;"><br>
						<span class="form-control pull-left form-left form-text wth-9">Use SSL/TLS</span>
						<span class="chkbox-cust form-control form-right pull-left wth-1">
							<input id="chk-sslTls" type="checkbox" value="1" name="useSSL" <%=request.getAttribute("useSSL")%> title="Check here to connect over SSL">
							<label for="chk-sslTls"></label>
						</span>
						
						<br style="clear:both;">
					</div>
					
					<br style="clear:both;">
					<button class="btn btn-sm btn-submit pull-right" type="submit">Save</button>
					<input type="hidden" name="operation" value="184">
					<br style="clear:both;">
				</div>
			</div>
		</div>
		</form>
	</div>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
