<!-- ******** NEW_SKIN_2015 ******** -->

<%@ page import="com.synametrics.xeams.config.*, com.synametrics.xeams.bean.*" %>
<%@ page import="java.util.*" %>
<%

List sideButtons = new ArrayList(5);
sideButtons.add(new UrlAnchorHolder("Smtp Configuration", "current", true));

//Variables for FAQ
boolean showFAQ = true;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "SmtpServerConfig");
%>

<%@ include file="CommonButtons.jsp" %>
<%@ include file="NewPageHeader.jsp" %>

<h1>SMTP Server Configuration</h1>

<%
String enabled = (String)request.getAttribute("StagingServerEnabled");
String smtpPort = (String)request.getAttribute("SmtpPort");
String smtpPort2 = (String)request.getAttribute("SmtpPort2");
String smtpPortSSL = (String)request.getAttribute("SmtpPortSSL");
List<LocalDomain> domainList = (List<LocalDomain>)request.getAttribute("DomainList");
String relayFrom = (String)request.getAttribute("RelayFrom");
String openRelay = (String)request.getAttribute("OpenRelay");
String ndrEnabled = (String)request.getAttribute("ndrEnabled");
String ndrEmail = (String)request.getAttribute("ndrEmail");
String ndrIncludeBodyEnabled = (String) request.getAttribute("ndrIncludeBodyEnabled");
String ndrOnlyForOutboundEmails = (String) request.getAttribute("ndrOnlyForOutboundEmails");
String asyncProcessing = (String)request.getAttribute("AsyncProcessing");
String catchAllRecipient = (String)request.getAttribute("catchAllRecipient");
String relayThruSlaves = (String) request.getAttribute("relayThruSlaves");
String rncCRLF = (String) request.getAttribute("rncCRLF");
String dotSeparatedTemp = (String) request.getAttribute("dotSeparatedTemp");
String reqAuthForLocal = (String) request.getAttribute("reqAuthForLocal");
String junkNdr = (request.getAttribute("junkNdr") != null && request.getAttribute("junkNdr").equals("true")) ? " checked " : "";
 
String closeRelay;

if(openRelay != null && openRelay.equals("true")){
 	openRelay = " checked";
	closeRelay = " ";
}else{
	openRelay = " ";
	closeRelay = " checked";
}



if(enabled != null && enabled.equalsIgnoreCase("true")){
 	enabled = " checked ";
}else{
 	enabled = " ";
}

if(ndrEnabled != null && ndrEnabled.equalsIgnoreCase("true")){
 	ndrEnabled = " checked ";
}else{
 	ndrEnabled = " ";
}

if(ndrEmail == null)
	ndrEmail = "";

if(ndrIncludeBodyEnabled != null && ndrIncludeBodyEnabled.equalsIgnoreCase("true")){
 	ndrIncludeBodyEnabled = " checked ";
}else{
 	ndrIncludeBodyEnabled = " ";
}


if(ndrOnlyForOutboundEmails != null && ndrOnlyForOutboundEmails.equalsIgnoreCase("true")){
    ndrOnlyForOutboundEmails = " checked ";
}else{
    ndrOnlyForOutboundEmails = " ";
}

if(asyncProcessing != null && asyncProcessing.equalsIgnoreCase("true")){
 	asyncProcessing = " checked ";
}else{
    asyncProcessing = " ";
}

String boundIPStr = com.synametrics.xeams.bean.ResourceBean.printAvailableIPOptions((String)request.getAttribute("BindIP"));

String errorMsg = (String)request.getAttribute("errorMsg");
if(errorMsg != null && errorMsg.length() > 0){
	out.println("<div class=\"alert alert-danger text-center\">ERROR: " + errorMsg + "</div>");		 
}

String infoMessage = (String)request.getAttribute("infoMessage");
if(infoMessage != null && infoMessage.length() > 0){
	out.println("<div class=\"alert alert-info text-center\">" + infoMessage + "</div>");		 
}


%>






<br>
<ul class="nav nav-tabs" role="tablist" id="myTab">
  <li role="presentation" <%= ResourceBean.selectActiveTab(request, "basic", false) %> ><a href="#basic" aria-controls="basic" role="tab" data-toggle="tab">Basic</a></li>
  <li role="presentation" <%= ResourceBean.selectActiveTab(request, "domain", false) %> ><a href="#domain" aria-controls="domain" role="tab" data-toggle="tab">Domain</a></li>
  <li role="presentation" <%= ResourceBean.selectActiveTab(request, "relay", false) %> ><a href="#relay" aria-controls="relay" role="tab" data-toggle="tab">Relaying</a></li>
  <li role="presentation" <%= ResourceBean.selectActiveTab(request, "advanced", false) %> ><a href="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
</ul>

<div class="tab-content">
	<div role="tabpanel" class="tab-pane <%= ResourceBean.selectActiveTab(request, "basic", true) %>" id="basic">
		<div class="config-box">
			<h3>Basic Configuration</h3>
			
			<br style="clear:both;">
			<div class="row">
				<div class="col-md-4">
					<div class="alert alert-warning">
					<b>IMPORTANT</b> You must <a href="<%=response.encodeURL("FrontController?operation=187") %>">configure SSL</a> before using either SSL or STARTTLS.
					</div>
					
					<%
					if(request.getAttribute("tomcatNotSecured") != null){
						%>
						<div class="alert alert-danger">
						<b>WARNING: </b> STARTTLS extension will only work if you have configured the HTTP server to listen on a secure port. 
						<a href="<%=response.encodeURL("FrontController?operation=158") %>">Click here</a> to specify a secure web server port.
						</div>
						<%
					}
					%>
					
					<br><br>
					<div class="alert alert-success">
						<h3>Dynamic Recipient Verification</h3>
						<a href="<%=response.encodeURL("FrontController?operation=226") %>">Click here</a> to configure DRV, which validates
						the recipient of an incoming email with another SMTP server.
					</div>
					
				</div>
				<div class="col-md-6">
					<form action="<%= request.getAttribute("appPath") %>" method="post">
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('enableSMTP')"><b>?</b></div>
						<span class="form-control form-text form-middle pull-left wth-8">Server Enabled</span>
						<span class="chkbox-cust form-control form-right pull-left wth-1"><input id="chk-srv" type="checkbox" value="1" name="serverEnabled" <%=enabled%>><label for="chk-srv"></label></span>
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="enableSMTP">
							If checked, SMTP server will run in the background and will accept incoming client connections.
						</div>



						<br style="clear:both;"><br>
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('enableTLS')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-7">Enable STARTTLS</span>
						<a href="<%=response.encodeURL("FrontController?operation=187") %>" style="color:#fff;"><div class="btn btn-warning form-control pull-left form-middle wth-1" title="SSL Configuration"><span class="glyphicon glyphicon-cog"></span></div></a>
						<span class="chkbox-cust form-control form-right pull-left wth-1"><input id="chk-tls" type="checkbox" value="1" name="enableSTARTTLS" <%=request.getAttribute("enableSTARTTLS") == null ? "" : " checked='checked' "%>><label for="chk-tls"></label></span>

						<br style="clear:both;">
						<div class="alert alert-info more_info" id="enableTLS">
							If checked, the STARTTLS extension is turned on. SSL must be configured in order for this option to work.
						</div>



						<br style="clear:both;"><br>
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('smtpPort')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-5">Primary Smtp Port</span>
						<input type="text" class="form-control form-right pull-left text-center wth-4" name="smtpPort" value="<%=smtpPort%>">
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="smtpPort">
							TCP/IP port number on which the SMTP server will listen for incoming emails. The default
							value for this field is 25.
						</div>


						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('allowSmtpAuthOnPrimary')"><b>?</b></div>
						<span class="form-control form-text form-middle pull-left wth-8">Allow SMTP Authentication</span>
						<span class="chkbox-cust form-control form-right pull-left wth-1"><input id="chk-smtpAuth" type="checkbox" value="1" name="allowSmtpAuthOnPrimary" <%=request.getAttribute("allowSmtpAuthOnPrimary")%> ><label for="chk-smtpAuth"></label></span>
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="allowSmtpAuthOnPrimary">
							If checked, SMTP authentication is allowed on primary port. Often companies do not allow authentication on the primary port for security reasons.
						</div>



						<br style="clear:both;"><br>
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('smtpPort2')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-5">Secondary SMTP Port</span>
						<input type="text" class="form-control form-right pull-left text-center wth-4" name="smtpPort2" value="<%=smtpPort2%>">
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="smtpPort2">
							Optionally, you can make the SMTP server listen on a secondary port, which is useful if the primary
							port is blocked by a firewall or ISP for some of the users. Use a -1 to disable it.
							<br><br>
							Refer to <a href="http://www.xeams.com/SecondarySmtpPorts.htm">this
							knowledgebase article</a> for details.
						</div>

						<br style="clear:both;"><br>
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('smtpPortSSL')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-5">Secure SMTP Port (SSL)</span>
						<input type="text" class="form-control form-right pull-left text-center wth-4" name="smtpPortSSL" value="<%=smtpPortSSL%>">
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="smtpPortSSL">
							TCP/IP port number on which the Secure SMTP server (SSL) will listen for incoming emails. The default
							value for this field is 465.
						</div>

						<br style="clear:both;"><br>
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('bindTo')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-5">Bind To</span>
						<select class="form-control pull-left wth-4" name="lstBindIP"><%=boundIPStr%></select>
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="bindTo">
							Binding IP address for the server. If you choose "All unassigned", the server
							will listen on all IP address that are configured for this machine.
						</div>

						<br style="clear:both;"><br>
						<button type="submit" class="btn btn-sm btn-submit pull-right">Save</button>
						<input type="hidden" name="operation" value="161">
					</form>
				</div>
			</div>
			<br style="clear:both;">
		</div>
	</div>
	
	<!-- END BASIC CONFIGURATION , START DOMAIN CONFIGURATION -->
	
	<div role="tabpanel" class="tab-pane <%= ResourceBean.selectActiveTab(request, "domain", true) %>" id="domain">
		<div class="config-box">
			<h3>Local domain configuration</h3>

			<%
			if(request.getAttribute("displayDomainHeader") != null){
			%>
			<div class="well">This tab contains a list of domain names that are considered local for this server. If this server 
			is either configured to run in <a href="<%=helpSite %>3Modes.htm">Firewall or hybrid</a> mode, you
			will also have to specify the IP address where emails should get forwarded to.</div>
			<%
			} 
			%>

			<%
			String pageNumber = (String) request.getAttribute("cpn");
			if(pageNumber == null){
				pageNumber = "1";	
			}
			
			%>
			<div class="row">
				<div class="col-md-2">
					<%
					if(request.getAttribute("haspp") != null){
						%>
						<a href="<%= response.encodeURL("FrontController?operation=533&pn=" + request.getAttribute("haspp")) %>" title="Previous Page"><button class="btn btn-submit">Previous</button></a>
						<%
					}
					%>
				</div>
				<div class="col-md-2">
					Displaying page <b><%=pageNumber %></b> of <b><%= request.getAttribute("tp") %></b>
				</div>
				
				<div class="col-md-4">
					<form class="form-inline pull-right"  action="<%= request.getAttribute("appPath") %>" method="post" >
					  <div class="form-group">
					    <label class="sr-only" for="stxt">Filter</label>
					    <div class="input-group">
					      <div class="input-group-addon"><i class="glyphicon glyphicon-search"></i></div>
					      <input type="text" class="form-control" id="stxt" placeholder="Search" name="stxt">
					      <!-- <div class="input-group-addon">.00</div> -->
					    </div>
					  </div>
					<input type="hidden" name="operation" value="533"> 
					</form>
				</div>
				
				<div class="col-md-2">
					<a href="<%=response.encodeURL("FrontController?operation=256") %>" title="Quickly create multiple domains"><button class="btn btn-sm btn-menu"><span class="glyphicon glyphicon-import"></span> &nbsp; Import Domains</button></a>
				</div>
				<div class="col-md-2">
				<%
					if(request.getAttribute("hasnp") != null){
						%>
						<span class="pull-right">
						<a href="<%= response.encodeURL("FrontController?operation=533&pn=" + request.getAttribute("hasnp")) %>" title="Next Page"><button class="btn btn-submit">Next</button></a>
						</span>
						<%
					}
					%>
				</div>
			</div>
	
			<br><br>



			<div class="table-responsive">
				<table class="table table-striped table-bordered">
				<tr class="well-info-header">
					<th>Domain names</th>
					<th>Forwarded To</th>
					<th>Active Directory</th>
					<th class="text-center">Action</th>
				</tr>
				
				
				<%@ include file="NewSmtpDomain.jsp" %>
				
				
				<%
				int totalRows = 0;
				String rowColor;
				for(int i = 0;i < domainList.size(); i++){
					String oneName = domainList.get(i).getLocalHostName();
					String forwardedIP;
					
					if(AppConfig.getInstance().getServerType() == AppConfig.ST_STAND_ALONE){
						forwardedIP = "N/A";
					}else{
						forwardedIP = domainList.get(i).getForwardToResolveIfNecessary();
						
						if(forwardedIP == null || forwardedIP.trim().length() == 0){
							forwardedIP = "Not specified";
						}
					}
					
					if((i % 2) == 0){
						rowColor = "style='background-color:White;'";
					}else{
						rowColor = "style='background-color:#EEEEEE;'";
					}
					
					totalRows++;
					%>
					<tr>
					<td><%=oneName %></td>
					<td><%=forwardedIP %></td>
					<td><%= domainList.get(i).getFriendlyNameForAd() %></td>
					<td class="text-center"><a href="<%=response.encodeURL("FrontController?operation=159") %>&domain=<%=oneName %>#tab2">Remove</a></td>
					
					</tr>
					<%
				}

				if(totalRows > 1){
					%>
					<%@ include file="NewSmtpDomain.jsp" %>
					<%
				}
				%>
									
					
					
				</table>
				
				<div class="alert alert-info more_info wth-5" id="addDomain" style="margin-top:-30px;">
					Emails sent to local domain are either forwarded to a machine internal to your network or
					to the local drop box. <%=productName %> will always accept an email sent to local domain.  
					Case does not matter when you enter a domain name. For example,
					<ul>
					<li>yourcompany.com</li>
					<li>east.yourcompany.com</li>
					<li>west.yourcompany.com</li>            
					</ul>
				</div>
				
				<div class="alert alert-info more_info" id="addFwdAddress" style="margin-top:-30px;">
					Since your server is configured to run as 
					<a href="<%=helpSite %>3Modes.htm"><b><%=AppConfig.getInstance().getServerTypeString() %></b></a>, specify an IP address/hostname
					for a downstream server.
				</div>
			</div>
		</div>
	</div>
	
	<!-- END DOMAIN CONFIGURATION , START RELAY CONFIGURATION -->
	
	<div role="tabpanel" class="tab-pane <%= ResourceBean.selectActiveTab(request, "relay", true) %>" id="relay">
		<div class="config-box">
			<%@ include file="SmtpRelayConfig.jsp" %>		
		</div>
	</div>
	
	<!-- END RELAY CONFIGURATION , START ADVANCED CONFIGURATION -->
	
	<div role="tabpanel" class="tab-pane <%= ResourceBean.selectActiveTab(request, "advanced", true) %>" id="advanced">
		<div class="config-box">
			<form action="<%= request.getAttribute("appPath") %>#tab4" method="post">
			
			<div class="row">
				<div class="col-md-3"></div>
				<div class="col-md-6">
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('asynchProc')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-8">Asynchronous Processing</span>
					<span class="chkbox-cust form-control pull-left form-right text-center wth-1"><input id="chk-async" type="checkbox" value="1" name="asyncProcessingEnabled" <%=asyncProcessing%>><label for="chk-async"></label></span>
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="asynchProc">
						When enabled, <%= productName %> will accept messages asynchronously. The sender will never
						get an error message if the message is considered junk.
					</div>
					
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('mtob')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-8">High Volume Outbound</span>
					<span class="chkbox-cust form-control pull-left form-right text-center wth-1"><input id="chk-mtob" type="checkbox" 
						title="This option is available when using the Enterprise Edition with at least 20 users."
						value="1" name="mtob" <%= request.getAttribute("mtob") %> <%= request.getAttribute("eee") %> ><label for="chk-mtob"></label></span>
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="mtob">
						If checked, outbound messages will be sent simultaneously using multiple threads. This is useful when sending high volume of outbound messages.<br><br>
						<b>Note: </b> This option is only available when using the Enterprise Edition of Xeams and you have more than 20 users.
					</div>
					
					
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('sanitizeOb')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-8">Sanitize Outbound Headers</span>
					<span class="chkbox-cust form-control pull-left form-right text-center wth-1"><input id="chk-sanitizeOb" type="checkbox" 
						title="This option is available when using the Enterprise Edition with at least 20 users."
						value="1" name="sanitizeOb" <%= request.getAttribute("sanitizeOb") %> <%= request.getAttribute("eee") %> ><label for="chk-sanitizeOb"></label></span>
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="sanitizeOb">
						If checked, sensitive headers containing private information about your LAN is removed before sending outbound messages.<br><br>
						<b>Note: </b> This option is only available when using the Enterprise Edition of Xeams and you have more than 20 users.
					</div>
					
					
					
					
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('relayThruSlaves')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-8">Relay Through Clustered Slaves</span>
					<span class="chkbox-cust form-control pull-left form-right text-center wth-1"><input id="chk-relayThruSlaves" type="checkbox" value="1" name="relayThruSlaves" <%=relayThruSlaves%>><label for="chk-relayThruSlaves"></label></span>
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="relayThruSlaves">
						If checked, outbound messages will be relayed through clustered slaves if delivery fails from MASTER. This flag is only applicable
						when Xeams clustering is used and outbound emails are sent to MASTER.
					</div>
					
					
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('rejectNonconformantCRLF')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-8">Reject Noncompliant CRLF character sequence</span>
					<span class="chkbox-cust form-control pull-left form-right text-center wth-1"><input id="chk-rejectNonconformantCRLF" type="checkbox" value="1" name="rncCRLF" <%=rncCRLF%>><label for="chk-rejectNonconformantCRLF"></label></span>
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="rejectNonconformantCRLF">
						<p>If checked, client connections will be terminated if newline characters do not comply with 
						<a href="https://datatracker.ietf.org/doc/html/rfc5321#section-4.2.5" target="_blank">RFC 5321</a>. Enabling this option prevents misuse but
						some legacy scripts/software running on Linux may run into problem.</p>
						<p>Refer to <a href="https://www.xeams.com/smtp-smuggling.htm" target="_blank">https://www.xeams.com/smtp-smuggling.htm</a> for details.
					</div>
					
					
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('reqAuthForLocal')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-8">Require Authentication for Local Senders</span>
					<span class="chkbox-cust form-control pull-left form-right text-center wth-1"><input id="chk-reqAuthForLocal" type="checkbox" value="1" name="reqAuthForLocal" <%=reqAuthForLocal%>><label for="chk-reqAuthForLocal"></label></span>
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="reqAuthForLocal">
						Force users to use SMTP Authentication if the sender belongs to a local domain.
					</div>
					
					
					
					
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('greyList')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-7">Grey Listing:</span>
					<a href="<%= response.encodeURL("FrontController?operation=208") %>" class="btn btn-warning form-control pull-left form-middle wth-1" title="Configure Grey Listing"><span class="glyphicon glyphicon-cog"></span></a>
					<span class="chkbox-cust form-control pull-left form-right text-center wth-1"><input id="chk-grey" type="checkbox" name="greyListing" value="true" <%=request.getAttribute("greyListing")%>><label for="chk-grey"></label></span>
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="greyList">
						If checked, grey listing is enabled. Check <a href="http://xeams.com/GreyListing.htm" target="_blank">http://xeams.com/GreyListing.htm</a> for details.				
					</div>
							
							
							
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('dotSeparatedTemp')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-8">Enable Dot Separated Recipients</span>
					<span class="chkbox-cust form-control pull-left form-right text-center wth-1"><input id="chk-dotSeparatedTemp" type="checkbox" value="1" 
						name="dotSeparatedTemp" <%=dotSeparatedTemp%>><label for="chk-dotSeparatedTemp"></label></span>
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="dotSeparatedTemp">
						When enabled, the system will accept DOT separated addresses as valid recipients. For example, when an email comes
						in for <code>john.doe.amazon@yourcompany.com</code>, the system will look for <code>john.doe@yourcompany.com</code> and 
						will accept the message if a matching user is found locally.
					</div>
					
					
					
							
					<br style="clear:both;"><br>
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('catchAll')"><b>?</b></div>
					<span class="form-control pull-left form-middle form-text wth-4">Catch All</span>
					<input class="form-control pull-left form-right text-center wth-5" type="text" name="catchAllRecipient" value="<%=catchAllRecipient%>" size="30">
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="catchAll">
						When specified, emails sent to invalid users will be sent to this address. <b>Reject invalid users</b> flag is ignored
						when Catch All is specified.
					</div>		
							
							
							
									
							
					<h3 class="text-center">Non-delivery Report:</h3>
					
					<div style="padding:20px; border:solid 1px #aaa; background-color:#fbfbfb;">
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('enableNDR')"><b>?</b></div>
						<span class="form-control pull-left form-middle form-text wth-7">Enable NDR</span>
						<span class="chkbox-cust form-control pull-left form-right text-center wth-1"><input id="chk-ndr" type="checkbox" value="1" name="ndrEnabled" <%=ndrEnabled%>><label for="chk-ndr"></label></span>
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="enableNDR">
							If checked, <%= productName %> will generate an NDR for every non-delivered email.
						</div>
						
						<br style="clear:both;"><br>
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('includeOrig')"><b>?</b></div>
						<span class="form-control pull-left form-middle form-text wth-7">Include Original</span>
						<span class="chkbox-cust form-control pull-left form-right text-center wth-1"><input id="chk-incl" type="checkbox" value="1" name="ndrInludeBodyEnabled" <%=ndrIncludeBodyEnabled%>><label for="chk-incl"></label></span>
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="includeOrig">									
							If checked, the original message will be attached to the NDR. We recommend that
							you DO NOT check this option.				
						</div>
						
						<br style="clear:both;"><br>
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('outboundNDR')"><b>?</b></div>
						<span class="form-control pull-left form-middle form-text wth-7">Generate NDRs only for Outbound Emails</span>
						<span class="chkbox-cust form-control pull-left form-right text-center wth-1"><input id="chk-genNDR" type="checkbox" value="1" name="ndrOnlyForOutboundEmails" <%=ndrOnlyForOutboundEmails%>><label for="chk-genNDR"></label></span>
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="outboundNDR">
							If checked, NDRs will be generated only for outbound emails. This prevents someone else from using your server to bounce back
							spam messages.
						</div>
						
						
						<br style="clear:both;"><br>
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('junkNdrLbl')"><b>?</b></div>
						<span class="form-control pull-left form-middle form-text wth-7">Generate NDRs for Junk</span>
						<span class="chkbox-cust form-control pull-left form-right text-center wth-1"><input id="chk-junkNDR" type="checkbox" value="1" name="junkNdr" <%=junkNdr%>><label for="chk-junkNDR"></label></span>
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="junkNdrLbl">
							If checked, NDRs will be generated if an outbound email is marked as spam and gets quarantined.
						</div>
						
						
								
						<br style="clear:both;"><br>
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('NDRemail')"><b>?</b></div>
						<span class="form-control pull-left form-middle form-text wth-4">Sender's Email:</span>
						<input class="form-control pull-left form-right text-center wth-4" type="text" name="ndrEmail" value="<%=ndrEmail%>" size="30">
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="NDRemail">
						   Sender's Email Address for NDR. e.g postmaster@yourdomain.com.
						</div>

						
					</div>
					<br style="clear:both;">
					<button class="btn btn-sm btn-submit pull-right" type="submit">Save</button>
				</div>
			</div>
			<input type="hidden" name="operation" value="162" />
			</form>
			<br style="clear:both;">
		</div>
	</div>
	
	<!-- END ADVANCED CONFIGURATION -->
	
</div>

<script>
	$('#myTab a').click(function (e) {
	  e.preventDefault()
	  $(this).tab('show')
	});
	
	$('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
	  e.target // newly activated tab
	  e.relatedTarget // previous active tab
	});
</script>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
