
<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>


<%

	List sideButtons = new ArrayList(5);
	sideButtons.add(new UrlAnchorHolder("IP Report", "current", true));

	
//Variables for FAQ
boolean showFAQ = true;
List faqLinks = new ArrayList(3);
FAQHandler.getInstance().displayFAQ(faqLinks, "Reports");
%>

<%@ include file="CommonButtons.jsp" %>
<%@ include file="NewPageHeader.jsp" %>

<%
ArrayList theReport = (ArrayList)request.getAttribute("TheReport");
if(theReport == null){
    out.println("<h1>Internal error occurred. The report object is null<h1>");
    return;
}

String heading = (String)request.getAttribute("Heading");
Set blackedListedIP = (Set)request.getAttribute("BlackListedIP");
%>

<h1>Spammers IP Address</h1>
<br>
<div class="well text-center">This report shows a list of IP address that were used to send spam messages.</div>

<div class="row">
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Usage Tip</div>
			<div class="well-info-body">
				Identifying a spammer is not an easy task. They almost always send emails using an invalid email address
				to avoid getting caught. Therefore, black listing an entire domain is not a very good idea. Besides invalid
				email addresses, they also try to use someone else's server to send emails. Therefore, it is not a very
				good idea to black list an IP address if you have received just a handfull of spam messages.
				
				<p>We recommend that you black list an IP address if you see more than 20 spam messages coming in from
				a server in a week.<p>
			</div>
		</div>
		
		<br style="clear:both;">
		<div class="alert alert-danger">
			<font color="Red"><b>IMPORTANT: </b></font>Sometimes you see IP addresses that belong to your email server
			in this list This could happen when spammers fake your domain names in the sender and those messages return back as
			undeliverables. Make sure NOT to put your own IP Address(es) in the black list.
		</div>
	</div>
	
	<div class="col-md-6">
		<table class="table table-striped table-bordered table-hover table-condensed">
			<tr class="well-info-header">
				<th>IP Address</th>
				<th>Origin Country</th>
				<th># Messages</th>
				<th>Action</th>
			</tr>

		<%
		boolean showAll = request.getParameter("showAll") != null || System.getProperty("display.all.ipaddresses.in.report", "false").equals("true");
				
		String type = (String)request.getAttribute("type");
		String actionText;
		for(int i = 0; i < theReport.size(); i++){
			NameIntegerPair oneRow = (NameIntegerPair)theReport.get(i);
			if(!showAll && i >= 50) break;

			if(blackedListedIP.contains(oneRow.getName())){
				actionText = "Already black listed";
			}else{
				actionText = "<a href=\"FrontController?operation=36&type="+type+"&ip=" + oneRow.getName() + "\">Add in black list</a>";
			}

			String countryName = ResourceBean.getCountryNameFromIP(oneRow.getName());
		%>
		<tr>
		<td><a href="<%=response.encodeURL("FrontController?operation=38") %>&ip=<%=oneRow.getName()%>" target="_blank" alt="WHOIS lookup"><img src="<%= imagePath %>Lookup.gif" border="0"></a><%=oneRow.getName()%></td>
		<td><%=countryName%> </td>
		<td><%=oneRow.getValue()%></td>
		<td><%=actionText%></td>

		</tr>


		<%
		}
		%>

		</table>
	</div>
</div>

<%@ include file="NewPageFooter.jsp" %>
