<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>


<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>
<table width="100%" border="0" cellpadding="0" cellspacing="0">
    <tr align="left" valign="top">
    <td>
<table width="100%" border="0" cellspacing="2" cellpadding="4"><tr><td>

<h1>Trusted Domains for SPF</h1>
<br>
		<%
		String[] allDomains = ResourceBean.getSpfTrustedDomains();

		String domainNames = "";

		if(allDomains != null){


			StringBuffer buffer = new StringBuffer(4096);
			for(int i = 0; i < allDomains.length; i++){

				buffer.append(allDomains[i]).append("\r\n");
			}
			domainNames = buffer.toString();
		}
		%>
		
<div class="well text-center">
	Use of SPF prevents domain forgery. This means that if you trust a domain and that domain publishes SPF records
	in DNS, you can give credit to such messages.
</div>

<div class="row">
	<div class="col-md-6">		
		<div class="well-info-wrap">
			<div class="well-info-header">List of trusted domains</div>
			<div class="well-info-body no-padding">
			<form action="<%= request.getAttribute("appPath") %>" method="post">
				<div class="well-info-additional">
					Enter one domain per line. Every domain that you provide here is
					considered a <em>trusted domain</em>. It only makes sense to put domains that publishes SPF records
					in their DNS.
					<br>
						If you put domain names that do not publish SPF data, <%= productName %> will ignore that entry. To check
						if a particular domain publishes SPF data <a href="<%= response.encodeURL("FrontController?operation=195") %>">click here</a> and run a DNS Lookup query on the domain
				</div>
				
				<textarea rows=15 style="width:100%; padding:10px; border:none;" name="txtTrustedIP"><%=domainNames%></textarea>
				
				<button class="btn btn-sm btn-submit pull-right" style="border-radius:0;" type="submit">Save</button>
				<input type="hidden" name="operation" value="98" />
			</form>
			<br style="clear:both;">
			</div>
		</div>
	</div>
	
	<br class="hide_lg">
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Example</div>
			<div class="well-info-body">
				Assume that you frequently get emails from a domain <b>"trustedDomain.com"</b> and you trust that no one
				from this domain will send you spam messages. In addition, DNS for <b>"trustedDomain.com"</b> is configured
				for SPF records and it publishes a list of IP address(es) that can send emails for this domain.

				<p>
					<%= productName %> will give credit to all emails where the domain name is <b>"trustedDomain.com"</b> and
					the email is coming from one of the published IP address.
				</p>
			</div>
		</div>
		
		<br style="clear:both;">
		<div class="well-info-wrap">
			<div class="well-info-header">Should I mark my domain as trusted?</div>
			<div class="well-info-body">
				Yes. However, create an SPF record first in your DNS. This will prevent
				someone from forging your email address. To learn about how to add an SPF
				record refer to <a href="<%=ResourceBean.getResourceURL()%>Spf.htm"><%= productName %>' web site</a>
			</div>
		</div>	
	</div>
</div>


<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
