<h2>FAQ about Staging Server</h2>
     <ul>
     <li><a href="#What">What is a Staging Server?</a></li>
     <li><a href="#When">When should I use the Staging Server?</a></li>
     <li><a href="#How">Can I use both Staging and Proxy architectures at the same time?</a></li>
     </ul>

     <p>
         &nbsp;
     </p>
     <h3><a name="What"></a>What is a Staging Server?</h3>
     <img src="<%= imagePath %>ProxyVsStaging.gif" alt="Proxy VS Staging architecture"><br><br>
     <%= productName %>, by default, uses a Proxy architecture for receiving e-mails from clients, which
     processes e-mails as they come in and forwards them to the actual SMTP Server. Staging Server
     is an alternate design and may provide certain benefits depending upon your network design.
     The following table discusses the differences between Proxy and Staging server.
     <p>
     <table width="100%" cellspacing="1" bgcolor="Black">
     <tr>
         <th width="50%"><font color="White">Proxy Server</font></th><th width="50%"><font color="White">Staging Server</font></th>
     </tr>

     <tr bgcolor="White">
         <td valign="top">Emails are delivered as they come in</td>
         <td valign="top">Emails are queued and delivered at a later time</td>
     </tr>

     <tr bgcolor="#EDECE3">
         <td valign="top">No need to provide a list of acceptable domain names. It gets this information
         from your corporate SMTP server.</td>
         <td valign="top">You need to provide a list of acceptable domain names.</td>
     </tr>

     <tr bgcolor="White">
         <td valign="top">SMTP authentication is automatically handled for out bound messages.</td>
         <td valign="top">Cannot authenticate users before accepting outbound e-mails. For out-bound messages
         you need to configure <%= productName %> as an open-relay for local IP addresses and block outside IP addresses
         through your firewall.</td>
     </tr>

     <tr bgcolor="#EDECE3">
         <td valign="top"><%= productName %> cannot forward e-mails to multiple servers.</td>
         <td valign="top"><%= productName %> can send e-mails to multiple servers based on the domain name</td>
     </tr>

     <tr bgcolor="White">
         <td valign="top"><%= productName %> cannot be used to filter out-bound e-mails if you use any protocol
             other than SMTP. For example, MS Exchange service.</td>
         <td valign="top">Corporate e-mail server can be configured to send out-bound message via <%= productName %>.
            In case of MS Exchange this is done via Smart Host.</td>
     </tr>


     <!--
     <tr bgcolor="White">
         <td valign="top"></td>
         <td valign="top"></td>
     </tr>

     <tr bgcolor="#EDECE3">
         <td valign="top"></td>
         <td valign="top"></td>
     </tr>

     -->

     </table>

	     <p>&nbsp;</p>
     <h3><a name="When"></a>When should I use the Staging Server?</h3>
     <p>There are a couple of scenarios where you would want to enable <%= productName %>'s Staging Server:
     </p>

     <table width="100%" border="0">
        <tr>
            <td width="50%">
                <p align="center"><b><u>Scenario # 1</u></b></p>
            </td>
            <td width="50%"><p align="center"><b><u>Scenario # 2</u></b></p></td>
        </tr>
     	<tr>
             <td><center><a href="<%= imagePath %>StageBenefits2.gif"><img src="<%= imagePath %>StageBenefits2.gif" alt="Example of Staging Server" width="276" height="161" border="0"/><br>
             <font size="-2">Click here to enlarge</font></a></center></td>
             <td><center><a href="<%= imagePath %>StageBenefits.gif"><img src="<%= imagePath %>StageBenefits.gif" alt="Example of Staging Server" width="276" height="161" border="0"/><br>
             <font size="-2">Click here to enlarge</font></a></center></td>
     	</tr>
        <tr bgcolor="#EDECE3">
            <td valign="top">You have multiple SMTP servers and want to use one <%= productName %> to route your e-mails to these
             servers.<p>Here you configure <%= productName %> to use the Staging server to accept incoming e-mails.
             After filtering the message <%= productName %> sends it to appropriate SMTP server inside your firewall.
             <p>You need to configure <%= productName %> with acceptable domain names and which machine should
                 ultimately receive the message.
             </td>

            <td valign="top">
                Your clients use a protocol other than SMTP to send out-bound messages and you want <%= productName %>
         to filter those messages as well. One such example is Microsoft Exchange where clients use MS Exchange
         service to send out-bound e-mails, which bypasses <%= productName %>. <p>
         In this scenario you assign two IP addresses to the machine where <%= productName %> is running. One IP accepts
         incoming messages and uses the Proxy architecture. The other IP is used for out-bound messages, and uses
         the staging architecture. You also have an option of making the staging server listen on a port other than 25.

            </td>
        </tr>
     </table>
     <p>&nbsp;</p>

     <h3><a name="How"></a>Can I use both Staging and Proxy architectures at the same time?</h3>
     Yes. As long as both servers are listening on a different port (or same port different IP) you can use both of them at the same time.
     Consider the following scenario.

     <p>
     <b><u>Assume that:</u></b>
     <ul>
         <li>You are using Microsoft Exchange</li>
         <li>Your clients use MS Outlook, which is configured to use Exchange Service rather than SMTP
             to send out-bound emails</li>
         <li>Some of your client access their e-mails via "OutLook Web Access"</li>
         </ul>
     </p>

     <table width="100%" cellspacing="1" bgcolor="#CCCCCC">
     <tr>
         <td valign="top" width="20%"><b>Step 1:</b></td><td valign="top">An email comes from the Internet and is intercepted
         by <%= productName %>'s Proxy Server. If it is not spam, message gets forwarded to the SMTP server, which in
         this case is MS Exchange.<br /></td>
     </tr>
     <tr bgcolor="#EEEEEE">
         <td valign="top"><b>Step 2:</b></td><td valign="top">Since Outlook uses Exchange server service <%= productName %>
         never comes into the picture for out-bound message. This problem can be solved by using a staging server.</td>
     </tr>
     <tr>
         <td valign="top"><b>Step 3:</b></td><td valign="top">Configure <%= productName %>'s staging server either on
            a different IP listening on port 25 or on the same IP but different port. Then configure MS Exchange
           to use a Smart Host and specify the IP address where <%= productName %>'s staging server is listening.

           <p>
           <b>VERY, VERY IMPORTANT:</b> Make sure not to configure the Smart Host to send it back to the Proxy server.
           Your e-mail message will get stuck in an infinite loop. <%= productName %> will log warning messages if it
           encounters this scenario.
           </p>

         </td>
     </tr>
     <tr bgcolor="#EDECE3">
         <td valign="top"><b>Step 4:</b></td><td valign="top"><%= productName %> accepts messages through its Staging
         Server and sends the message out on the Internet.</td>
     </tr>
     </table>

     </p>
