<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->




<a href="<%=response.encodeURL("FrontController?operation=2fa") %>">&laquo; Back to 2FA Configuration</a><br><br>


<%
String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%><br><br>
	<div class="alert alert-danger"><h4>Error</h4><%=errorMsg %></div>
	<%
}

String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%><br><br>
	<div class="alert alert-info"><%=infoMsg %></div>
	<%
}
%>

<!-- ******* Create Window Panel ******* -->
<div class="well-info-wrap">
	<div class="well-info-header">Temporary One-Time Password</div>
	<div class="well-info-body">
		
		<h2 class="section-title no-margin-top">TOTP Credentials</h2>
	
	
		<%
		if(request.getAttribute("forcedTotp") != null && request.getAttribute("forcedTotp").equals("true")){
			%>
			<p>
			Your company policy requires you use Two-Factor Authentication when connecting to this server. Please use the following
			QR code to configure it.
			</p>
			<%
		}
		%>
		<div class="well well-sm">Use the following credentials to setup Two-Factor Authentication for Time-base Temporary Password. Several third-party apps support this protocol. For example, 
		you can download either Google Authenticator (available for 
		<a href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2" target="_blank">Android</a> and 
		<a href="https://apps.apple.com/us/app/google-authenticator/id388497605" target="_blank">iOS</a>) or Microsoft Authenticator (available for 
		
		<a href="https://play.google.com/store/apps/details?id=com.azure.authenticator" target="_blank">Android</a> and 
		<a href="https://apps.apple.com/us/app/microsoft-authenticator/id983156458" target="_blank">iOS</a>
		
		)
		on your mobile device and scan the displayed QR code to setup an account</div>
		
		
		<h2>QR Code</h2>
		<img src="<%= request.getAttribute("qrUrl")%>">
		<br><br>
		Scan the QR code above to on your mobile app to add an account
		<br><br>
		
		<h2>Manual Entry</h2>
		Enter the following values manually if you are not able to scan the above code:
		<br><br>
		<table class="table">
			<tr><th>User Name: </th><td><%= request.getAttribute("uid")%></td></tr>
			<tr><th>Secret Key: </th><td><%= request.getAttribute("scode")%></td></tr>
		</table>
		


		<div class="well">
			<h2>Verify TOTP</h2>
			<p>Enter the code you see on your mobile device to confirm it is working.</p>
			<form action="<%= request.getAttribute("appPath") %>" method="post">
			
				<div class="row">
					<div class="col-md-4">
						
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('totpNumber')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-4">TOTP Code</span>
						<input class="form-control form-right pull-left wth-5" type="number" name="totpCode">
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="totpNumber">
							Enter the 6-digit code you see on your mobile device.
						</div>
					</div>
					<div class="col-md-4">
						<button class="btn btn-sm btn-submit" type="submit">Submit</button>
					</div>
				</div>
				<input type="hidden" name="operation" value="2fa">
				<input type="hidden" name="st" value="verify">
			</form>
		</div>
	</div>
</div>






<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
