<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>
<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Manage Temporary Emails</h1>

<%
String errorMsg = (String) request.getAttribute("errorMsg");

if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}

%>

<div class="row">
	<div class="col-md-4">
	
	
		<div  style="padding:20px; border:solid 1px #aaa; background-color:#fbfbfb;">
	
	
			<h2>What Are Temporary Addresses</h2>
			<p>
			Consider you're trying some new merchandise and you don't want to use your real email address during
			this trial period. Temporary email addresses are best for such purposes. 
			</p>
			<p>Benefits are:
			
			<ul>
				<li>Hide your real address</li>
				<li>System automatically replaces your real address with the temporary value during correspondence</li>
				<li>They will cease to exist after some time</li>
			</ul>
			</p>
			<span class="pull-right">
			<a href="http://www.xeams.com/temp-address.htm" title="Watch a short video on this topic"><button class="btn btn-menu">Watch A Video</button></a>
			</span>
			
			<br><br>
			
		</div>
			
	</div>
	<div class="col-md-8">
	
		<div class="well-info-wrap">
			<div class="well-info-header">Add A New Address</div>
			<div class="well-info-body">
			
			<form action="<%= request.getAttribute("appPath") %>" method="post">
	
				<!-- ******* Create Text Input Field ******* -->
				<br style="clear:both;">
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblTempAddr')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Temporary Address</span>
				<input class="form-control form-right pull-left wth-5" 
					type="email" name="newTempAddr" required
					value="<%= request.getAttribute("newTempAddr") == null ? "" : request.getAttribute("newTempAddr") %>"
					>
			
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="lblTempAddr">
					A new temporary address, which you want to use. A random value is automatically created for you, which can be replaced by a custom value.
				</div>
			
			
				<!-- ******* Create Text Input Field ******* -->
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblForeignAddr')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Foreign Address/Domain</span>
				<input class="form-control form-right pull-left wth-5" 
					type="text" 
					name="foreignAddress"
					value="FIRST_DOMAIN"
					>
			
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="lblForeignAddr">
					<p>Full email, domain name of for the vendor. There are four variations of this value:</p>
					<p>
					<ul>
						<li><code>sales@toyotaDealer.com</code> - Full email address</li>
						<li><code>@toyotaDealer.com</code> - Domain names must start with '@' sign.</li>
						<li><code><%=TempEmailTranBean.FIRST_DOMAIN %></code> - Domain name will be assign when first message is received
						<li><code><%=TempEmailTranBean.FIRST_EMAIL %></code> - Email address will be assigned when first message is received
					</ul>
					</p>
					<p>
					The system will automatically use your temporary address when emails are sent or received from this vendor.
					If this value is left blank, no replacement will occur for outbound email.
					</p>
				</div>
				
				
				
				<!-- ******* Create Text Input Field ******* -->
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblExpiresAfter')"><b>?</b></div>
				<span class="form-control form-middle form-text pull-left wth-4">Expires after (number of days)</span>
				<input class="form-control form-right pull-left wth-5" 
					type="number" required
					name="expDays"
					value="90"
					>
			
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="lblExpiresAfter">
					<p>Number of days for this address to last. For example, if you specify 90 for this value, emails sent to 
					this address after 3 months will result in user not found error.
					</p>
				</div>
				
				
				
				
				
				
				
				<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblAutoWhitelist')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-8">Auto Whitelist</span>
				<span class="chkbox-cust form-control form-right pull-left wth-1">
					<input id="chkWhitelisted" name="chkWhitelisted" type="checkbox" checked='checked'>
					<label for="chkWhitelisted"></label>
				</span>
				
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="lblAutoWhitelist">
					If checked, emails from this foreign address will automatically be whitelisted.
				</div>
					
			
			
				<!-- ******* Save Button | default is pulled right ******* -->
				<br style="clear:both;">
				<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
				<br><br>
			
				<input type="hidden" name="operation" value="tmpe4u">
				<input type="hidden" name="st" value="save">
				
			</form>
		</div>
		</div>
	</div>
</div>


<br><br>

<%
 	List<TempEmailTranBean> holders = (List<TempEmailTranBean>) request.getAttribute("holders");
	if(holders != null && holders.size() > 0){
%>
	<!-- ******* Create Window Panel ******* -->
	
	<h2>Existing Addresses</h2>		
	<table class="table table-condensed table-bordered table-hover">
		<thead>
			<th>Temporary Address</th>
			<th>Foreign Address/Domain</th>
			<th>Created On</th>
			<th>Expires On</th>
			<th>Whitelisted</th>
			<th>Action</th>
		</thead>

		<%
		for(TempEmailTranBean oneHolder : holders){
			%>
			
			<tr>
			<td><%= oneHolder.getTempAddress() %></td>
			<td><%= oneHolder.getForeignAddress() %></td>
			<td><%= oneHolder.getCreationDateStr() %></td>
			<td><%= oneHolder.getExpirationDateStr() %></td>
			<td><%= oneHolder.getWhitelisted() %></td>
			<td><a href="<%=response.encodeURL("FrontController?operation=tmpe4u&st=del&id=") + oneHolder.getTransformHeader() %>"><i class="glyphicon glyphicon-trash"></i> Delete</a></td>
			</tr>	
			<%
		}
		%>		
	</table>
		


<%} %>





<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
