<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>STS Policy Editor</h1>



<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}

%>


	<div class="row">
		<div class="col-md-6">
		
		
			<div class="well-info-wrap">
				<div class="well-info-header">Policy Editor</div>
				<div class="well-info-body">
					The STS-Policy for <code><%= request.getAttribute("sd") %></code> is set to the following text.
					<form action="<%= request.getAttribute("appPath") %>" method="post">
					
						<textarea name="p" class="form-control" rows="7" onkeydown="enable_save()"><%= request.getAttribute("p") %></textarea>
						
						<br style="clear:both;">
						<br style="clear:both;">
						<a href="<%=response.encodeURL("FrontController?operation=tlsrpt&sd=" + request.getAttribute("sd")) %>" class="btn btn-sm btn-submit">Cancel</a>
						<button class="btn btn-sm btn-submit pull-right" type="submit" id="savebtn"  disabled="true" >Save</button>
						<br><br>
						
						<input type="hidden" name="operation" value="tlsrpt">
			    		<input type="hidden" name="st" value="cpub">
			    		<input type="hidden" name="sd" value="<%= request.getAttribute("sd") %>">
					</form>
					
					
					<script>
						function enable_save(){
							document.getElementById('savebtn').disabled=false;
						}
					</script>
					
							
					
					<%
					
					if(request.getAttribute("aloe").equals("true")){
						%><h2>Incomplete Tasks</h2><%
						
						
						
						if(request.getAttribute("sphr").equals("false")){
							%>
							<div class="well well-sm">
							<b>DNS Changes for <span style="font-family:monospace">mta-sts.<%= request.getAttribute("sd") %></span></b>
							<p>
							The hostname 
							<code>mta-sts.<%= request.getAttribute("sd") %></code>
							does not exist in your DNS server. </p>
							
							<h3>Steps:</h3>
							<ul>
								<li>You can either add an <b>A</b> record for <code>mta-sts.<%= request.getAttribute("sd") %></code> pointing to the public IP address 
								<%= request.getAttribute("pip") %>
								of Xeams, OR</li>
								<li>Add a CNAME record pointing to the <b>A</b> record <%= request.getAttribute("phn") %> where this server is running.</li>
							</ul>
							
							
							<%
							
							if(request.getAttribute("cname") != null){
								String recType = request.getAttribute("cname").equals("true") ? "cname" : "a";
								out.println(new DnsSubmitter().cpBtn4(request, "mta-sts." + request.getAttribute("sd"), request.getAttribute("pnto").toString(), recType, true));
							}else{
								//A public IP could not be fetched
								out.println(new DnsSubmitter().cpBtn4(request, "mta-sts." + request.getAttribute("sd"), "", "a", true));
							}
							%>
							<br><br> 	 
		  		
							</div>
							<%
						}
						
						
						if(request.getAttribute("sslCertNeeded") != null && request.getAttribute("sslCertNeeded").equals("true")) {
							%>
							<div class="well well-sm">
							<p>
							You will need to recreate the certificate so the hostname <code>mta-sts.<%= request.getAttribute("sd") %></code>
							is added as an <b>Subject Alternate Name (SAN)</b>.</p>
							
							<p><b>Important:</b> Create this SSL certificate after <code>mta-sts.<%= request.getAttribute("sd")%></code> gets resolved either as an "A" or "CNAME" record.
							
							<p>
							<a href="<%=response.encodeURL("FrontController?operation=259&rekey=true&sann=mta-sts." + request.getAttribute("sd") ) %>" target="_blank"
								class="btn btn-menu btn-sm pull-right" title="Click here to issue another certificate that contains this hostname.">Re-issue Certificate</a>
							</p>
							<br><br> 
							</div>
							<%
						}
						
						
						if(request.getAttribute("dnsc").equals("false")){
							%>
							<div class="well well-sm">
							<%@ include file="TlsPendingTaskDnsRecord.jsp" %>
		  					<br><br>
							</div>
							<%
						}
						
						
						if(request.getAttribute("dnsrpt").equals("false")){
							%>
							<div class="well well-sm">
							<%@ include file="TlsPendingTaskReport.jsp" %>
		  					
		  					<br><br>
							</div>
							<%
						}
						
						
						
						
					}else{
						%>
						<div class="well well-sm">
							<h2>Important</h2> 
							MTA-STS is correctly published for <code><%= request.getAttribute("sd") %></code>. If you make any changes to the policy script above, 
							update the TXT record for <code>_mta-sts.<%= request.getAttribute("sd") %></code> to the following value:
							<pre><%= request.getAttribute("sugid") %></pre>
						</div>
						<%
					}
					
					%>
					
					 
				</div>
			</div>
	
	
		</div>
		
		<div  class="col-md-6">
			<h2>Definitions</h2>
			The policy files contains a few keywords that are defined below.
			
			<p><h4>version</h4> 
				<p>
				This needs to be the first line in your policy and must be set to <code>STSv1</code>

				</p>
			</p>
			
			
			<p><h4>mode</h4> This field have 3 values: 
				<p>
				<ul>
					<li><b>testing</b> - Use this initially. Senders on the Internet will send reports allowing you to fix any SSL problems if they exist.</li>
					<li><b>enforce</b> - Senders on the Internet will use encryption. Delivery will fail is encryption cannot be used.</li>
					<li><b>none</b> - Using this will disable MTA-STS for this domain.</li>
				</ul>
				</p>
			</p>
			
			
			
			<p><h4>max_age</h4> 
				<p>
				This value is specified in seconds and defines a period senders should cache your policy on their servers. This must be a value
				between 24 hours (86,400) and one year (31,557,600).

				</p>
			</p>
		</div>
		
		
	</div>

	






<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
