<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Publishing MTA-STS Policy</h1>

<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}

%>



<p>
Other email system on the Internet look for a policy file with the following 
URL:</p>
<pre>https://mta-sts.<%= request.getAttribute("sd") %>/.well-known/mta-sts.txt</pre>
<p>
For example, here are the published policies for 
<a href="https://mta-sts.gmail.com/.well-known/mta-sts.txt" target="_blank">gmail.com</a>, and 
<a href="https://mta-sts.synametrics.com/.well-known/mta-sts.txt" target="_blank">synametrics.com</a>.</p>



<p>The goal is to publish a similar document for <code><%= request.getAttribute("sd") %></code>, which MUST meet the following requirements: </p>
<ul>
	<li>The hostname of the URL must be <code>mta-sts.<%= request.getAttribute("sd") %></code>.</li>
	<li>It must available on HTTPS (Port TCP/443). Using HTTP (80) or a port other than 443 will not work.</li>
	<li>The SSL certificate MUST be valid.</li>
</ul>

<h2>Steps To Publish</h2>
<p>
There are two ways to publish this policy file:
</p>


<div class="row">

	<div class="col-md-6">
		<div class="panel panel-default">
			  <div class="panel-heading"><b>Method 1</b> - With Xeams (<span class="text-success">recommended</span>)</div>
			  <div class="panel-body">
			    <p>The easiest way to publish this file is to use Xeams, which takes following steps in the background:</p>
			    <ul>
			    	<li>Will automatically create necessary SSL certificate for <code>mta-sts.<%= request.getAttribute("sd") %></code>, provided
			    	you're using the Let's Encrypt feature. If you're not using Let's Encrypt, you will have to use a wildcard certificate.</li>
			    	<li>Will automatically publish the file. In other words, the STS policy will be displayed when someone on the Internet
			    	tries to fetch <code>https://mta-sts.<%= request.getAttribute("sd") %>/.well-known/mta-sts.txt</code>.</li> 
			    </ul>
			    
			    <%
			    if(request.getAttribute("httpsOkay").equals("true")){
			    	%>
			    	
			    	<h3>Publish Policy File</h3>
			    	<form action="<%= request.getAttribute("appPath") %>" method="post">
			    	
			    		<!--  
			    		<br style="clear:both;">
						<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('mode')"><b>?</b></div>
						<span class="form-control form-middle form-text pull-left wth-4">Mode</span>
						<select class="form-control form-right pull-left wth-5" name="serverType">
							<option value="testing" selected >Testing</option>
							<option value="enforce"  >Enforce</option>
						</select>
						
						<br style="clear:both;">
						<div class="alert alert-info more_info" id="mode">
							Select <b>Testing</b> initially and watch for errors in the TLS-Report. Switch to <b>enforce</b>
							after some time once no errors are reported.
						</div>
			    		-->
			    	
			    		<br style="clear:both;">
			    		Policy:
			    		<textarea class="form-control" rows="6" name="p"><%= request.getAttribute("sp") %></textarea>
			    		
			    		<br style="clear:both;">
			    		<br style="clear:both;">
			    		<button class="btn btn-sm btn-submit pull-right" type="submit" name="test"><span class="glyphicon glyphicon-flash"></span> Publish</button>
			    		
			    		<input type="hidden" name="operation" value="tlsrpt">
			    		<input type="hidden" name="st" value="cpub">
			    		<input type="hidden" name="sd" value="<%= request.getAttribute("sd") %>">
			    		
			    	</form>
			    	
			    	
			    	<%
			    }else{
			    	%>
			    	<div class="alert alert-danger">
			    	<h4>Error - <small>Prerequisite not met</small></h4> You need to configure Xeams to listen on port 443 for HTTPS. This value currently is set to
			    	<%= request.getAttribute("cp") %>. Go to 
			    	<a href="<%=response.encodeURL("FrontController?operation=158") %>">Server Configuration</a> and change the value for <b>Secure Web Server Port</b> to 443 
			    	before proceeding.
			    	</div>
			    	<%
			    }
			    %>
			    
			  </div>
		</div>
	
	</div>
	

	<div class="col-md-6">
		<div class="panel panel-default">
			  <div class="panel-heading"><b>Method 2</b> - Without Xeams</div>
			  <div class="panel-body">
			    <p>
			    Host this file on any public website. You will have to add a CNAME record in the DNS server. For example, if the address of your corporate
			    website is https://www.<%= request.getAttribute("sd") %>, you will have to add a CNAME record for:
			    <code>mta-sts.<%= request.getAttribute("sd") %></code> that refers to <code>www.<%= request.getAttribute("sd") %></code>. You will have to 
			    use a wildcard SSL certificate so that both hostnames are satisfied.
			    </p>
			    
			    <%
			    if(request.getAttribute("sp") != null){
			    	%>
			    	<p>Here is a suggested policy script.</p>
			    	<pre><%= request.getAttribute("sp") %></pre>
			    	<p>Notice the <b>mode</b> value is set to <b>testing</b>. You run your policy in testing mode initially and change it to <b>enforce</b>
			    	later on.</p>
			    	<%
			    }
			    %>
			    
			  </div>
		</div>
	</div>
	
	
	
	
</div>




<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
