<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>SMTP TLS-Reporting</h1>



<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}


boolean configCompleted = request.getAttribute("dnsc").equals("true");

%>


<!-- ******* Divide Page into Two Columns, Total Widths must Equal 12 (or less) ******* -->
<div class="row">
	<div class="col-md-3">
	
		<form action="<%= request.getAttribute("appPath") %>" method="post">
			<br style="clear:both;">
			<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('lblEnabled')"><b>?</b></div>
				<span class="form-control form-text form-middle pull-left wth-7">MTA-STS Enabled</span>
				<span class="chkbox-cust form-control form-right pull-left wth-2">
					<input id="enabled" type="checkbox" name="enabled"  <%= request.getAttribute("enabled").equals("true") ? " checked " : "" %> >
					<label for="enabled"></label>
				</span>
				<br style="clear:both;">
				<div class="alert alert-info more_info" id="lblEnabled">
					<p>If checked, MTA-STS will be enabled. This means Xeams will require encryption when sending outbound emails to 
					domains that support it. </p>
					<p>Additionally, it will also process TLS-Reporting for your local domains that are  configured to support this feature.</p>
			</div>
			
			
			<br style="clear:both;">
			
			<div>
				<button class="btn btn-sm btn-submit pull-right" type="submit">Submit</button>
			</div>

			<input type="hidden" name="operation" value="tlsrpt">
			<input type="hidden" name="st" value="te">
			
		</form>
		
		<%
		if(request.getAttribute("ore") != null && request.getAttribute("ore").equals("1")){
			%>
			<br style="clear:both;">
			<br><br><br>
			<p><b>NOTE: </b> Outbound reports are enabled.
			<%
		}
		%>
	</div>
	
	<div class="col-md-9">
	
		<div class="well-info-wrap">
			<div class="well-info-header">Definitions</div>
			<div class="well-info-body">
				<h2>What is MTA-STS?</h2>
				<p>
				Mail Transfer Agent-Strict Transport Security (MTA-STS) is a mechanism to enforce encryption when email messages
				are delivered between SMTP servers.
				</p>
				
				<p>Enabling this setting affects both inbound as well as outbound messages. Consider the following scenario: </p>
				<ul>
					<li><b>Outbound - </b> When sending emails to domains like <code>@gmail.com</code>, which supports MTA-STS, your Xeams will 
					ensure encryption is used. Delivery will fail if for any reason encryption cannot be used or runs into an error.
					<br><br>
					</li>
					
					<li><b>Inbound - </b>
					<%
					if(request.getAttribute("tlss").equals("false")){
					%>
					 <code><%= request.getAttribute("sd") %></code> is currently not configured for MTA-STS. Therefore, encryption will not be enforced for inbound emails. 
					 </li>
					<%
					}else{
						%>
						MTA-STS is configured for <code><%= request.getAttribute("sd") %></code>. Details for the report are displayed below.
						<%
					}
					%>
				</ul>
				
				
				<h2>What is TLS Reporting?</h2>
				<p>
				Using TLS reporting (TLS-RPT) other email systems on the Internet, such as Gmail.com or Hotmail.com, can send reports to your Xeams
				containing any delivery problems associated with encryption.
				</p>
				<p>Other email servers will send their reports to <code><%= request.getAttribute("rptusr") %></code>. Emails sent to this address
				will be handled by Xeams automatically. Do not associate this address with any other user.
				</p>
			</div>
		</div>
	
	
	
		
		
		
	</div>
</div>


<%
if(request.getAttribute("noDomains") != null){
	//Happens when no domains are found in Xeams
	
	%>
	
	<br>
	<div class="row">
		<div class="col-md-9 col-md-offset-3" >
			<div class="alert alert-danger">
				<h3>No Domains Found</h3>
				You need to <a href="<%=response.encodeURL("FrontController?operation=533") %>">add at least one domain</a> before configuring MTA-STS.
			</div>
		</div>
	</div>
	<%
}else{
%>


<div class="row">


	<div class="col-md-5 col-md-offset-3" >
		
		<h2>TLS-Report</h2>
		
		<form class="form-inline"  action="<%= request.getAttribute("appPath") %>" method="post">
		<%
		List<String> localDomains = (List<String>) request.getAttribute("lds");
		%>
		
		
		<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('repDomain')"><b>?</b></div>
			<span class="form-control pull-left form-middle form-text wth-5">Domain name</span>
			<select class="form-control pull-left wth-4" name="sd">	
				<%
				for(String domain : localDomains){
					String selected = domain.equals(request.getAttribute("sd")) ? " selected " : "";
					%>
					<option value="<%= domain%>" <%= selected %> ><%=domain %></option>
					<%
				}
				%>
			</select>&nbsp;
			<button type="submit" class="btn btn-default">Display</button>
			
			<br style="clear:both;">
			<div class="alert alert-info more_info" id="repDomain">
				Select the desired domain name to a report.
			</div>
			<input type="hidden" name="operation" value="tlsrpt">
			
			
		</form>	
				
				
		
	</div>
	<div class="col-md-3">
		<%
		if(request.getAttribute("lpp").equals("true")){
			%>
			<h2>&nbsp;</h2>
			
			<span class="pull-right"><a href="<%=response.encodeURL("FrontController?operation=tlsrpt&st=md&sd=") + request.getAttribute("sd") %>" 
				class="btn btn-submit"
				title="Click to modify MTA-STS policy"
				>Modify</a></span>
			<%
		}
			
		%>
		
	</div>
</div>



<div class="row">


 
<div class="col-md-10 col-md-offset-1">
	<%
	if(request.getAttribute("tlss").equals("false")){
		
		
		if(request.getAttribute("nmxf") != null){
			%>
			<div class="alert alert-danger">
				<h3>No MX Found</h3>
				No MX record was found for <code><%= request.getAttribute("sd") %></code>. A valid MX record must exist in your DNS 
				before configuring MTA-STS.
			</div>
			<%
		}else{
			%>
			<div class="alert alert-warning">
				<b>MTA-STS</b> is not configured for this domain. Follow the steps below to configure it. Once done, you will see a 
				report on this page.
			</div>
			<%
		}
		
		%>
		
		
		
		
		
		
		<h3>Configuration Steps:</h3>
		
		<!-- 
		S T E P   1
		+++++++++++
		 -->
		<div class="panel panel-default">
		  <div class="panel-heading"><b>Step 1:</b> Enable STARTTLS for SMTP
		  <%
		  if(request.getAttribute("stlsw").equals("true")){
			  %><span class="pull-right text-success"><i class="glyphicon glyphicon-ok"></i> Completed</span><%
		  }else{
			  %><span class="pull-right text-danger"><i class="glyphicon glyphicon-remove"></i> Incomplete</span><%
		  }
		  %>
		  </div>
		  <div class="panel-body">
		  	<%
		  	if(request.getAttribute("stlsw").equals("true")){
		  		%>
		  		<p>Your Xeams configured to use STARTTLS.</p>
		  		<%
		  	}else{
		  		%>
		  		<p>Xeams is currently
		  		not configured to use STARTTLS for inbound emails. Refer to 
		  		<a href="https://www.xeams.com/starttls.htm" target="_blank">this page</a>
		  		for further instructions.</p> 
		  		<%
		  	}
		  	%>
		    
		  </div>
		</div>
		
		
		<!-- 
		S T E P   2
		+++++++++++
		 -->
		<div class="panel panel-default">
		  <div class="panel-heading"><b>Step 2:</b> Publish <span style="font-family:monospace">mta-sts.txt</span>
		  <%
		  if(request.getAttribute("stsp").equals("true")){
			  %><span class="pull-right text-success"><i class="glyphicon glyphicon-ok"></i> Completed</span><%
		  }else{
			  %><span class="pull-right text-danger"><i class="glyphicon glyphicon-remove"></i> Incomplete</span><%
		  }
		  %>
		  </div>
		  <div class="panel-body">
		  	<%
		  	if(request.getAttribute("stsp").equals("true")){
		  		
		  		if(request.getAttribute("lpp").equals("true")){
		  			%>
			  		<p>Xeams is configured to respond to 
			  		<a href="<%= request.getAttribute("stsurl") %>" target="_blank" ><%= request.getAttribute("stsurl") %></a>, which 
			  		will display the STS policy for <%= request.getAttribute("sd") %>
			  		</p>
			  		<%
		  		}else{
			  		%>
			  		<p>A policy is published and was successfully fetched from 
			  		<a href="<%= request.getAttribute("stsurl") %>" target="_blank" ><%= request.getAttribute("stsurl") %></a>.</p>
			  		<%
		  		}
		  	}else{
		  		%>
		  		<%@ include file="TlsPendingTaskPublishPolicyFile.jsp" %>
				
		  		<%
		  	}
		  	%>
		    
		  </div>
		</div>
		
		<!-- 
		S T E P   3
		+++++++++++
		 -->
		
		<div class="panel panel-default">
		  <div class="panel-heading"><b>Step 3:</b> Add a TXT record in your DNS server for <span style="font-family:monospace">_mta-sts.<%= request.getAttribute("sd") %></span>
		  <%
		  if(configCompleted){
			  %><span class="pull-right text-success"><i class="glyphicon glyphicon-ok"></i> Completed</span><%
		  }else{
			  %><span class="pull-right text-danger"><i class="glyphicon glyphicon-remove"></i> Incomplete</span><%
		  }
		  %>
		  </div>
		  <div class="panel-body">
		  	<%
		  	if(configCompleted){
		  		%>
		  		<p>A TXT record is correctly 
		  		published for <code>_mta-sts.<%= request.getAttribute("sd") %></code>.</p>
		  		<%
		  	}else{
		  		%>
		  		<%@ include file="TlsPendingTaskDnsRecord.jsp" %>
		  		<%
		  	}
		  	%>
		    
		  </div>
		</div>
		
		
		<!-- 
		S T E P   4
		+++++++++++
		 -->
		 
		<div class="panel panel-default">
		  <div class="panel-heading"><b>Step 4:</b> Add a TXT record in your DNS server for TLS-Reporting</span>
		  <%
		  if(request.getAttribute("dnsrpt").equals("true")){
			  %><span class="pull-right text-success"><i class="glyphicon glyphicon-ok"></i> Completed</span><%
		  }else{
			  %><span class="pull-right text-danger"><i class="glyphicon glyphicon-remove"></i> Incomplete</span><%
		  }
		  %>
		  </div>
		  <div class="panel-body">
		  	<%
		  	if(request.getAttribute("dnsrpt").equals("true")){
		  		%>
		  		<p>A TXT record is correctly 
		  		published for <code>_smtp._tls.<%= request.getAttribute("sd") %></code>.</p>
		  		<%
		  	}else{
		  		%>
		  		<%@ include file="TlsPendingTaskReport.jsp" %>
		  		<%
		  	}
		  	%>
		    
		  </div>
		</div>
		
		
		
		<%
	}else{
		
		List<TlsReportBean> report = (List<TlsReportBean>) request.getAttribute("report");
		TlsReportSummaryBean repSummary = (TlsReportSummaryBean) request.getAttribute("repSummary");
		
		%>
		
		<p>

		<table class="table table-bordered table-hover">
			
			
			<thead>
			<tr  class="active">
				<td colspan="5">
					<div class="row">
						<div class="col-md-4">
						<h2>TLS-Report for the past 5 days</h2>
						</div>
						<div class="col-md-4">
							<span class="pull-right">
								<small>
								Domain: <%= request.getAttribute("sd") %><br>
								Number of reports: <%= repSummary.getNumReports() %><br>
								Total reported sessions: <%= repSummary.getTotalSuccessful() + repSummary.getTotalFailed() %><br>
								</small>
							</span>
							
						</div>
						
						<div class="col-md-4">
							<span class="pull-right">
								<small>
								Successful: <%= repSummary.getSuccessfulStr() %><br>
								Failed: <%= repSummary.getFailureStr() %><br>
								
								</small>
							</span>
						</div>
					</div>
				
				</td>
			</tr>
			<tr>
				<th>Organization</th>
				<th>Success</th>
				<th>Failure</th>
				<th>Start Time</th>
				<th>End Time</th>
			</tr>
			</thead>
			<%
			for(TlsReportBean bean : report){
				
				%>
				<tr>
				<td><%= bean.getCompanyName() %></td>
				<td><%= bean.getSuccessCount() %></td>
				<td><%= bean.getFailureCount() %></td>
				<td><%= bean.getStartDateStr() %></td>
				<td><%= bean.getEndDateStr() %></td>
				</tr>
				<%
			}
			%>
		</table>
		</p>
		
		<%
		List<String[]> sfdList = repSummary.getSummariedFailureDetail();
		
		if(sfdList.size() > 0){
			%>
			
			
			<table class="table table-condensed table-bordered table-hover">
				<thead>
				<tr  class="active">
					<td colspan="5">
						<h2>Failure Details</h2>
					</td>
				</tr>
				</thead>
				<tr>
					<th>Failure Description</th>
					<th>First Occurrence</th>
					<th>Last Occurrence</th>
					<th>Total Failures</th>
					<th>Reported by</th>
				</tr>
				<%
				for(String[] oneRow : sfdList){
					%>
					<tr>
						<td><%= oneRow[TlsReportSummaryBean.SI_ERROR_DESC] %></td>
						<td><%= oneRow[TlsReportSummaryBean.SI_FIRST_OCCURANCE] %></td>
						<td><%= oneRow[TlsReportSummaryBean.SI_LAST_OCCURANCE] %></td>
						<td><%= oneRow[TlsReportSummaryBean.SI_TOTAL_FAILURES] %></td>
						<td><%= oneRow[TlsReportSummaryBean.SI_REPORTED_BY] %></td>
					</tr>
					<%
				}
				%>
			</table>
			<%
		}
		%>
		<%
	}
	%>
</div>
</div>

<%
}
%>
<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
