<%@ page import="com.synametrics.xeams.bean.*, com.synametrics.xeams.config.*" %>
<%@ page import="java.util.*" %>




<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>



<!-- 
Product name: <%= productName %>

URL Encoding:
<%=response.encodeURL("FrontController?operation=10&type=subject") %>
 -->

<h1>Troubleshooting Email Delivery</h1>



<%
String infoMsg = (String) request.getAttribute("infoMsg");
if(infoMsg != null){
	%>
	<div class="alert alert-info text-center"><%=infoMsg %></div>
	<%
}


String errorMsg = (String) request.getAttribute("errorMsg");
if(errorMsg != null){
	%>
	<div class="alert alert-danger"><%=errorMsg %></div>
	<%
}

%>

<!-- 
CONSOLE LOG

<%= request.getAttribute("consoleLog") %>

-->

<!-- ******* Divide Page into Two Columns, Total Widths must Equal 12 (or less) ******* -->
<div class="row">
	<div class="col-md-6">
		<div class="well-info-wrap">
			<div class="well-info-header">Search Criteria</div>
			<div class="well-info-body">
			
			
				<form action="<%= request.getAttribute("appPath") %>" method="post">
				
					<!-- Recipient's Email Address -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('rcpt')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-3">Recipient's Email</span>
					<input class="form-control form-right pull-left wth-6" type="email" name="r" required >
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="rcpt">
						Enter the recipient's email address
					</div>
					
					
					<!-- Sender's Email Address -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('from')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-3">Sender's Email</span>
					<input class="form-control form-right pull-left wth-6" type="email" name="s"  required>
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="from">
						Enter the sender's email address
					</div>
					
					
					<!-- Days to go back -->
					<br style="clear:both;">
					<div class="btn btn-info form-control pull-left form-left wth-1" onclick="more_info('days')"><b>?</b></div>
					<span class="form-control form-middle form-text pull-left wth-4">Days to go back</span>
					<input class="form-control form-right pull-left wth-5" type="number" name="d" value="4"  required>
					
					<br style="clear:both;">
					<div class="alert alert-info more_info" id="days">
						Number of days to go back from now.
					</div>
					
					<br style="clear:both;">
					<button class="btn btn-sm btn-submit pull-right" type="submit">Investigate</button>
					
					<input type="hidden" name="st" value="p" >
					<input type="hidden" name="operation" value="tsed" >
					
					<br style="clear:both;">
					

				</form>
			</div>
		</div>
	</div>
	
	
	<div class="col-md-6">
		<div class="alert alert-warning">
			<h4>Usage Tip:</h4>
			<p>
			It is essential to investigate lost messages within a few days. The log files on your Xeams are configured recycle once
			they reach <%= System.getProperty("xeams.max.log.size", "5MB") %>. Therefore, you will lose diagnostic data for older messages.
			</p>
			<p>Refer to <a href="https://www.xeams.com/increaselogsize.htm">this page</a> to increase this value.</p> 


		</div>
	</div>
</div>



<%
	List<TEDResultBean> candidates = (List<TEDResultBean>) request.getAttribute("cand");

	if(candidates != null && candidates.size() == 0){
		%>
		
		<div class="row">
			<div class="col-md-6 col-md-offset-3">
				
				<br><br>
				<div class="panel panel-default">
				  <div class="panel-body">
						<h2>Not Email Found</h2>
						<p>No email was found matching the sender (<code><%= request.getParameter("s") %></code>) and the recipient (<code><%= request.getParameter("r") %></code>) you
						provided within the last <%= request.getParameter("d") %> days.</p>
						
						<p>Try the following tips:</p>
						
						<ul>
							<li>If the message was sent less than a minute ago, wait a few more seconds before searching.</li>
							<li>If you know the sender's IP address, try searching that in <code>SMTPConversation.log</code> by 
								<a href="<%=response.encodeURL("FrontController?operation=196") %>">clicking here</a>. </li>
							<li>You could also look for sender's email address in <code>SMTPConversation.log</code> to see last the last communication
							from this sender. <a href="LogResults.jsp?fileName=logs/SMTPConversation.log&filter=<%= request.getParameter("s")%>">Click here</a> to do that.
						</ul>
					

					</div>
				</div>
			</div>
		</div>
		
		
		<%
	}
	
	if(candidates != null && candidates.size() > 0){

		%>
		
		
<script type="module">
	import mermaid from '/images/mermaid/dist/mermaid.esm.min.mjs';
	mermaid.initialize({ 
		startOnLoad: true,
		theme: 'neutral'
	 });
</script>


		<h2>Search Results</h2>
		
		<div class="table-responsive">
		<table class="table table-bordered">
			<thead>
			<tr>
				<th>Sender</th>
				<th>Recipient</th>
				<th>Date</th>
				<th>Subject</th>
				<th>Status</th>
				<th>Logs</th>
			</tr>
			</thead>
			
			<%
			
			int rowCounter = 1;
			for(TEDResultBean aBean : candidates){
				%>
				<tr class="success">
					<td><b>Result# <%= rowCounter++ %></b></td>
				</tr>
				
				<tr>
				<td><%= aBean.sender %> <!-- LCID: <%= aBean.lcid %> --></td>
				<td><%= aBean.recipient %></td>
				<td><%= aBean.getReceivedOn() %></td>
				<td><%= aBean.subject %></td>
				<td><%= aBean.getStatusStr() %></td>
				<td>
				
					<%
					if(aBean.logUrl == null){
						%>
						N/A
						<%
					}else{
						
						String obLogs = aBean.logUrl;
						if(obLogs.length() > 2){
							//lcid will be set to "#" if not found
							obLogs = response.encodeURL("FrontController" + obLogs); 
						}
						
						%>
						<a href="<%= obLogs %>" target="_blank" title="View delivery log"><i class="glyphicon glyphicon-align-justify"></i> View</a>
						<%
					}
					%>
				</td>
				</tr>
				<tr>
					<td colspan="6"><pre class="mermaid" style="text-align: center"><%= aBean.getMermaidScript() %></pre></td>
				</tr>
				<%
			}
			%>
		
		</table>
		</div>
		
		<%
		if(request.getAttribute("showlegend") != null){
		%>
			<h2>Legend</h2>
			<p>Fields in the <b>Status</b> column have the following definitions.</p>
			<p>
			<table class="table table-bordered">
				<tr>
					<th><%= new TEDResultBean(TEDResultBean.TEDStatus.delivered).getStatusStr() %></th>
					<td>Xeams has successfully delivered the message to the next SMTP server. If the recipient has not received the message, ask them to 
					check their junk folder.</td>
				</tr>
				
				<tr>
					<th><%= new TEDResultBean(TEDResultBean.TEDStatus.quarantined).getStatusStr() %></th>
					<td>Xeams has quarantined this message as junk. Search this message in the <a href="<%=response.encodeURL("FrontController?operation=22") %>">Message Repository</a> and restore it if necessary.</td>
				</tr>
				
				<tr>
					<th><%= new TEDResultBean(TEDResultBean.TEDStatus.queued).getStatusStr() %></th>
					<td>Xeams tried delivering the message but failed at least once. It is currently in the out-bound queue waiting to be delivered again.</td>
				</tr>
				
				<tr>
					<th><%= new TEDResultBean(TEDResultBean.TEDStatus.failed).getStatusStr() %></th>
					<td>Xeams was not able to deliver the message after multiple attempts. Refer to the logs for details.</td>
				</tr>
				
				
			</table>
			</p>
		
		 
		<%
		}
	}
%>  
  




<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
