<%@ page import="java.util.*" %>

<%@ include file="PageHeader.jsp" %>
<%@ include file="SecondPageHeader.jsp" %>

<h1>Trusted IP Addresses</h1>
<br>
<div class="well">
	If an email comes from a trusted IP address <%= productName %> adjusts its adaptive rules and
	remembers the recipients of your message. In future if any of those recipients send an email
	<%= productName %> will decrease its score so that it does not get marked as spam.
</div>

<div class="row">
	<div class="col-md-7">
		<div class="well-info-wrap">
			<div class="well-info-header">Trusted IP Addresses</div>
			<div class="well-info-body no-padding">
				<div class="well-info-additional">
					You should add trusted IP addresses only
					if you are using <%= productName %> for outbound messages. We also recommend that you only trust
					IP Addresses that are inside your firewall.
				</div>
				
				<table class="table table-striped table-bordered table-hover">
					<tr>
						<th>IP Address</th>
						<th>Action</th>
					</tr>


					<%
					String odd = "#FFFFFF";
					String even = "#DDDDDD";
					String bgcolor;
					List ipList = (List)request.getAttribute("IPList");

					if(ipList != null){
						for(int i = 0; i < ipList.size(); i++){
							if((i % 2) == 0){
								bgcolor = odd;
							}else{
								bgcolor = even;
							}


							%>
							<tr bgcolor="<%=bgcolor%>">
								<td><%=ipList.get(i).toString()%></td>
								<td><a href="<%=response.encodeURL("FrontController?operation=113") %>&index=<%=i%>">Remove</a></td>
							</tr>

							<%
						}
					}
					%>
				</table>
			</div>
		</div>
	</div>
	
	<br class="hide_lg">
	<div class="col-md-5">
		<div class="well-info-wrap">
			<div class="well-info-header"><span class="glyphicon glyphicon-plus"></span>Add New Trusted IP</div>
			<div class="well-info-body no-padding" style="padding-bottom:10px;">
				<div class="well-info-additional">
					<ul class="text-left">
					<u>Examples</u>:
					<li>192.168.1.10  &nbsp;&nbsp;&nbsp;(Adds one IP)</li>
					<li>192.168.1.*  &nbsp;&nbsp;&nbsp;&nbsp;(Adds an entire subnet)</li>
					</ul>
				</div>
				
				<div style="padding:10px;">
					<form action="<%= request.getAttribute("appPath") %>" method="post">
						<span class="form-control form-left form-text pull-left wth-4">IP Address</span>
						<input class="form-control form-right pull-left wth-6" input type="text" name="txtIP">
					
						<button class="btn btn-sm btn-submit pull-right" style="margin-right:10px;" value="Add new address" type="submit">Submit</button>
						<input type="hidden" value="114" name="operation"/>
					</form>
				</div>
				<br style="clear:both;">
			</div>
		</div>
	</div>
</div>

<%@ include file="SecondPageFooter.jsp" %>
<%@ include file="PageFooter.jsp" %>
